/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages.ChooseTestCasePage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ComponentNameMappingWizardPage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ParameterNamesMatchingWizardPage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ReplaceExecTestCaseData;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBRuntimeException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageInfo;
import org.eclipse.ui.PlatformUI;

public class SearchReplaceTCRWizard
extends Wizard {
    private static final String CHOOSE_PAGE_ID = "ReplaceTCRWizard.ChoosePageId";
    private static final String COMPONENT_MAPPING_PAGE_ID = "ReplaceTCRWizard.ComponentMappingPageId";
    private static final String PARAMETER_MATCHING_PAGE_ID = "ReplaceTCRWizard.ParameterMatchingPageId";
    private final ReplaceExecTestCaseData m_replaceExecTestCaseData;
    private Map<String, String> m_matchedCompNameGuidMap;
    private ChooseTestCasePage m_choosePage;
    private ComponentNameMappingWizardPage m_componentNamesPage;

    public SearchReplaceTCRWizard(Set<IExecTestCasePO> execsToReplace) {
        this.m_replaceExecTestCaseData = new ReplaceExecTestCaseData(execsToReplace);
        this.setWindowTitle(Messages.ReplaceTCRWizardTitle);
    }

    public boolean performFinish() {
        this.m_matchedCompNameGuidMap = this.m_componentNamesPage.getCompMatching();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new ReplaceTestCaseOperation());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public void addPages() {
        super.addPages();
        HashSet<INodePO> specSet = new HashSet<INodePO>();
        for (IExecTestCasePO exec : this.m_replaceExecTestCaseData.getOldExecTestCases()) {
            if (!ISpecTestCasePO.class.isAssignableFrom(exec.getParentNode().getClass())) continue;
            specSet.add(exec.getParentNode());
        }
        this.m_choosePage = new ChooseTestCasePage(specSet, CHOOSE_PAGE_ID);
        this.m_choosePage.setDescription(Messages.ReplaceTCRWizard_choosePage_multi_description);
        this.m_choosePage.setContextHelpId("org.eclipse.jubula.client.ua.help.searchRefactorReplaceExecutionTestCaseWizardContextId");
        this.m_componentNamesPage = new ComponentNameMappingWizardPage(COMPONENT_MAPPING_PAGE_ID, this.m_replaceExecTestCaseData.getOldExecTestCases());
        this.m_componentNamesPage.setDescription(Messages.ReplaceTCRWizard_matchComponentNames_multi_description);
        this.addPage((IWizardPage)this.m_choosePage);
        this.addPage((IWizardPage)this.m_componentNamesPage);
        this.addPage((IWizardPage)new ParameterNamesMatchingWizardPage(PARAMETER_MATCHING_PAGE_ID, this.m_replaceExecTestCaseData));
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ChooseTestCasePage) {
            this.m_replaceExecTestCaseData.setNewSpecTestCase(this.m_choosePage.getChoosenTestCase());
            this.m_componentNamesPage.setNewSpec(this.m_replaceExecTestCaseData.getNewSpecTestCase());
        }
        IWizardPage nextPage = super.getNextPage(page);
        return nextPage;
    }

    private class ReplaceTestCaseOperation
    implements IRunnableWithProgress {
        private CompNamesBP m_compNamesBP = new CompNamesBP();

        private ReplaceTestCaseOperation() {
        }

        /*
         * Loose catch block
         */
        public void run(IProgressMonitor monitor) {
            block14: {
                monitor.beginTask(Messages.ReplaceTestCasesActionDialog, SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.getOldExecTestCases().size());
                EntityManager session = GeneralStorage.getInstance().getMasterSession();
                try {
                    Persistor.instance().lockPOSet(session, SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.getOldExecTestCases());
                    Persistor.instance().lockPO(session, (IPersistentObject)SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.getNewSpecTestCase());
                    ArrayList<Object> commands = new ArrayList<Object>();
                    for (IExecTestCasePO exec : SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.getOldExecTestCases()) {
                        IExecTestCasePO newExec;
                        INodePO parent = exec.getParentNode();
                        int index = parent.indexOf((INodePO)exec);
                        if (IEventExecTestCasePO.class.isAssignableFrom(exec.getClass())) {
                            IEventExecTestCasePO newEventExec = NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.getNewSpecTestCase(), (INodePO)parent);
                            IEventExecTestCasePO oldEventExec = (IEventExecTestCasePO)exec;
                            newEventExec.setEventType(oldEventExec.getEventType());
                            newEventExec.setReentryProp(oldEventExec.getReentryProp());
                            newEventExec.setMaxRetries(oldEventExec.getMaxRetries());
                            newExec = newEventExec;
                        } else {
                            newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.getNewSpecTestCase());
                        }
                        this.copyPrimitiveMembers(exec, newExec);
                        this.addParametersFromOldToNewTC(exec, newExec);
                        if (exec.getReferencedDataCube() != null && !exec.getReferencedDataCube().equals(exec.getSpecTestCase().getReferencedDataCube())) {
                            newExec.setReferencedDataCube(exec.getReferencedDataCube());
                        }
                        this.addNewCompNamePairs(exec, newExec);
                        commands.add(new MultipleNodePM.DeleteExecTCHandle(exec));
                        commands.add(new MultipleNodePM.AddExecTCHandle(parent, newExec, Integer.valueOf(index)));
                        monitor.worked(1);
                    }
                    MessageInfo errorMessageInfo = MultipleNodePM.getInstance().executeCommands(commands, session);
                    DataEventDispatcher.getInstance().fireProjectLoadedListener(monitor);
                    if (errorMessageInfo != null) {
                        ErrorHandlingUtil.createMessageDialog((Integer)errorMessageInfo.getMessageId(), (Object[])errorMessageInfo.getParams(), null);
                    }
                }
                catch (JBException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                    LockManager.instance().unlockPOs(session);
                    break block14;
                }
                catch (JBRuntimeException e) {
                    ErrorHandlingUtil.createMessageDialog((JBRuntimeException)e);
                    break block14;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    LockManager.instance().unlockPOs(session);
                    break block14;
                }
                {
                    finally {
                        LockManager.instance().unlockPOs(session);
                    }
                }
                LockManager.instance().unlockPOs(session);
            }
            monitor.done();
        }

        private void copyPrimitiveMembers(IExecTestCasePO oldExec, IExecTestCasePO newExec) {
            newExec.setActive(oldExec.isActive());
            newExec.setComment(oldExec.getComment());
            newExec.setDataFile(oldExec.getDataFile());
            newExec.setGenerated(oldExec.isGenerated());
            if (oldExec.getSpecTestCase().getName() != oldExec.getName()) {
                newExec.setName(oldExec.getName());
            }
            newExec.setParentProjectId(oldExec.getParentProjectId());
            newExec.setToolkitLevel(oldExec.getToolkitLevel());
            newExec.setHasReferencedTD(oldExec.getDataManager().equals(oldExec.getSpecTestCase().getDataManager()));
        }

        private void addParametersFromOldToNewTC(IExecTestCasePO oldExec, IExecTestCasePO newExec) {
            if (oldExec.getHasReferencedTD() || oldExec.getReferencedDataCube() != null || SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.hasNoMatching()) {
                return;
            }
            Map<IParamDescriptionPO, IParamDescriptionPO> newOldParamMap = SearchReplaceTCRWizard.this.m_replaceExecTestCaseData.getNewOldParamMap();
            ITDManager tdManager = newExec.getDataManager();
            for (IParamDescriptionPO newParam : newOldParamMap.keySet()) {
                tdManager.addUniqueId(newParam.getUniqueId());
            }
            for (IDataSetPO oldDataSet : oldExec.getDataManager().getDataSets()) {
                ArrayList<String> newRow = new ArrayList<String>(newOldParamMap.size());
                for (IParamDescriptionPO newParam : newOldParamMap.keySet()) {
                    IParamDescriptionPO oldParam = newOldParamMap.get(newParam);
                    if (oldParam != null) {
                        int column = oldExec.getDataManager().findColumnForParam(oldParam.getUniqueId());
                        String oldTestData = oldDataSet.getValueAt(column);
                        newRow.add(oldTestData);
                        continue;
                    }
                    newRow.add("");
                }
                tdManager.insertDataSet(PoMaker.createListWrapperPO(newRow), tdManager.getDataSetCount());
            }
        }

        private IExecTestCasePO addNewCompNamePairs(IExecTestCasePO oldExec, IExecTestCasePO newExec) {
            List compNamePairs = this.m_compNamesBP.getAllCompNamesPairs(newExec);
            block0: for (ICompNamesPairPO newPseudoPairs : compNamePairs) {
                if (!SearchReplaceTCRWizard.this.m_matchedCompNameGuidMap.containsKey(newPseudoPairs.getFirstName())) continue;
                String oldCompName = (String)SearchReplaceTCRWizard.this.m_matchedCompNameGuidMap.get(newPseudoPairs.getFirstName());
                List oldCompNamePairs = this.m_compNamesBP.getAllCompNamesPairs(oldExec);
                for (ICompNamesPairPO oldPair : oldCompNamePairs) {
                    if (!oldPair.getFirstName().equals(oldCompName)) continue;
                    ICompNamesPairPO newPair = PoMaker.createCompNamesPairPO((String)newPseudoPairs.getFirstName(), (String)oldPair.getSecondName(), (String)oldPair.getType());
                    newPair.setPropagated(oldPair.isPropagated());
                    newExec.addCompNamesPair(newPair);
                    continue block0;
                }
            }
            return newExec;
        }
    }
}

