/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.labelprovider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TestResultTreeViewLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    private static Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();

    public void dispose() {
        Iterator<Image> i = imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        imageCache.clear();
    }

    public Image getImage(Object element) {
        TestResultNode resultTest = (TestResultNode)element;
        INodePO node = resultTest.getNode();
        Image image = null;
        if (node instanceof ITestSuitePO) {
            image = IconConstants.TS_IMAGE;
        } else if (node instanceof ITestCasePO) {
            image = IconConstants.TC_IMAGE;
            if (node instanceof IEventExecTestCasePO) {
                image = IconConstants.RESULT_EH_IMAGE;
            }
        } else if (node instanceof ICapPO) {
            TestResultNode parent = resultTest.getParent();
            image = parent.getNode() instanceof IEventExecTestCasePO ? IconConstants.EH_CAP_IMAGE : IconConstants.CAP_IMAGE;
        } else if (node instanceof ICommentPO) {
            image = IconConstants.COMMENT_IMAGE;
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof TestResultNode) {
            TestResultNode resultTest = (TestResultNode)element;
            String name = resultTest.getName();
            if (name != null) {
                return name;
            }
            INodePO node = resultTest.getNode();
            if (node instanceof ITestSuitePO) {
                return "ResultTestSuite";
            }
            if (node instanceof IExecTestCasePO) {
                return "ResultTestCase";
            }
            if (node instanceof ICapPO) {
                return "ResultCap";
            }
        }
        throw this.unknownElement(element);
    }

    public RuntimeException unknownElement(Object element) {
        return new RuntimeException(String.valueOf(Messages.UnknownTypeOfElementInTreeOfType) + element.getClass().getName());
    }

    public String getToolTipText(Object element) {
        if (element instanceof TestResultNode) {
            TestResultNode cfr_ignored_0 = (TestResultNode)element;
            INodePO node = ((TestResultNode)element).getNode();
            if (node instanceof ICommentPO) {
                ICommentPO comment = (ICommentPO)node;
                return comment.getName();
            }
        }
        return super.getToolTipText(element);
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 50;
    }

    public int getToolTipTimeDisplayed(Object object) {
        if (object instanceof ICommentPO) {
            String comment = ((ICommentPO)object).getName();
            int linebreaks = comment.split(String.valueOf(System.lineSeparator()) + "+").length;
            int spaces = comment.split(" +").length;
            return (linebreaks + spaces) * 500;
        }
        return 5000;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getText(element));
        Image image = this.getImage(element);
        cell.setImage(image);
    }
}

