/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.wiki.ui.dialogs;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.utils.DelayableTimer;
import org.eclipse.jubula.client.wiki.ui.Activator;
import org.eclipse.jubula.client.wiki.ui.i18n.Messages;
import org.eclipse.jubula.client.wiki.ui.utils.DescriptionUtil;
import org.eclipse.jubula.client.wiki.ui.utils.ProjectMarkupUtil;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewer;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DescriptionEditDialog
extends TitleAreaDialog {
    private static final String SASH_WEIGHTS = "sashWeights";
    private static final int WAIT_BEFORE_UPDATE = 400;
    private INodePO m_workNode;
    private IDocument m_description;
    private SashForm m_sash;

    public DescriptionEditDialog(Shell parentShell, INodePO workNode) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_workNode = workNode;
        String description = workNode.getDescription();
        if (StringUtils.isBlank((String)description)) {
            description = DescriptionUtil.getReferenceDescription(workNode);
        }
        this.m_description = new Document(description);
    }

    protected Control createDialogArea(Composite parent) {
        String markupLanguage = ProjectMarkupUtil.getProjectMarkupLanguage().getName();
        this.setTitle(Messages.EditDescriptionDialogHeader);
        this.setMessage(NLS.bind((String)Messages.EditDescriptionDialogDescription, (Object)markupLanguage));
        this.getShell().setText(NLS.bind((String)Messages.EditDescriptionDialogTitle, (Object)markupLanguage));
        this.m_sash = new SashForm(parent, 512);
        this.createDialogComponents(this.m_sash);
        IDialogSettings settings = this.getDialogBoundsSettings();
        String[] weights = settings.getArray(SASH_WEIGHTS);
        try {
            if (weights != null) {
                int[] sashWeigths = new int[weights.length];
                int i = 0;
                while (i < weights.length) {
                    sashWeigths[i] = Integer.parseInt(weights[i]);
                    ++i;
                }
                this.m_sash.setWeights(sashWeigths);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        GridData sashGridData = this.createGridData();
        sashGridData.widthHint = 500;
        sashGridData.heightHint = 500;
        this.m_sash.setLayoutData((Object)sashGridData);
        return this.m_sash;
    }

    private void createDialogComponents(SashForm sashForm) {
        int styles = 68162;
        Group sourceGroup = new Group((Composite)sashForm, 16);
        sourceGroup.setText(Messages.EditDescriptionDialogSourceViewer);
        sourceGroup.setLayout((Layout)new GridLayout());
        MarkupSourceViewer sourceViewer = this.createsMarkupSourceViewer((Composite)sourceGroup, styles);
        Group previewGroup = new Group((Composite)sashForm, 16);
        previewGroup.setText(Messages.EditDescriptionDialogPreview);
        previewGroup.setLayout((Layout)new GridLayout());
        MarkupViewer viewer = this.createMarkupViewer((Composite)previewGroup, styles);
        this.addDocumentListenerViewer(sourceViewer, viewer);
    }

    private void addDocumentListenerViewer(MarkupSourceViewer sourceViewer, final MarkupViewer viewer) {
        final DelayableTimer delayedPreviewTimer = new DelayableTimer(400L, new Runnable(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int test = viewer.getTopIndex();
                        viewer.setDocument((IDocument)new Document(DescriptionEditDialog.this.m_description.get()));
                        viewer.setTopIndex(test);
                    }
                });
            }
        });
        this.m_description.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                delayedPreviewTimer.cancel();
                delayedPreviewTimer.schedule();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private MarkupSourceViewer createsMarkupSourceViewer(Composite parent, int styles) {
        MarkupSourceViewer sourceViewer = new MarkupSourceViewer(parent, null, styles, ProjectMarkupUtil.getProjectMarkupLanguage());
        sourceViewer.setDocument(this.m_description);
        MarkupSourceViewerConfiguration sourceViewerConfig = new MarkupSourceViewerConfiguration(null);
        sourceViewer.configure((SourceViewerConfiguration)sourceViewerConfig);
        sourceViewer.getControl().setLayoutData((Object)this.createGridData());
        return sourceViewer;
    }

    private MarkupViewer createMarkupViewer(Composite parent, int styles) {
        MarkupViewer viewer = new MarkupViewer(parent, null, null, true, styles);
        MarkupViewerConfiguration viewerConfiguration = new MarkupViewerConfiguration(viewer);
        viewerConfiguration.setEnableSelfContainedIncrementalFind(true);
        viewerConfiguration.setDisableHyperlinkModifiers(false);
        viewer.configure((SourceViewerConfiguration)viewerConfiguration);
        viewer.setMarkupLanguage(ProjectMarkupUtil.getProjectMarkupLanguage());
        viewer.getControl().setLayoutData((Object)this.createGridData());
        viewer.setDocument((IDocument)new Document(this.m_workNode.getDescription()));
        return viewer;
    }

    private GridData createGridData() {
        GridData areaGridData = new GridData();
        areaGridData.grabExcessVerticalSpace = true;
        areaGridData.grabExcessHorizontalSpace = true;
        areaGridData.horizontalAlignment = 4;
        areaGridData.verticalAlignment = 4;
        return areaGridData;
    }

    public String getDescription() {
        return this.m_description.get();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings bundleDialogSettings = Activator.getActivator().getDialogSettings();
        return DialogSettings.getOrCreateSection((IDialogSettings)bundleDialogSettings, (String)((Object)((Object)this)).getClass().getName());
    }

    public boolean close() {
        int[] sashWeights = this.m_sash.getWeights();
        String[] weights = new String[sashWeights.length];
        int i = 0;
        while (i < sashWeights.length) {
            weights[i] = Integer.toString(sashWeights[i]);
            ++i;
        }
        this.getDialogBoundsSettings().put(SASH_WEIGHTS, weights);
        return super.close();
    }
}

