/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.wiki.ui.handlers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.OpenViewUtils;
import org.eclipse.jubula.client.wiki.ui.dialogs.DescriptionEditDialog;
import org.eclipse.jubula.client.wiki.ui.utils.DescriptionUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditDescriptionHandler
extends AbstractSelectionBasedHandler {
    private static final String OPEN_VIEW_PREF_KEY = "AUTOMATIC_DESCRIPTIONVIEW";

    protected Object executeImpl(ExecutionEvent event) {
        final AbstractJBEditor editor = (AbstractJBEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor != null) {
            editor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                public void run(IPersistentObject workingPo) {
                    IStructuredSelection selection = (IStructuredSelection)editor.getSelection();
                    INodePO workNode = (INodePO)selection.getFirstElement();
                    DescriptionEditDialog dialog = new DescriptionEditDialog(EditDescriptionHandler.this.getActiveShell(), workNode);
                    dialog.setHelpAvailable(true);
                    dialog.create();
                    DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                    Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.editDescriptionDialogContextId");
                    if (dialog.open() == 0) {
                        EditDescriptionHandler.this.performChanges(editor, workNode, dialog);
                    }
                    EditDescriptionHandler.this.checkAndAskForDescriptionView();
                }
            });
        }
        return null;
    }

    private void checkAndAskForDescriptionView() {
        OpenViewUtils.showViewPrompt((String)"org.eclipse.jubula.client.wiki.ui.views.DescriptionView", (String)OPEN_VIEW_PREF_KEY);
    }

    private void performChanges(AbstractJBEditor editor, INodePO workNode, DescriptionEditDialog dialog) {
        if (StringUtils.isBlank((String)workNode.getDescription()) && StringUtils.isBlank((String)dialog.getDescription())) {
            return;
        }
        if (StringUtils.equals((String)workNode.getDescription(), (String)dialog.getDescription()) || StringUtils.equals((String)dialog.getDescription(), (String)DescriptionUtil.getReferenceDescription(workNode))) {
            return;
        }
        workNode.setDescription(dialog.getDescription());
        editor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().dataModified((IPersistentObject)workNode);
    }
}

