/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.examples.extension.rcp.test;

import java.util.Locale;
import org.eclipse.jubula.client.AUT;
import org.eclipse.jubula.client.AUTAgent;
import org.eclipse.jubula.client.MakeR;
import org.eclipse.jubula.client.exceptions.CheckFailedException;
import org.eclipse.jubula.client.launch.AUTConfiguration;
import org.eclipse.jubula.examples.extension.rcp.GroupComponents;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.toolkit.rcp.config.RCPAUTConfiguration;
import org.eclipse.jubula.toolkit.swt.SwtComponents;
import org.eclipse.jubula.toolkit.swt.SwtToolkit;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupTest {
    public static final String AGENT_HOST = "localhost";
    public static final int AGENT_PORT = 60000;
    private AUTAgent m_agent;
    private AUT m_aut;
    private GroupComponents m_gc;
    private static final ComponentIdentifier<?> groupIdentifier = MakeR.createCI((String)"rO0ABXNyAD1vcmcuZWNsaXBzZS5qdWJ1bGEudG9vbHMuaW50ZXJuYWwub2JqZWN0cy5Db21wb25lbnRJZGVudGlmaWVyAAAAAAAABAcCAAlaABRtX2VxdWFsT3JpZ2luYWxGb3VuZEQAEW1fbWF0Y2hQZXJjZW50YWdlSQAhbV9udW1iZXJPZk90aGVyTWF0Y2hpbmdDb21wb25lbnRzTAAYbV9hbHRlcm5hdGl2ZURpc3BsYXlOYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7TAAUbV9jb21wb25lbnRDbGFzc05hbWVxAH4AAUwAFW1fY29tcG9uZW50UHJvcGVydGllc3QAD0xqYXZhL3V0aWwvTWFwO0wAEG1faGllcmFyY2h5TmFtZXN0ABBMamF2YS91dGlsL0xpc3Q7TAAMbV9uZWlnaGJvdXJzcQB+AANMABRtX3N1cHBvcnRlZENsYXNzTmFtZXEAfgABeHAAv/AAAAAAAAD/////cHQAHW9yZy5lY2xpcHNlLnN3dC53aWRnZXRzLkdyb3VwcHNyABNqYXZhLnV0aWwuQXJyYXlMaXN0eIHSHZnHYZ0DAAFJAARzaXpleHAAAAAMdwQAAAAMdAAfb3JnLmVjbGlwc2Uuc3d0LndpZGdldHMuU2hlbGxfMXQAI29yZy5lY2xpcHNlLnN3dC53aWRnZXRzLkNvbXBvc2l0ZV8xcQB+AAlxAH4ACXEAfgAJcQB+AAl0ACNvcmcuZWNsaXBzZS5zd3QuY3VzdG9tLkNUYWJGb2xkZXJfMXQAI29yZy5lY2xpcHNlLnN3dC53aWRnZXRzLkNvbXBvc2l0ZV8ydAA7b3JnLmVjbGlwc2UuanVidWxhLmV4YW1wbGVzLmV4dGVuc2lvbi5yY3AuYXV0LkV4dGVuc2lvblZpZXdxAH4ACXQAFkFVVEV4dGVuc2lvbi5Db21wb3NpdGV0ABlBVVRFeHRlbnNpb24uVmVyc2lvbkdyb3VweHNxAH4ABgAAAAF3BAAAAAF0AB9vcmcuZWNsaXBzZS5zd3Qud2lkZ2V0cy5Hcm91cF8xeHEAfgAF");

    @Before
    public void setUp() throws Exception {
        this.m_agent = MakeR.createAUTAgent((String)AGENT_HOST, (int)60000);
        this.m_agent.connect();
        RCPAUTConfiguration config = new RCPAUTConfiguration("api.aut.conf.rcp.extension", "RCPExampleExtensionAUT", "AUTs\\SimpleAdder\\rcp\\win32\\win32\\x86\\SimpleAdder.exe", "..\\examples\\", null, Locale.getDefault());
        AUTIdentifier id = this.m_agent.startAUT((AUTConfiguration)config);
        if (id != null) {
            ToolkitInfo toolkitInformation = SwtToolkit.createToolkitInformation();
            this.m_gc = new GroupComponents(toolkitInformation);
            this.m_aut = this.m_agent.getAUT(id, this.m_gc.getToolkitInfo());
            this.m_aut.connect();
        } else {
            Assert.fail((String)"AUT start has failed!");
        }
        MenuBarComponent menu = SwtComponents.createMenu();
        this.m_aut.execute(menu.selectMenuEntryByTextpath("Window.*/Show.*View/Extension.*", ValueSets.Operator.matches), (Object)"Open group view");
    }

    @Test
    public void testGroupSpecificAction() throws Exception {
        this.m_aut.execute(this.m_gc.verifyText(groupIdentifier, "Bundle name", ValueSets.Operator.matches), (Object)"Verify group name");
    }

    @Test(expected=CheckFailedException.class)
    public void testExpectedCheckFailed() throws Exception {
        this.m_aut.execute(this.m_gc.verifyText(groupIdentifier, "Bundle version", ValueSets.Operator.matches), (Object)"Verify group name is not version");
    }

    @After
    public void tearDown() throws Exception {
        this.m_aut.disconnect();
        this.m_agent.stopAUT(this.m_aut.getIdentifier());
        this.m_agent.disconnect();
    }
}

