/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.IRobotEventInterceptor;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.driver.MouseMovementStrategy;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.OsNotSupportedException;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.LocalScreenshotUtil;
import org.eclipse.jubula.rc.common.util.PropertyUtil;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.driver.ClickSwtEventMatcher;
import org.eclipse.jubula.rc.swt.driver.DefaultSwtEventMatcher;
import org.eclipse.jubula.rc.swt.driver.KeySwtEventMatcher;
import org.eclipse.jubula.rc.swt.driver.KeyboardHelper;
import org.eclipse.jubula.rc.swt.driver.SwtRobot;
import org.eclipse.jubula.rc.swt.driver.WindowActivationMethod;
import org.eclipse.jubula.rc.swt.tester.SwtApplicationTester;
import org.eclipse.jubula.rc.swt.utils.SwtKeyCodeConverter;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotSwtImpl
implements IRobot<Rectangle> {
    private static AutServerLogger log = new AutServerLogger(RobotSwtImpl.class);
    private SwtAUTServer m_autServer = null;
    private SwtRobot m_robot;
    private KeyboardHelper m_keyboardHelper = null;
    private IRobotEventInterceptor m_interceptor;
    private IEventThreadQueuer m_queuer;

    public RobotSwtImpl(IRobotFactory factory) throws RobotException {
        try {
            this.m_autServer = (SwtAUTServer)AUTServer.getInstance();
            this.m_robot = new SwtRobot(this.m_autServer.getAutDisplay());
            this.m_robot.setAutoWaitForIdle(false);
            this.m_robot.setAutoDelay(0);
        }
        catch (SWTException swte) {
            log.error((Object)swte);
            this.m_robot = null;
            throw new RobotException((Throwable)swte);
        }
        catch (SecurityException se) {
            log.error((Object)se);
            this.m_robot = null;
            throw new RobotException((Throwable)se);
        }
        this.m_interceptor = factory.getRobotEventInterceptor();
        this.m_queuer = factory.getEventThreadQueuer();
    }

    public void setKeyboardLayout(Properties layout) {
        this.m_keyboardHelper = new KeyboardHelper(layout);
    }

    private void clickImpl(Object graphicsComponent, Object constraints, ClickOptions clickOptions) throws RobotException {
        this.clickImpl(graphicsComponent, constraints, clickOptions, 50, false, 50, false);
    }

    private void clickImpl(Object graphicsComponent, Object constraints, ClickOptions clickOptions, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute) throws RobotException {
        Widget component = (Widget)graphicsComponent;
        Rectangle constraintsRect = (Rectangle)constraints;
        this.moveImpl(component, constraintsRect, xPos, xAbsolute, yPos, yAbsolute, clickOptions);
        this.clickImpl(component, clickOptions);
    }

    private void logRobotException(final Object graphicsComponent, RobotException re, final StringBuffer sb) {
        Point mouseCoords = (Point)this.m_queuer.invokeAndWait("get mouse coordinates", (IRunnable)new IRunnable<Point>(){

            public Point run() throws StepExecutionException {
                return RobotSwtImpl.this.m_autServer.getAutDisplay().getCursorLocation();
            }
        });
        Rectangle compBounds = null;
        if (graphicsComponent instanceof Widget) {
            compBounds = (Rectangle)this.m_queuer.invokeAndWait("getBounds", (IRunnable)new IRunnable<Rectangle>(){

                public Rectangle run() throws StepExecutionException {
                    return SwtUtils.getWidgetBounds((Widget)graphicsComponent);
                }
            });
        }
        sb.append("Component: ");
        this.m_queuer.invokeAndWait("appendGraphicsComponent", (IRunnable)new IRunnable<Void>(){

            public Void run() throws StepExecutionException {
                sb.append(graphicsComponent);
                return null;
            }
        });
        sb.append("\n");
        sb.append("Bounds: ");
        sb.append(compBounds);
        sb.append("\n");
        sb.append("Mouse position: ");
        sb.append(mouseCoords);
        log.error((Object)sb.toString(), (Throwable)re);
    }

    public void preMove(final Rectangle constraint) throws RobotException {
        boolean isAlreadyInConstraints = (Boolean)this.m_queuer.invokeAndWait("isAlreadyInConstraints", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                return constraint.contains(RobotSwtImpl.this.m_autServer.getAutDisplay().getCursorLocation());
            }
        });
        if (!isAlreadyInConstraints) {
            Point p = new Point(constraint.x + constraint.width / 2, constraint.y + constraint.height / 2);
            this.m_robot.mouseMove(p.x - 1, p.y - 1);
            this.m_robot.mouseMove(p.x, p.y);
        }
    }

    private boolean isMouseMoveRequired(Point p) {
        boolean result = false;
        Point point = (Point)this.m_queuer.invokeAndWait("isMouseMoveRequired", (IRunnable)new IRunnable<Point>(){

            public Point run() throws StepExecutionException {
                Display d = RobotSwtImpl.this.m_autServer.getAutDisplay();
                return d.getCursorLocation();
            }
        });
        if (point != null) {
            result = !point.equals((Object)p);
            result = true;
        }
        return result;
    }

    private void moveToCenter(Object graphicsComponent) {
        this.moveImpl((Widget)graphicsComponent, null, 50, false, 50, false, ClickOptions.create());
    }

    private void moveImpl(Widget graphicsComponent, Rectangle constraints, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute, ClickOptions clickOptions) throws StepExecutionException {
        Point pointToGo;
        if (clickOptions.isScrollToVisible() && graphicsComponent instanceof Control) {
            this.ensureComponentVisible((Control)graphicsComponent, constraints);
        }
        Rectangle bounds = this.getBounds(graphicsComponent);
        if (constraints != null) {
            if (graphicsComponent instanceof Control) {
                Point convertedLocation = this.convertLocation(constraints, (Control)graphicsComponent);
                bounds.x = convertedLocation.x;
                bounds.y = convertedLocation.y;
            } else {
                bounds.x += constraints.x;
                bounds.y += constraints.y;
            }
            bounds.height = constraints.height;
            bounds.width = constraints.width;
        }
        if (this.isMouseMoveRequired(pointToGo = SwtPointUtil.calculatePointToGo(xPos, xAbsolute, yPos, yAbsolute, bounds))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moving mouse to: " + pointToGo));
            }
            Point initialPoint = (Point)this.m_queuer.invokeAndWait("moveImpl", (IRunnable)new IRunnable<Point>(){

                public Point run() throws StepExecutionException {
                    Display d = RobotSwtImpl.this.m_autServer.getAutDisplay();
                    return d.getCursorLocation();
                }
            });
            if (pointToGo != null && (pointToGo.x < 0 || pointToGo.y < 0)) {
                throw new RobotException("Error occurred while attempting to move the mouse pointer.", EventFactory.createActionError((String)"TestErrorEvent.ClickPointOffscreen", (Object[])new String[]{String.valueOf(pointToGo.x), String.valueOf(pointToGo.y)}));
            }
            java.awt.Point[] path = MouseMovementStrategy.getMovementPath((java.awt.Point)new java.awt.Point(initialPoint.x, initialPoint.y), (java.awt.Point)new java.awt.Point(pointToGo.x, pointToGo.y), (boolean)clickOptions.getStepMovement(), (boolean)clickOptions.getFirstHorizontal());
            int i = 0;
            while (i < path.length) {
                this.m_robot.mouseMove(path[i].x, path[i].y);
                ++i;
            }
            this.logAndCorrectMousePosition(pointToGo);
        }
    }

    private Point convertLocation(final Rectangle constraints, final Control graphicsComponent) {
        Point convertedLocation = (Point)this.m_queuer.invokeAndWait("toDisplay", (IRunnable)new IRunnable<Point>(){

            public Point run() throws StepExecutionException {
                return graphicsComponent.toDisplay(constraints.x, constraints.y);
            }
        });
        if (EnvironmentUtils.isMacOS() && graphicsComponent instanceof org.eclipse.swt.widgets.List) {
            final org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)graphicsComponent;
            Integer correctedYPos = (Integer)this.m_queuer.invokeAndWait("correctedYPos", (IRunnable)new IRunnable<Integer>(){

                public Integer run() throws StepExecutionException {
                    return list.getClientArea().y;
                }
            });
            convertedLocation.y += correctedYPos.intValue();
        }
        return convertedLocation;
    }

    private void logAndCorrectMousePosition(Point pointToGo) {
        String runnableName = "moveImpl.getCursorPoint";
        Point curPoint = (Point)this.m_queuer.invokeAndWait(runnableName, (IRunnable)new IRunnable<Point>(){

            public Point run() throws StepExecutionException {
                Display d = RobotSwtImpl.this.m_autServer.getAutDisplay();
                return d.getCursorLocation();
            }
        });
        if (!curPoint.equals((Object)pointToGo)) {
            log.warn((Object)"Current and end points not equal after mouse move. Waiting 1 second to see if a delay fixes the problem.");
            SwtRobot.delay(1000);
            this.m_robot.waitForIdle();
            curPoint = (Point)this.m_queuer.invokeAndWait(runnableName, (IRunnable)new IRunnable<Point>(){

                public Point run() throws StepExecutionException {
                    Display d = RobotSwtImpl.this.m_autServer.getAutDisplay();
                    return d.getCursorLocation();
                }
            });
            if (!curPoint.equals((Object)pointToGo)) {
                log.warn((Object)"Delay did not fix the problem. Trying to call mouse move one more time with an additional wait afterward.");
                this.m_robot.mouseMove(pointToGo.x, pointToGo.y);
                SwtRobot.delay(1000);
                this.m_robot.waitForIdle();
                SwtRobot.delay(1000);
                curPoint = (Point)this.m_queuer.invokeAndWait(runnableName, (IRunnable)new IRunnable<Point>(){

                    public Point run() throws StepExecutionException {
                        Display d = RobotSwtImpl.this.m_autServer.getAutDisplay();
                        return d.getCursorLocation();
                    }
                });
                if (!curPoint.equals((Object)pointToGo)) {
                    log.error((Object)"Current and end points not equal after mouse move. The mouse pointer could not be correctly moved.");
                }
            }
        }
    }

    public void click(Object graphicsComponent, Rectangle constraints) throws RobotException {
        this.click(graphicsComponent, constraints, ClickOptions.create());
    }

    public void click(Object graphicsComponent, Rectangle constraints, ClickOptions clickOptions) throws RobotException {
        this.clickImpl(graphicsComponent, constraints, clickOptions);
    }

    public void move(Object graphicsComponent, Rectangle constraints) throws RobotException {
        this.moveToCenter(graphicsComponent);
    }

    public void type(final Object graphicsComponent, char character) throws RobotException {
        Validate.notNull((Object)graphicsComponent, (String)"The graphic component must not be null");
        if (EnvironmentUtils.isMacOS() && Character.toLowerCase(character) == 'b') {
            SwtApplicationTester impClass = new SwtApplicationTester();
            impClass.rcNativeInputText(String.valueOf(character));
            return;
        }
        if (this.m_keyboardHelper == null) {
            throw new StepExecutionException("No keyboard layout available.", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedKeyboardLayout"));
        }
        KeyboardHelper.KeyStroke keyStroke = this.m_keyboardHelper.getKeyStroke(character);
        final Integer[] modifiers = keyStroke.getModifiers();
        final char key = keyStroke.getChar();
        InterceptorOptions options = new InterceptorOptions(new long[]{2L});
        DefaultSwtEventMatcher matcher = new DefaultSwtEventMatcher(2);
        IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
        Boolean succeeded = (Boolean)this.m_queuer.invokeAndWait(String.valueOf(this.getClass().getName()) + ".type", (IRunnable)new IRunnable<Boolean>(){

            /*
             * Unable to fully structure code
             */
            public Boolean run() {
                success = Boolean.TRUE;
                try {
                    i = 0;
                    while (i < modifiers.length) {
                        mod = modifiers[i];
                        if (!RobotSwtImpl.access$10(RobotSwtImpl.this, graphicsComponent, mod, '\u0000')) {
                            success = Boolean.FALSE;
                            break;
                        }
                        ++i;
                    }
                    if (!success.booleanValue()) ** break block9
                    if (!RobotSwtImpl.access$10(RobotSwtImpl.this, graphicsComponent, 0, key)) {
                        success = Boolean.FALSE;
                    }
                    break block10;
                }
                finally {
                    if (!RobotSwtImpl.access$9(RobotSwtImpl.this, graphicsComponent, 0, key)) {
                        success = Boolean.FALSE;
                    }
                    i = 0;
                    if (true) ** GOTO lbl29
                }
                {
                    block10: {
                    }
                }
                do {
                    if (!RobotSwtImpl.access$9(RobotSwtImpl.this, graphicsComponent, mod = modifiers[i].intValue(), '\u0000')) {
                        success = Boolean.FALSE;
                    }
                    ++i;
lbl29:
                    // 2 sources

                } while (i < modifiers.length);
                return success;
            }
        });
        if (!succeeded.booleanValue()) {
            String msg = "Failed to type character '" + String.valueOf(character) + "' into component '" + SwtUtils.toString((Widget)graphicsComponent) + "'";
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            throw new RobotException(msg, EventFactory.createActionError((String)"TestErrorEvent.InputFailed"));
        }
        if (key != '9' || !EnvironmentUtils.isMacOS()) {
            confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)matcher);
        } else {
            TimeUtil.delay((long)50L);
        }
    }

    public void type(Object graphicsComponent, String text) throws RobotException {
        if (text != null) {
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                this.type(graphicsComponent, ch);
                ++i;
            }
        }
    }

    public void keyType(Object graphicsComponent, int keycode) throws RobotException {
        try {
            InterceptorOptions options = new InterceptorOptions(new long[]{2L, 1L});
            IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
            try {
                this.m_robot.keyPress(keycode);
            }
            finally {
                this.m_robot.keyRelease(keycode);
            }
            confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new KeySwtEventMatcher(2));
        }
        catch (IllegalArgumentException e) {
            throw new RobotException((Throwable)e);
        }
    }

    public void keyPress(Object graphicsComponent, int keycode) throws RobotException {
        if (!this.post(new KeyCodeTyper(keycode).createKeyDownEvent())) {
            String msg = "Failed to post key event for keycode '" + keycode + "'";
            log.warn((Object)msg);
            throw new RobotException(msg, EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
        }
    }

    public void keyRelease(Object graphicsComponent, int keycode) throws RobotException {
        if (!this.post(new KeyCodeTyper(keycode).createKeyUpEvent())) {
            String msg = "Failed to post key event for keycode '" + keycode + "'";
            log.warn((Object)msg);
            throw new RobotException(msg, EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
        }
    }

    private List<AbstractKeyTyper> modifierKeyTypers(KeyStroke keyStroke) {
        LinkedList<AbstractKeyTyper> l = new LinkedList<AbstractKeyTyper>();
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 8) != 0) {
            l.add(new KeyCodeTyper(65536));
        }
        if ((modifiers & 2) != 0) {
            l.add(new KeyCodeTyper(262144));
        }
        if ((modifiers & 1) != 0) {
            l.add(new KeyCodeTyper(131072));
        }
        if ((modifiers & 4) != 0) {
            l.add(new KeyCodeTyper(0x400000));
        }
        return l;
    }

    private static AbstractKeyTyper getBaseKeyTyper(String keyStrokeSpec) {
        String[] specElements = keyStrokeSpec.split(" ");
        String baseKey = specElements[specElements.length - 1];
        int code = SwtKeyCodeConverter.getKeyCode(baseKey);
        if (code == -1) {
            return new KeyCharTyper(RobotSwtImpl.getOSSspecificSpecBaseCharacter(SwtKeyCodeConverter.getKeyChar(baseKey).charValue()));
        }
        return new KeyCodeTyper(code);
    }

    public void keyStroke(final String keyStrokeSpec) throws RobotException {
        KeyStroke keyStroke = this.getKeyStroke(keyStrokeSpec);
        List<AbstractKeyTyper> keyTyperList = this.modifierKeyTypers(keyStroke);
        keyTyperList.add(RobotSwtImpl.getBaseKeyTyper(keyStrokeSpec));
        this.m_robot.setAutoWaitForIdle(true);
        final HashSet<AbstractKeyTyper> alreadyDown = new HashSet<AbstractKeyTyper>();
        final ListIterator<AbstractKeyTyper> i = keyTyperList.listIterator();
        InterceptorOptions options = new InterceptorOptions(new long[]{2L});
        try {
            this.m_queuer.invokeAndWait(String.valueOf(this.getClass().getName()) + ".type", (IRunnable)new IRunnable<Boolean>(){

                public Boolean run() {
                    boolean success = true;
                    while (i.hasNext()) {
                        AbstractKeyTyper keyTyper = (AbstractKeyTyper)i.next();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("trying to press: " + keyTyper));
                        }
                        if (alreadyDown.contains(keyTyper)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("pressing: " + keyTyper));
                        }
                        if (!RobotSwtImpl.this.post(keyTyper.createKeyDownEvent())) {
                            success = false;
                        }
                        alreadyDown.add(keyTyper);
                    }
                    if (!success) {
                        String msg = "Failed to post keystroke '" + keyStrokeSpec + "'";
                        if (log.isWarnEnabled()) {
                            log.warn((Object)msg);
                        }
                        throw new RobotException(msg, EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
                    }
                    return success;
                }
            });
        }
        finally {
            this.releaseKeys(options, alreadyDown, i);
        }
    }

    private KeyStroke getKeyStroke(String keyStrokeSpec) throws RobotException {
        KeyStroke keyStroke;
        if (keyStrokeSpec.length() == 1) {
            char singeKeyStrokeSpecChar = keyStrokeSpec.charAt(0);
            singeKeyStrokeSpecChar = RobotSwtImpl.getOSSspecificSpecBaseCharacter(singeKeyStrokeSpecChar);
            keyStroke = KeyStroke.getKeyStroke(singeKeyStrokeSpecChar);
        } else {
            int keyStrokeSpecSize = keyStrokeSpec.length();
            char keySpec = keyStrokeSpec.charAt(keyStrokeSpecSize - 1);
            if ('\ufffd' != keySpec) {
                keySpec = Character.toUpperCase(keySpec);
            }
            String modifiedKeyStrokeSpec = String.valueOf(keyStrokeSpec.substring(0, keyStrokeSpecSize - 1)) + keySpec;
            keyStroke = KeyStroke.getKeyStroke(modifiedKeyStrokeSpec);
        }
        if (keyStroke == null) {
            String msg = "Failed to post keystroke '" + keyStrokeSpec + "'";
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            throw new RobotException(msg, EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        return keyStroke;
    }

    private static char getOSSspecificSpecBaseCharacter(char character) {
        if (EnvironmentUtils.isMacOS() && Character.isUpperCase(character)) {
            return Character.toLowerCase(character);
        }
        return character;
    }

    private void ensureComponentVisible(final Control component, Rectangle bounds) throws RobotException {
        Rectangle rectangle = bounds;
        if (rectangle == null) {
            rectangle = (Rectangle)this.m_queuer.invokeAndWait("getRelativeWidgetBounds", (IRunnable)new IRunnable<Rectangle>(){

                public Rectangle run() throws StepExecutionException {
                    return SwtUtils.getRelativeWidgetBounds((Widget)component, component);
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scrolling rectangle to visible: " + rectangle));
        }
        Scroller scroller = new Scroller(component);
        scroller.scrollRectToVisible(rectangle);
    }

    public void scrollToVisible(Object graphicsComponent, Rectangle constraints) throws RobotException {
        if (graphicsComponent instanceof Control) {
            this.ensureComponentVisible((Control)graphicsComponent, constraints);
        }
    }

    public void activateApplication(String method) throws RobotException {
        try {
            final Shell window = this.getActiveWindow();
            if (window == null) {
                throw new RobotException("No AUT window is available.", EventFactory.createImplClassErrorEvent());
            }
            WindowActivationMethod wam = WindowActivationMethod.createWindowActivationMethod(method, this.m_robot, this.m_queuer);
            wam.activate(window);
            Shell activeWindow = (Shell)this.m_queuer.invokeAndWait("getActiveWindow", (IRunnable)new IRunnable<Shell>(){

                public Shell run() throws StepExecutionException {
                    return window.getDisplay().getActiveShell();
                }
            });
            if (activeWindow != window) {
                throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.WindowActivationFailed", (boolean)true), EventFactory.createActionError((String)"TestErrorEvent.WindowActivationFailed"));
            }
        }
        catch (Exception exc) {
            throw new RobotException((Throwable)exc);
        }
    }

    public Shell getActiveWindow() {
        return (Shell)this.m_queuer.invokeAndWait("getActiveWindow", (IRunnable)new IRunnable<Shell>(){

            public Shell run() throws StepExecutionException {
                Display autDisplay = RobotSwtImpl.this.m_autServer.getAutDisplay();
                Shell activeShell = autDisplay.getActiveShell();
                if (activeShell == null) {
                    Shell[] existingShells = autDisplay.getShells();
                    int i = 0;
                    while (i < existingShells.length) {
                        Shell shell = existingShells[i];
                        if (shell.isVisible()) {
                            activeShell = shell;
                            break;
                        }
                        ++i;
                    }
                    if (activeShell == null && existingShells.length > 0) {
                        activeShell = existingShells[0];
                    }
                }
                return activeShell;
            }
        });
    }

    public void keyToggle(Object obj, int key, boolean activated) throws OsNotSupportedException {
        if (activated && this.isActivated(key) || !activated && !this.isActivated(key)) {
            return;
        }
        LinkedList<KeyCodeTyper> keyTyperList = new LinkedList<KeyCodeTyper>();
        keyTyperList.add(new KeyCodeTyper(key));
        this.m_robot.setAutoWaitForIdle(true);
        final HashSet<AbstractKeyTyper> alreadyDown = new HashSet<AbstractKeyTyper>();
        final ListIterator<AbstractKeyTyper> i = keyTyperList.listIterator();
        InterceptorOptions options = new InterceptorOptions(new long[]{2L});
        try {
            try {
                while (i.hasNext()) {
                    this.m_queuer.invokeAndWait(String.valueOf(this.getClass().getName()) + ".type", (IRunnable)new IRunnable<Void>(){

                        public Void run() {
                            AbstractKeyTyper keyTyper = (AbstractKeyTyper)i.next();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("trying to press: " + keyTyper));
                            }
                            if (!alreadyDown.contains(keyTyper)) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("pressing: " + keyTyper));
                                }
                                RobotSwtImpl.this.post(keyTyper.createKeyDownEvent());
                                alreadyDown.add(keyTyper);
                            }
                            return null;
                        }
                    });
                    TimeUtil.delay((long)20L);
                }
            }
            catch (IllegalArgumentException e) {
                throw new RobotException((Throwable)e);
            }
        }
        finally {
            this.releaseKeys(options, alreadyDown, i);
        }
    }

    private boolean isActivated(int key) throws OsNotSupportedException {
        if (SWT.getPlatform().equals("win32")) {
            try {
                return this.isActivatedWIN(key);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        } else {
            if (SWT.getPlatform().equals("motif")) {
                return this.isActivatedMOTIF(key);
            }
            if (SWT.getPlatform().equals("gtk")) {
                return this.isActivatedGTK(key);
            }
        }
        throw new OsNotSupportedException("Current os \"" + SWT.getPlatform() + "\" is not supported.", MessageIDs.E_UNSUPPORTED_OS);
    }

    private boolean isActivatedWIN(int key) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        String className = "org.eclipse.swt.internal.win32.OS";
        Class<?> clazz = Class.forName(className);
        int osSpecificKey = -1;
        switch (key) {
            case 16777299: {
                osSpecificKey = clazz.getDeclaredField("VK_NUMLOCK").getInt(null);
                break;
            }
            case 16777298: {
                osSpecificKey = clazz.getDeclaredField("VK_CAPITAL").getInt(null);
                break;
            }
            case 16777300: {
                osSpecificKey = clazz.getDeclaredField("VK_SCROLL").getInt(null);
                break;
            }
        }
        String methodName = "GetKeyState";
        Class[] params = new Class[]{Integer.TYPE};
        Object[] args = new Object[]{new Integer(osSpecificKey)};
        Method method = clazz.getMethod(methodName, params);
        short keyState = (Short)method.invoke(clazz, args);
        return keyState == 1;
    }

    private boolean isActivatedGTK(int key) {
        throw new UnsupportedOperationException("OS.GetKeyState");
    }

    private boolean isActivatedMOTIF(int key) {
        throw new UnsupportedOperationException("OS.GetKeyState");
    }

    private int getButtonMask(int button) {
        if (button == ValueSets.InteractionMode.primary.rcIntValue()) {
            return 524288;
        }
        if (button == ValueSets.InteractionMode.tertiary.rcIntValue()) {
            return 0x100000;
        }
        if (button == ValueSets.InteractionMode.secondary.rcIntValue()) {
            return 0x200000;
        }
        throw new RobotException("unsupported mouse button", null);
    }

    public void clickAtCurrentPosition(Object graphicsComponent, int clickCount, int button) {
        this.clickImpl(graphicsComponent, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    public java.awt.Point getCurrentMousePosition() {
        java.awt.Point currentPos = (java.awt.Point)this.m_queuer.invokeAndWait("getCursorPosition", (IRunnable)new IRunnable<java.awt.Point>(){

            public java.awt.Point run() throws StepExecutionException {
                Display d = RobotSwtImpl.this.m_autServer.getAutDisplay();
                Point cursorLocation = d.getCursorLocation();
                return new java.awt.Point(cursorLocation.x, cursorLocation.y);
            }
        });
        return currentPos;
    }

    public boolean isMouseInComponent(Object graphicsComponent) {
        boolean y2;
        final Widget comp = (Widget)graphicsComponent;
        java.awt.Point currentMousePosition = this.getCurrentMousePosition();
        Point currMousePos = new Point(currentMousePosition.x, currentMousePosition.y);
        Rectangle bounds = (Rectangle)this.m_queuer.invokeAndWait("getBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                return SwtUtils.getWidgetBounds(comp);
            }
        });
        Point treeLocUpperLeft = new Point(bounds.x, bounds.y);
        Point treeLocLowerRight = new Point(bounds.width + treeLocUpperLeft.x, bounds.height + treeLocUpperLeft.y);
        boolean x1 = currMousePos.x >= treeLocUpperLeft.x;
        boolean x2 = currMousePos.x < treeLocLowerRight.x;
        boolean y1 = currMousePos.y >= treeLocUpperLeft.y;
        boolean bl = y2 = currMousePos.y < treeLocLowerRight.y;
        return x1 && x2 && y1 && y2;
    }

    private void releaseKeys(InterceptorOptions options, final Set<AbstractKeyTyper> alreadyDown, final ListIterator<AbstractKeyTyper> i) {
        block3: {
            final HashSet alreadyUp = new HashSet();
            try {
                while (i.hasPrevious()) {
                    IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
                    this.m_queuer.invokeAndWait(String.valueOf(this.getClass().getName()) + ".type", (IRunnable)new IRunnable<Void>(){

                        public Void run() {
                            AbstractKeyTyper keyTyper = (AbstractKeyTyper)i.previous();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("trying to release: " + keyTyper));
                            }
                            if (alreadyDown.contains(keyTyper) && !alreadyUp.contains(keyTyper)) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("releasing: " + keyTyper));
                                }
                                RobotSwtImpl.this.post(keyTyper.createKeyUpEvent());
                                alreadyUp.add(keyTyper);
                            }
                            return null;
                        }
                    });
                    confirmer.waitToConfirm(null, (IEventMatcher)new KeySwtEventMatcher(2));
                }
            }
            catch (RobotException e) {
                log.error((Object)"error releasing keys", (Throwable)e);
                if (i.hasPrevious()) break block3;
                throw e;
            }
        }
    }

    public String getSystemModifierSpec() {
        String keyStrokeSpec = ValueSets.Modifier.control.rcValue();
        if (SWT.MOD1 == 0x400000) {
            keyStrokeSpec = ValueSets.Modifier.meta.rcValue();
        } else if (SWT.MOD1 == 65536) {
            keyStrokeSpec = ValueSets.Modifier.alt.rcValue();
        }
        return keyStrokeSpec;
    }

    private Rectangle getBounds(final Widget component) {
        return (Rectangle)this.m_queuer.invokeAndWait("getBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                return SwtUtils.getWidgetBounds(component);
            }
        });
    }

    private boolean postKeyPress(Object graphicsComponent, int modifier, char character) {
        Event event = this.createUntypedEvent((Widget)graphicsComponent, modifier, character);
        event.type = 1;
        return this.post(event);
    }

    private boolean postKeyRelease(Object graphicsComponent, int modifier, char character) {
        Event event = this.createUntypedEvent((Widget)graphicsComponent, modifier, character);
        event.type = 2;
        return this.post(event);
    }

    private Event createUntypedEvent(Widget graphicsComponent, int modifier, char character) {
        Event event = new Event();
        event.keyCode = modifier;
        event.character = character;
        event.widget = graphicsComponent;
        return event;
    }

    private boolean post(Event event) {
        try {
            Display display = this.m_autServer.getAutDisplay();
            if (!display.post(event)) {
                String msg = "posting event failed: " + event;
                log.error((Object)msg);
                return false;
            }
        }
        catch (SWTError swte) {
            log.error((Object)swte);
            throw new RobotException((Throwable)swte);
        }
        return true;
    }

    public void mousePress(Object graphicsComponent, Rectangle constraints, int button) throws RobotException {
        if (graphicsComponent != null) {
            this.move(graphicsComponent, constraints);
        }
        RobotTiming.sleepPreClickDelay();
        this.m_robot.mousePress(this.getButtonMask(button));
    }

    public void mouseRelease(Object graphicsComponent, Rectangle constraints, int button) throws RobotException {
        if (graphicsComponent != null) {
            this.move(graphicsComponent, constraints);
        }
        RobotTiming.sleepPreClickDelay();
        this.m_robot.mouseRelease(this.getButtonMask(button));
    }

    private void clickImpl(Object graphicsComponent, ClickOptions clickOptions) {
        block8: {
            int buttonMask = this.getButtonMask(clickOptions.getMouseButton());
            int clickCount = clickOptions.getClickCount();
            int[] modifierMask = this.getModifierMask(clickOptions.getClickModifier());
            if (clickCount > 0) {
                ClickSwtEventMatcher matcher = new ClickSwtEventMatcher(clickOptions);
                IRobotEventConfirmer confirmer = null;
                if (clickOptions.isConfirmClick()) {
                    InterceptorOptions options = new InterceptorOptions(new long[]{4L, 3L});
                    confirmer = this.m_interceptor.intercept(options);
                }
                try {
                    this.pressModifier(modifierMask);
                    RobotTiming.sleepPreClickDelay();
                    int i = 0;
                    while (i < clickCount) {
                        this.m_robot.mousePress(buttonMask);
                        RobotTiming.sleepPostMouseDownDelay();
                        this.m_robot.mouseRelease(buttonMask);
                        RobotTiming.sleepPostMouseUpDelay();
                        ++i;
                    }
                    if (confirmer == null) break block8;
                    try {
                        confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)matcher);
                    }
                    catch (RobotException re) {
                        StringBuffer sb = new StringBuffer("Robot exception occurred while clicking...\n");
                        this.logRobotException(graphicsComponent, re, sb);
                        throw re;
                    }
                }
                finally {
                    this.releaseModifier(modifierMask);
                }
            }
        }
    }

    private int[] getModifierMask(ClickOptions.ClickModifier clickModifier) {
        int[] modifier = new int[]{};
        if (clickModifier.hasModifiers(1)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwtUtils.getSystemDefaultModifier());
        }
        if (clickModifier.hasModifiers(2)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwtUtils.getSystemModifier2());
        }
        if (clickModifier.hasModifiers(4)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwtUtils.getSystemModifier3());
        }
        if (clickModifier.hasModifiers(8)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwtUtils.getSystemModifier4());
        }
        return modifier;
    }

    private void pressModifier(int[] modifierMask) {
        int i = 0;
        while (i < modifierMask.length) {
            this.keyPress(null, modifierMask[i]);
            ++i;
        }
    }

    private void releaseModifier(int[] modifierMask) {
        int i = 0;
        while (i < modifierMask.length) {
            this.keyRelease(null, modifierMask[i]);
            ++i;
        }
    }

    public void click(Object graphicsComponent, Rectangle constraints, ClickOptions clickOptions, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute) throws RobotException {
        this.clickImpl(graphicsComponent, constraints, clickOptions, xPos, xAbsolute, yPos, yAbsolute);
    }

    public String getPropertyValue(Object graphicsComponent, String propertyName) throws RobotException {
        return PropertyUtil.getPropertyValue((Object)graphicsComponent, (String)propertyName);
    }

    public BufferedImage createFullScreenCapture() {
        return LocalScreenshotUtil.createFullScreenCapture();
    }

    static /* synthetic */ boolean access$9(RobotSwtImpl robotSwtImpl, Object object, int n, char c) {
        return robotSwtImpl.postKeyRelease(object, n, c);
    }

    static /* synthetic */ boolean access$10(RobotSwtImpl robotSwtImpl, Object object, int n, char c) {
        return robotSwtImpl.postKeyPress(object, n, c);
    }

    private static abstract class AbstractKeyTyper {
        private AbstractKeyTyper() {
        }

        public Event createKeyDownEvent() {
            return this.createKeyEvent(1);
        }

        public Event createKeyUpEvent() {
            return this.createKeyEvent(2);
        }

        private Event createKeyEvent(int eventType) {
            Event ke = new Event();
            ke.type = eventType;
            ke.time = (int)System.currentTimeMillis();
            this.assignKey(ke);
            return ke;
        }

        protected abstract void assignKey(Event var1);
    }

    private static class KeyCharTyper
    extends AbstractKeyTyper {
        private char m_keyChar;

        public KeyCharTyper(char keyChar) {
            this.m_keyChar = keyChar;
        }

        public void assignKey(Event keyEvent) {
            keyEvent.character = this.m_keyChar;
        }
    }

    private static class KeyCodeTyper
    extends AbstractKeyTyper {
        private int m_keyCode;

        public KeyCodeTyper(int keyCode) {
            this.m_keyCode = keyCode;
        }

        public void assignKey(Event keyEvent) {
            keyEvent.keyCode = this.m_keyCode;
        }
    }

    private class Scroller {
        private Control m_component;

        public Scroller(Control component) {
            this.m_component = component;
        }

        public void scrollRectToVisible(final Rectangle aRect) {
            RobotSwtImpl.this.m_queuer.invokeAndWait("scrollToComponent", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    Point currentPoint = new Point(aRect.x, aRect.y);
                    if (Scroller.this.m_component instanceof Scrollable) {
                        Scrollable scrollable = (Scrollable)Scroller.this.m_component;
                        currentPoint.x = Scroller.this.scroll(currentPoint.x, scrollable.getHorizontalBar());
                        currentPoint.y = Scroller.this.scroll(currentPoint.y, scrollable.getVerticalBar());
                    }
                    Control current = Scroller.this.m_component;
                    while (current.getParent() != null) {
                        Composite currentParent = current.getParent();
                        currentPoint.x = Scroller.this.scroll(currentPoint.x, currentParent.getHorizontalBar());
                        currentPoint.y = Scroller.this.scroll(currentPoint.y, currentParent.getVerticalBar());
                        currentPoint = current.getDisplay().map(current, (Control)currentParent, currentPoint);
                        current = current.getParent();
                    }
                    return null;
                }
            });
        }

        private int scroll(int scrollTarget, ScrollBar scrollBar) {
            if (scrollBar != null && !scrollBar.isDisposed()) {
                int oldScrollLoc = scrollBar.getSelection();
                scrollBar.setSelection(scrollTarget);
                Event selectionEvent = new Event();
                selectionEvent.type = 13;
                selectionEvent.widget = scrollBar;
                selectionEvent.detail = 0;
                selectionEvent.time = (int)System.currentTimeMillis();
                selectionEvent.display = scrollBar.getDisplay();
                scrollBar.notifyListeners(13, selectionEvent);
                return scrollTarget - (scrollBar.getSelection() - oldScrollLoc);
            }
            return scrollTarget;
        }
    }
}

