/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ChildTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.ParentTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.SiblingTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StandardDepthFirstTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITreeComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.components.SWTCell;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.tree.TableTreeOperationContext;
import org.eclipse.jubula.rc.swt.tester.tree.ToggleCheckboxOperation;
import org.eclipse.jubula.rc.swt.tester.tree.TreeOperationContext;
import org.eclipse.jubula.rc.swt.tester.tree.VerifyCheckboxOperation;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeTester
extends AbstractTreeTester {
    private Tree getTree() {
        return (Tree)this.getComponent().getRealComponent();
    }

    public void rcVerifyTextAtMousePosition(String pattern, String operator) {
        TreeItem itemAtMousePosition = (TreeItem)this.getNodeAtMousePosition();
        int column = this.getMouseColumn();
        TableTreeOperationContext context = column != -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), column) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        Verifier.match((String)context.getRenderedText(itemAtMousePosition), (String)pattern, (String)operator);
    }

    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treePath, String operator) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
        this.rcSelect(pathType, preAscend, treePath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treePath, String operator, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("rcDropByTextPath - perform drag", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    return null;
                }
            });
            Event wakeEvent = new Event();
            wakeEvent.type = 5;
            this.getTree().getDisplay().post(wakeEvent);
            this.waitForDisplayUpdate();
            this.rcSelect(pathType, preAscend, treePath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
            TreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
        }
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String indexPath) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
        this.rcSelectByIndices(pathType, preAscend, indexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String indexPath, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("rcDropByIndexPath - perform drag", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    return null;
                }
            });
            Event wakeEvent = new Event();
            wakeEvent.type = 5;
            this.getTree().getDisplay().post(wakeEvent);
            this.waitForDisplayUpdate();
            this.rcSelectByIndices(pathType, preAscend, indexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
            TreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
        }
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        return this.getEventThreadQueuer().invokeAndWait("getItemAtMousePosition", (IRunnable)new IRunnable<TreeItem>(){

            public TreeItem run() throws StepExecutionException {
                Point mousePos = SwtUtils.convertToSwtPoint(TreeTester.this.getRobot().getCurrentMousePosition());
                ItemAtPointTreeNodeOperation op = new ItemAtPointTreeNodeOperation(mousePos, SwtUtils.getWidgetBounds((Widget)TreeTester.this.getTree()));
                TreeItem topItem = TreeTester.this.getTree().getTopItem();
                if (topItem != null) {
                    StandardDepthFirstTraverser traverser = new StandardDepthFirstTraverser((AbstractTreeOperationContext)new TreeOperationContext(TreeTester.this.getEventThreadQueuer(), TreeTester.this.getRobot(), TreeTester.this.getTree()));
                    traverser.traversePath((TreeNodeOperation)op, (Object)topItem);
                    if (op.getItemAtPoint() != null) {
                        return op.getItemAtPoint();
                    }
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        final Tree tree = this.getTree();
        final java.awt.Point awtMousePos = this.getRobot().getCurrentMousePosition();
        Cell returnvalue = (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition", (IRunnable)new IRunnable<Cell>(){
            private int m_rowCount = 0;

            public Cell run() throws StepExecutionException {
                Cell cell = null;
                TreeItem[] treeItemArray = tree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    cell = this.findCell(item);
                    if (cell != null) break;
                    ++n2;
                }
                if (cell == null) {
                    throw new StepExecutionException("No cell under mouse position found!", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return cell;
            }

            private Cell findCell(TreeItem item) {
                Cell cell = null;
                int col = 0;
                while (col < tree.getColumnCount()) {
                    org.eclipse.swt.graphics.Rectangle itemBounds = TreeTester.getCellBounds(TreeTester.this.getEventThreadQueuer(), tree, this.m_rowCount, col, item);
                    Point absItemBounds = tree.toDisplay(itemBounds.x, itemBounds.y);
                    Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                    if (absRect.contains(awtMousePos)) {
                        cell = new SWTCell(this.m_rowCount, col, item);
                    }
                    ++col;
                }
                ++this.m_rowCount;
                if (cell == null && item.getExpanded()) {
                    TreeItem[] treeItemArray = item.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem subItem = treeItemArray[n2];
                        cell = this.findCell(subItem);
                        if (cell != null) break;
                        ++n2;
                    }
                }
                return cell;
            }
        });
        return returnvalue;
    }

    private static org.eclipse.swt.graphics.Rectangle getCellBounds(IEventThreadQueuer etq, final Tree table, int row, final int col, final TreeItem ti) {
        org.eclipse.swt.graphics.Rectangle cellBounds = (org.eclipse.swt.graphics.Rectangle)etq.invokeAndWait("getCellBounds", (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() {
                int column = table.getColumnCount() > 0 || col > 0 ? col : 0;
                org.eclipse.swt.graphics.Rectangle r = ti.getBounds(column);
                String text = CAPUtil.getWidgetText((Widget)ti, "TEST_TESTABLE_TEXT_" + column, ti.getText(column));
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)table);
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    finally {
                        gc.dispose();
                    }
                    r.width = text.length() * charWidth;
                    if (image != null) {
                        r.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    r.width = image.getBounds().width;
                }
                if (column > 0) {
                    TreeColumn tc = table.getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        r.x = (int)((double)r.x + ((double)tc.getWidth() / 2.0 - (double)r.width / 2.0));
                    }
                    if (alignment == 131072) {
                        r.x += tc.getWidth() - r.width;
                    }
                }
                return new org.eclipse.swt.graphics.Rectangle(r.x, r.y, r.width, r.height);
            }
        });
        return cellBounds;
    }

    private int getMouseColumn() {
        final Tree treeTable = this.getTree();
        int column = (Integer)this.getEventThreadQueuer().invokeAndWait("getMouseColumn", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                Point cursorPosition;
                org.eclipse.swt.graphics.Rectangle treeTableBounds = SwtUtils.getWidgetBounds((Widget)TreeTester.this.getTree());
                boolean isCursorInBounds = treeTableBounds.contains(cursorPosition = treeTable.getDisplay().getCursorLocation());
                if (isCursorInBounds) {
                    int horizontalScrollOffset = 0;
                    ScrollBar horizontalBar = TreeTester.this.getTree().getHorizontalBar();
                    if (horizontalBar != null && !horizontalBar.isDisposed()) {
                        horizontalScrollOffset = horizontalBar.getSelection();
                    }
                    org.eclipse.swt.graphics.Rectangle columnBounds = new org.eclipse.swt.graphics.Rectangle(treeTableBounds.x - horizontalScrollOffset, treeTableBounds.y, 0, treeTableBounds.height);
                    int i = 0;
                    while (i < treeTable.getColumnCount()) {
                        columnBounds.x += columnBounds.width;
                        columnBounds.width = treeTable.getColumn(i).getWidth();
                        if (columnBounds.contains(cursorPosition)) {
                            return i;
                        }
                        ++i;
                    }
                }
                return -1;
            }
        });
        return column;
    }

    public void rcMove(String direction, int distance, int clickCount) throws StepExecutionException {
        if (this.getColumnCount() > 0) {
            int mouseColumn = this.getMouseColumn();
            TableTreeOperationContext context = mouseColumn == -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree()) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), mouseColumn);
            TreeItem selectedNode = (TreeItem)this.getSelectedNode(context);
            SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(ClickOptions.create().setClickCount(clickCount));
            TreeNodeOperationConstraint constraint = new TreeNodeOperationConstraint();
            if (ValueSets.TreeDirection.up.rcValue().equalsIgnoreCase(direction)) {
                ParentTraverser traverser = new ParentTraverser((AbstractTreeOperationContext)context, distance, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if (ValueSets.TreeDirection.down.rcValue().equalsIgnoreCase(direction)) {
                ExpandCollapseTreeNodeOperation expandOp = new ExpandCollapseTreeNodeOperation(false);
                ChildTraverser expandTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance - 1);
                expandTraverser.traversePath((TreeNodeOperation)expandOp, (Object)selectedNode);
                ChildTraverser selectTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance, constraint);
                selectTraverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if (ValueSets.TreeDirection.next.rcValue().equalsIgnoreCase(direction)) {
                SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, true, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if (ValueSets.TreeDirection.previous.rcValue().equalsIgnoreCase(direction)) {
                SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, false, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            }
        } else {
            super.rcMove(direction, distance, clickCount);
        }
    }

    private int getColumnCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnCount", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TreeTester.this.getTree().getColumnCount();
            }
        });
    }

    public void rcSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void rcSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void rcVerifySelectedValue(String pattern, int column) throws StepExecutionException {
        this.rcVerifySelectedValue(pattern, MatchUtil.DEFAULT_OPERATOR, column);
    }

    public void rcVerifySelectedValue(String pattern, String operator, int column) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        TableTreeOperationContext context = new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), implCol);
        String text = context.getNodeTextAtColumn(context.getSelectedNode());
        Verifier.match((String)text, (String)pattern, (String)operator);
    }

    private void checkColumnIndex(int index) throws StepExecutionException {
        int numColumns = (Integer)this.getEventThreadQueuer().invokeAndWait("checkColumnIndex", (IRunnable)new IRunnable<Integer>(){

            public Integer run() {
                return TreeTester.this.getTree().getColumnCount();
            }
        });
        if ((index < 0 || index >= numColumns) && index != 0) {
            throw new StepExecutionException("Invalid column: " + IndexConverter.toUserIndex((int)index), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co, int column) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selectOp, column);
    }

    private void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation, int column) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TableTreeOperationContext context = new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), column);
        TreeItem startNode = (TreeItem)this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath, new TreeNodeOperationConstraint());
        traverser.traversePath(operation, (Object)startNode);
    }

    public String rcStoreValueAtMousePosition(String variable) {
        TreeItem itemAtMousePosition = (TreeItem)this.getNodeAtMousePosition();
        int column = this.getMouseColumn();
        TableTreeOperationContext context = column != -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), column) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        return context.getRenderedText(itemAtMousePosition);
    }

    public void rcToggleCheckbox(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator));
    }

    public void rcToggleCheckboxByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)));
    }

    public void rcVerifyCheckbox(String pathType, int preAscend, String treePath, String operator, boolean checked) throws StepExecutionException {
        this.verifyCheckBoxByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), checked);
    }

    public void rcVerifyCheckboxByIndices(String pathType, int preAscend, String indexPath, boolean checked) throws StepExecutionException {
        this.verifyCheckBoxByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), checked);
    }

    public void rcVerifySelectedCheckbox(boolean checked) throws StepExecutionException {
        Boolean checkSelected = (Boolean)this.getEventThreadQueuer().invokeAndWait("rcVerifyTreeCheckbox", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                AbstractTreeOperationContext context = ((ITreeComponent)TreeTester.this.getComponent()).getContext();
                TreeItem node = (TreeItem)TreeTester.this.getSelectedNode(context);
                return node.getChecked();
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkSelected);
    }

    private void verifyCheckBoxByPath(String pathType, int preAscend, INodePath objectPath, boolean checked) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        VerifyCheckboxOperation checkboxOp = new VerifyCheckboxOperation(checked, context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)checkboxOp);
    }

    private void toggleCheckBoxByPath(String pathType, int preAscend, INodePath objectPath) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        ToggleCheckboxOperation selCheckboxOp = new ToggleCheckboxOperation(context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selCheckboxOp);
    }

    public void rcClick(int count, int button) {
        super.rcClick(count, button);
    }

    protected void waitForDisplayUpdate() {
        ((Control)this.getComponent().getRealComponent()).getDisplay().syncExec(new Runnable(){

            public void run() {
                ((Control)TreeTester.this.getComponent().getRealComponent()).getDisplay().update();
            }
        });
    }

    public void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = KeyCodeConverter.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    public void rcCheckPropertyAtMousePosition(String name, String value, String operator) {
        Object cell = null;
        int numColumns = (Integer)this.getEventThreadQueuer().invokeAndWait("checkColumnIndex", (IRunnable)new IRunnable<Integer>(){

            public Integer run() {
                return TreeTester.this.getTree().getColumnCount();
            }
        });
        cell = numColumns > 0 ? this.getCellAtMousePosition() : this.getNodeAtMousePosition();
        ITreeComponent bean = this.getTreeAdapter();
        String propToStr = bean.getPropertyValueOfCell(name, cell);
        Verifier.match((String)propToStr, (String)value, (String)operator);
    }

    private static final class ItemAtPointTreeNodeOperation
    extends AbstractTreeNodeOperation {
        private TreeItem m_itemAtPoint;
        private Point m_absPoint;
        private org.eclipse.swt.graphics.Rectangle m_absTreeBounds;

        public ItemAtPointTreeNodeOperation(Point absPoint, org.eclipse.swt.graphics.Rectangle absTreeBounds) {
            this.m_absPoint = absPoint;
            this.m_absTreeBounds = absTreeBounds;
        }

        public boolean operate(Object node) throws StepExecutionException {
            if (this.getContext().isVisible(node) && node instanceof TreeItem) {
                TreeItem currentItem = (TreeItem)node;
                org.eclipse.swt.graphics.Rectangle absItemBounds = SwtUtils.getBounds(currentItem);
                absItemBounds.x = this.m_absTreeBounds.x;
                absItemBounds.width = this.m_absTreeBounds.width;
                if (SwtUtils.containsInclusive(absItemBounds, this.m_absPoint)) {
                    this.m_itemAtPoint = currentItem;
                    return false;
                }
            }
            return true;
        }

        public TreeItem getItemAtPoint() {
            return this.m_itemAtPoint;
        }
    }
}

