/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.toolkit.api.gen.ClassGenerator;
import org.eclipse.jubula.toolkit.api.gen.FactoryGenerator;
import org.eclipse.jubula.toolkit.api.gen.ToolkitInfoGenerator;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CommonGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CompInfoForFactoryGen;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CompInfoForToolkitGen;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.ComponentGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.FactoryGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.ToolkitGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.ConfigLoader;
import org.eclipse.jubula.tools.internal.utils.generator.CompSystemProcessor;
import org.eclipse.jubula.tools.internal.utils.generator.ComponentInfo;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitConfig;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitInfo;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;

public class APIGenerator {
    private static ClassGenerator classGenerator = new ClassGenerator();
    private static FactoryGenerator factoryGenerator = new FactoryGenerator();
    private static ToolkitInfoGenerator toolkitInfoGenerator = new ToolkitInfoGenerator();
    private static FactoryGenInfo factoryGenInfo;
    private static ToolkitGenInfo tookitGenInfo;
    private static boolean toolkitNeedsInfoClass;
    private static Map<String, String> compNameMap;

    static {
        toolkitNeedsInfoClass = false;
        compNameMap = new TreeMap<String, String>();
    }

    private APIGenerator() {
    }

    public static void main(String[] args) {
        ConfigLoader loader = ConfigLoader.getInstance();
        String generationBaseDir = loader.getGenerationDir();
        ToolkitConfig config = loader.getToolkitConfig();
        CompSystemProcessor processor = new CompSystemProcessor(config);
        List toolkitInfos = processor.getToolkitInfos();
        String converterInfoDir = loader.getConverterInfoDir();
        File converterDirectory = new File(converterInfoDir);
        if (converterDirectory.exists()) {
            try {
                FileUtils.cleanDirectory((File)converterDirectory);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            converterDirectory.mkdirs();
        }
        for (ToolkitInfo tkInfo : toolkitInfos) {
            APIGenerator.cleanUp(tkInfo, generationBaseDir);
        }
        for (ToolkitInfo tkInfo : toolkitInfos) {
            factoryGenInfo = new FactoryGenInfo();
            tookitGenInfo = new ToolkitGenInfo();
            toolkitNeedsInfoClass = false;
            List compInfos = processor.getCompInfos(tkInfo.getType(), tkInfo.getShortType());
            for (ComponentInfo compInfo : compInfos) {
                compNameMap.clear();
                Component component = compInfo.getComponent();
                APIGenerator.createClass(component, generationBaseDir, true);
                APIGenerator.createClass(component, generationBaseDir, false);
                APIGenerator.createComponentNameInfoFile(component, compNameMap, converterInfoDir);
            }
            CompSystem compSystem = processor.getCompSystem();
            ToolkitDescriptor toolkitDesriptor = compSystem.getToolkitDescriptor(tkInfo.getType());
            CommonGenInfo genInfoForFactory = new CommonGenInfo(toolkitDesriptor, false);
            if (toolkitNeedsInfoClass) {
                CommonGenInfo genInfoForToolkit = new CommonGenInfo(toolkitDesriptor, true);
                APIGenerator.createToolkitInfo(genInfoForToolkit, generationBaseDir);
                factoryGenInfo.setToolkitInfoName(genInfoForToolkit.getToolkitName(), genInfoForToolkit.getFqClassName());
            }
            APIGenerator.createFactory(genInfoForFactory, generationBaseDir);
        }
    }

    private static void createComponentNameInfoFile(Component component, Map<String, String> map, String dirPath) {
        StringBuffer content = new StringBuffer();
        for (String key : map.keySet()) {
            content.append(String.valueOf(key) + "=" + map.get(key) + "\n");
        }
        File dir = new File(dirPath);
        File file = new File(String.valueOf(dirPath) + "/" + component.getType() + ".properties");
        APIGenerator.createFile(dir, file, content.toString());
    }

    private static void cleanUp(ToolkitInfo tkInfo, String generationBaseDirTemplate) {
        String name = tkInfo.getShortType().toLowerCase().replace("abstract", "base");
        String generationBaseDir = MessageFormat.format(generationBaseDirTemplate, name);
        File dir = new File(generationBaseDir);
        APIGenerator.emptyDirectory(dir);
    }

    private static void emptyDirectory(File dir) {
        if (dir.exists()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                ++n2;
            }
        }
    }

    private static void createClass(Component component, String generationBaseDirTemplate, Boolean generateInterface) {
        CommonGenInfo genInfo = new CommonGenInfo(component);
        ComponentGenInfo compInfo = new ComponentGenInfo(component, generateInterface, genInfo.getToolkitPackageName(), genInfo.getClassName(), compNameMap);
        genInfo.setSpecificInformation(compInfo);
        String path = "";
        path = generateInterface != false ? compInfo.getInterfaceDirectoryPath() : genInfo.getClassDirectoryPath();
        String className = genInfo.getClassName();
        String generationBaseDir = MessageFormat.format(generationBaseDirTemplate, genInfo.getToolkitPackageName());
        File dir = new File(String.valueOf(generationBaseDir) + path);
        File file = new File(dir, String.valueOf(className) + ".java");
        String content = classGenerator.generate(genInfo);
        APIGenerator.createFile(dir, file, content);
        if (!generateInterface.booleanValue()) {
            ComponentClass componentClass = null;
            String testerClass = null;
            if (component instanceof ConcreteComponent) {
                ConcreteComponent concreteComponent = (ConcreteComponent)component;
                componentClass = concreteComponent.getComponentClass();
                testerClass = concreteComponent.getTesterClass();
                if (componentClass != null && testerClass != null) {
                    toolkitNeedsInfoClass = true;
                }
            }
            if (!compInfo.hasDefaultMapping() || componentClass != null && !componentClass.getName().isEmpty()) {
                CompInfoForFactoryGen compInfoForFactory = new CompInfoForFactoryGen(genInfo.getClassName(), genInfo.getFqClassName(), componentClass, compInfo.hasDefaultMapping(), compInfo.getMostSpecificVisibleSuperTypeName());
                String sinceC = component.getSince();
                if (StringUtils.isNotBlank((String)sinceC)) {
                    compInfoForFactory.setSince(sinceC);
                }
                factoryGenInfo.addCompInformation(compInfoForFactory);
            }
            tookitGenInfo.addCompInformation(new CompInfoForToolkitGen(componentClass, testerClass));
        }
    }

    private static void createFactory(CommonGenInfo tkGenInfo, String generationBaseDirTemplate) {
        tkGenInfo.setSpecificInformation(factoryGenInfo);
        String path = tkGenInfo.getClassDirectoryPath();
        String className = tkGenInfo.getClassName();
        String generationBaseDir = MessageFormat.format(generationBaseDirTemplate, tkGenInfo.getToolkitPackageName());
        File dir = new File(String.valueOf(generationBaseDir) + path);
        File file = new File(dir, String.valueOf(className) + ".java");
        String content = factoryGenerator.generate(tkGenInfo);
        APIGenerator.createFile(dir, file, content);
    }

    private static void createToolkitInfo(CommonGenInfo tkGenInfo, String generationBaseDirTemplate) {
        tkGenInfo.setSpecificInformation(tookitGenInfo);
        String path = tkGenInfo.getClassDirectoryPath();
        String className = tkGenInfo.getClassName();
        String generationBaseDir = MessageFormat.format(generationBaseDirTemplate, tkGenInfo.getToolkitPackageName());
        File dir = new File(String.valueOf(generationBaseDir) + path);
        File file = new File(dir, String.valueOf(className) + ".java");
        String content = toolkitInfoGenerator.generate(tkGenInfo);
        APIGenerator.createFile(dir, file, content);
    }

    private static void createFile(File dir, File file, String content) {
        if (!file.exists()) {
            try {
                dir.mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            try {
                Throwable e = null;
                Object var4_7 = null;
                try (FileOutputStream fop = new FileOutputStream(file);){
                    byte[] contentInBytes = content.getBytes();
                    IOUtils.write((byte[])contentInBytes, (OutputStream)fop);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.out.println("ERROR: " + file.getName() + " already exists!");
            System.exit(1);
        }
    }
}

