/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.libra.facet.Activator;
import org.eclipse.libra.facet.OSGiBundleFacetInstallConfig;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.project.IBundleClasspathEntry;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IPackageExportDescription;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundleFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object configObject, IProgressMonitor monitor) throws CoreException {
        OSGiBundleFacetInstallConfig config = (OSGiBundleFacetInstallConfig)((Object)configObject);
        this.doExecute(project, config, monitor);
    }

    private void doExecute(IProject project, OSGiBundleFacetInstallConfig config, IProgressMonitor monitor) throws CoreException {
        this.setBundleRoot(project);
        this.createBundleProjectDescription(project, config, monitor);
        this.addRequiredPluginsClasspathContainer(project, monitor);
    }

    private void setBundleRoot(IProject project) throws CoreException {
        IPath bundleRoot = null;
        if (OSGiBundleFacetUtils.isWebProject(project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            bundleRoot = component.getRootFolder().getProjectRelativePath();
        }
        if (bundleRoot != null) {
            IBundleProjectService bundleProjectService = Activator.getDefault().getBundleProjectService();
            bundleProjectService.setBundleRoot(project, bundleRoot);
        }
    }

    private void createBundleProjectDescription(IProject project, OSGiBundleFacetInstallConfig config, IProgressMonitor monitor) throws CoreException {
        String bundleVendor;
        IBundleProjectService bundleProjectService = Activator.getDefault().getBundleProjectService();
        IBundleProjectDescription bundleProjectDescription = bundleProjectService.getDescription(project);
        bundleProjectDescription.setSymbolicName(config.getSymbolicName());
        bundleProjectDescription.setBundleVersion(config.getVersion());
        String bundleName = config.getName();
        if (bundleName != null && bundleName.trim().length() > 0) {
            bundleProjectDescription.setBundleName(bundleName);
        }
        if ((bundleVendor = config.getVendor()) != null && bundleVendor.trim().length() > 0) {
            bundleProjectDescription.setBundleVendor(bundleVendor);
        }
        bundleProjectDescription.setEquinox(true);
        bundleProjectDescription.setExtensionRegistry(false);
        bundleProjectDescription.setNatureIds(this.getNatureIds(bundleProjectDescription));
        bundleProjectDescription.setLaunchShortcuts(this.getLaunchShortcuts(project));
        Map<String, String> headers = this.getAdditionalHeaders(project);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            bundleProjectDescription.setHeader(entry.getKey(), entry.getValue());
        }
        bundleProjectDescription.setPackageExports(this.getPackageExports(project));
        bundleProjectDescription.setPackageImports(this.getPackageImports(bundleProjectDescription));
        bundleProjectDescription.setBinIncludes(this.getBinIncludes(bundleProjectDescription));
        bundleProjectDescription.setBundleClasspath(this.getBundleClasspath(bundleProjectDescription));
        bundleProjectDescription.apply(monitor);
    }

    private String[] getNatureIds(IBundleProjectDescription bundleProjectDescription) throws CoreException {
        String[] natureIds = bundleProjectDescription.getNatureIds();
        String[] newNatureIds = new String[natureIds.length + 1];
        int i = 0;
        while (i < natureIds.length) {
            newNatureIds[i] = natureIds[i];
            ++i;
        }
        newNatureIds[newNatureIds.length - 1] = "org.eclipse.pde.PluginNature";
        return newNatureIds;
    }

    private String[] getLaunchShortcuts(IProject project) throws CoreException {
        if (OSGiBundleFacetUtils.isWebProject(project)) {
            return new String[]{"org.eclipse.pde.ui.EquinoxLaunchShortcut", "org.eclipse.wst.server.launchShortcut"};
        }
        return null;
    }

    private Map<String, String> getAdditionalHeaders(IProject project) throws CoreException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (OSGiBundleFacetUtils.isWebProject(project)) {
            headers.put("Web-ContextPath", this.getContextRoot(project));
        }
        if (OSGiBundleFacetUtils.isJpaProject(project)) {
            headers.put("Meta-Persistence", "");
        }
        return headers;
    }

    private String getContextRoot(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String contextRoot = component.getMetaProperties().getProperty("context-root");
        if (contextRoot.charAt(0) != '/') {
            contextRoot = String.valueOf('/') + contextRoot;
        }
        return contextRoot;
    }

    private IPackageExportDescription[] getPackageExports(IProject project) throws CoreException {
        IBundleProjectService bundleProjectService = Activator.getDefault().getBundleProjectService();
        ArrayList<IPackageExportDescription> list = new ArrayList<IPackageExportDescription>();
        if (OSGiBundleFacetUtils.isJavaProject(project)) {
            IPackageFragmentRoot[] fragmentRoots;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = javaProject.getAllPackageFragmentRoots();
            int n = fragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot.getKind() == 1 && fragmentRoot.getParent().equals(javaProject)) {
                    IJavaElement[] elements;
                    IJavaElement[] iJavaElementArray = elements = fragmentRoot.getChildren();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement element = iJavaElementArray[n4];
                        IPackageFragment fragment = (IPackageFragment)element;
                        if (fragment.containsJavaResources()) {
                            list.add(bundleProjectService.newPackageExport(fragment.getElementName(), null, true, null));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return list.toArray(new IPackageExportDescription[list.size()]);
    }

    private IPackageImportDescription[] getPackageImports(IBundleProjectDescription bundleProjectDescription) throws CoreException {
        IProject project = bundleProjectDescription.getProject();
        TreeMap<String, IPackageImportDescription> packages = new TreeMap<String, IPackageImportDescription>();
        IPackageImportDescription[] imports = bundleProjectDescription.getPackageImports();
        if (imports != null) {
            IPackageImportDescription[] iPackageImportDescriptionArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageImportDescription imp = iPackageImportDescriptionArray[n2];
                packages.put(imp.getName(), imp);
                ++n2;
            }
        }
        IBundleProjectService bundleProjectService = Activator.getDefault().getBundleProjectService();
        if (OSGiBundleFacetUtils.isWebProject(project)) {
            IVirtualReference[] references;
            this.addPackageImport(packages, "javax.servlet", null, false);
            this.addPackageImport(packages, "javax.servlet.http", null, false);
            this.addPackageImport(packages, "javax.servlet.jsp", null, false);
            this.addPackageImport(packages, "javax.servlet.jsp.el", null, false);
            this.addPackageImport(packages, "javax.servlet.jsp.tagext", null, false);
            this.addPackageImport(packages, "javax.el", null, false);
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] iVirtualReferenceArray = references = component.getReferences();
            int n = references.length;
            int n3 = 0;
            while (n3 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n3];
                IProject refProject = ref.getReferencedComponent().getProject();
                if (refProject != null && refProject != project && OSGiBundleFacetUtils.hasPluginNature(refProject)) {
                    IPackageExportDescription[] exports;
                    IPackageExportDescription[] iPackageExportDescriptionArray = exports = bundleProjectService.getDescription(refProject).getPackageExports();
                    int n4 = exports.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IPackageExportDescription export = iPackageExportDescriptionArray[n5];
                        String importName = export.getName();
                        Version exportVersion = export.getVersion();
                        VersionRange range = exportVersion == null ? null : new VersionRange(exportVersion.toString());
                        this.addPackageImport(packages, importName, range, false);
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        if (OSGiBundleFacetUtils.isJpaProject(project)) {
            String version = FacetedProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jpt.jpa").getVersionString();
            this.addPackageImport(packages, String.format("javax.persistence;jpa=\"%s\"", version), null, false);
        }
        return packages.values().toArray(new IPackageImportDescription[packages.size()]);
    }

    private void addPackageImport(Map<String, IPackageImportDescription> packages, String importName, VersionRange range, boolean optional) {
        IBundleProjectService bundleProjectService = Activator.getDefault().getBundleProjectService();
        if (!packages.containsKey(importName)) {
            IPackageImportDescription imp = bundleProjectService.newPackageImport(importName, range, optional);
            packages.put(importName, imp);
        }
    }

    private IPath[] getBinIncludes(IBundleProjectDescription bundleProjectDescription) throws CoreException {
        IProject project = bundleProjectDescription.getProject();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (OSGiBundleFacetUtils.isWebProject(project)) {
            IPath bundleRoot = component.getRootFolder().getProjectRelativePath();
            IResource[] resources = project.getFolder(bundleRoot).members();
            ArrayList<Path> binPaths = new ArrayList<Path>();
            int i = 0;
            while (i < resources.length) {
                String token = resources[i].getName();
                if (resources[i].getType() == 2) {
                    token = String.valueOf(token) + '/';
                }
                if (!token.equals("build.properties")) {
                    binPaths.add(new Path(token));
                }
                ++i;
            }
            return binPaths.toArray(new IPath[binPaths.size()]);
        }
        return bundleProjectDescription.getBinIncludes();
    }

    private IBundleClasspathEntry[] getBundleClasspath(IBundleProjectDescription bundleProjectDescription) throws CoreException {
        IProject project = bundleProjectDescription.getProject();
        IBundleClasspathEntry[] bundleClasspath = bundleProjectDescription.getBundleClasspath();
        if (OSGiBundleFacetUtils.isWebProject(project)) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (bundleClasspath == null) {
                IBundleProjectService bundleProjectService = Activator.getDefault().getBundleProjectService();
                IPath source = this.getRelativePath(project, this.getJavaSourceFolderPaths(javaProject)[0]);
                IPath binary = this.getRelativePath(project, javaProject.getOutputLocation());
                Path library = new Path("WEB-INF/classes/");
                IBundleClasspathEntry webInfClasses = bundleProjectService.newBundleClasspathEntry(source, binary, (IPath)library);
                bundleClasspath = new IBundleClasspathEntry[]{webInfClasses};
            }
        }
        return bundleClasspath;
    }

    private void addRequiredPluginsClasspathContainer(IProject project, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject;
        IClasspathEntry[] entries;
        if (OSGiBundleFacetUtils.isJavaProject(project) && !OSGiBundleFacetUtils.hasRequiredPlugins(entries = (javaProject = JavaCore.create((IProject)project)).getRawClasspath())) {
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[newEntries.length - 1] = JavaCore.newContainerEntry((IPath)OSGiBundleFacetUtils.REQUIRED_PLUGINS_CONTAINER_PATH);
            javaProject.setRawClasspath(newEntries, monitor);
        }
    }

    private IPath[] getJavaSourceFolderPaths(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] fragmentRoots;
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = javaProject.getAllPackageFragmentRoots();
        int n = fragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
            if (fragmentRoot.getKind() == 1 && fragmentRoot.getParent().equals(javaProject)) {
                paths.add(fragmentRoot.getPath());
            }
            ++n2;
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    private IPath getRelativePath(IProject project, IPath path) {
        return path.makeRelativeTo(project.getFullPath()).addTrailingSeparator();
    }
}

