/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class OSGiBundleFacetUtils {
    public static final String OSGI_BUNDLE = "osgi.bundle";
    public static final IProjectFacet OSGI_BUNDLE_FACET = ProjectFacetsManager.getProjectFacet((String)"osgi.bundle");
    public static final IProjectFacetVersion OSGI_BUNDLE_FACET_42 = OSGI_BUNDLE_FACET.getVersion("4.2");
    public static final String WEB_FACET = "jst.web";
    public static final String JPA_FACET = "jpt.jpa";
    public static final String FEATURE_NATURE_ID = "org.eclipse.pde.FeatureNature";
    public static final String SITE_NATURE_ID = "org.eclipse.pde.UpdateSiteNature";
    public static final String MANIFEST_BUILDER_ID = "org.eclipse.pde.ManifestBuilder";
    public static final String SCHEMA_BUILDER_ID = "org.eclipse.pde.SchemaBuilder";
    public static final Path REQUIRED_PLUGINS_CONTAINER_PATH = new Path("org.eclipse.pde.core.requiredPlugins");
    public static final String BUILD_PROPERTIES = "build.properties";
    public static final String CONTEXTROOT = "context-root";
    public static final String MANIFEST_URI = "META-INF/MANIFEST.MF";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    public static final String WEB_CONTEXT_PATH_HEADER = "Web-ContextPath";
    public static final String META_PERSISTENCE_HEADER = "Meta-Persistence";
    public static final String JAVAX_SERVLET_PACKAGE = "javax.servlet";
    public static final String JAVAX_SERVLET_HTTP_PACKAGE = "javax.servlet.http";
    public static final String JAVAX_SERVLET_JSP_PACKAGE = "javax.servlet.jsp";
    public static final String JAVAX_SERVLET_JSP_EL_PACKAGE = "javax.servlet.jsp.el";
    public static final String JAVAX_SERVLET_JSP_TAGEXT_PACKAGE = "javax.servlet.jsp.tagext";
    public static final String JAVAX_EL_PACKAGE = "javax.el";
    public static final String JAVAX_PERSISTENCE_PACKAGE = "javax.persistence;jpa=\"%s\"";

    public static boolean hasPluginNature(IProject project) throws CoreException {
        return project.hasNature("org.eclipse.pde.PluginNature");
    }

    public static boolean hasFeatureNature(IProject project) throws CoreException {
        return project.hasNature(FEATURE_NATURE_ID);
    }

    public static boolean hasUpdateSiteNature(IProject project) throws CoreException {
        return project.hasNature(SITE_NATURE_ID);
    }

    public static boolean isOSGiBundle(IProject project) throws CoreException {
        return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)OSGI_BUNDLE);
    }

    public static boolean isJavaProject(IProject project) throws CoreException {
        return project.hasNature("org.eclipse.jdt.core.javanature");
    }

    public static boolean isWebProject(IProject project) throws CoreException {
        return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WEB_FACET);
    }

    public static boolean isJpaProject(IProject project) throws CoreException {
        return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)JPA_FACET);
    }

    public static boolean isRequiredPlugins(IClasspathEntry entry) {
        return REQUIRED_PLUGINS_CONTAINER_PATH.equals((Object)entry.getPath());
    }

    public static boolean hasRequiredPlugins(IClasspathEntry[] entries) {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (OSGiBundleFacetUtils.isRequiredPlugins(entry)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

