/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.libra.facet.Messages;
import org.eclipse.libra.facet.OSGiBundleFacetRealm;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.osgi.framework.Version;

public class OSGiBundleFacetInstallConfig
extends ActionConfig
implements IFacetedProjectListener {
    private static final String QUALIFIER = "qualifier";
    private IObservableValue symbolicNameValue;
    private IObservableValue versionValue;
    private IObservableValue nameValue;
    private IObservableValue vendorValue;

    public OSGiBundleFacetInstallConfig() {
        Realm realm = OSGiBundleFacetRealm.getRealm();
        this.symbolicNameValue = new WritableValue(realm, this.getDefaultSymbolicName(), String.class);
        this.versionValue = new WritableValue(realm, (Object)this.getDefaultVersion(), String.class);
        this.nameValue = new WritableValue(realm, this.getDefaultSymbolicName(), String.class);
        this.vendorValue = new WritableValue(realm, this.getDefaultVendor(), String.class);
    }

    public IObservableValue getSymbolicNameValue() {
        return this.symbolicNameValue;
    }

    public IObservableValue getVersionValue() {
        return this.versionValue;
    }

    public IObservableValue getNameValue() {
        return this.nameValue;
    }

    public IObservableValue getVendorValue() {
        return this.vendorValue;
    }

    public String getSymbolicName() {
        return (String)this.getSymbolicNameValue().getValue();
    }

    public Version getVersion() {
        return Version.parseVersion((String)((String)this.getVersionValue().getValue()));
    }

    public String getName() {
        return (String)this.getNameValue().getValue();
    }

    public String getVendor() {
        return (String)this.getVendorValue().getValue();
    }

    public void setFacetedProjectWorkingCopy(IFacetedProjectWorkingCopy fpjwc) {
        super.setFacetedProjectWorkingCopy(fpjwc);
        fpjwc.addListener((IFacetedProjectListener)this, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_NAME_CHANGED});
        this.updateDefaultValues();
    }

    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.PROJECT_NAME_CHANGED) {
            this.updateDefaultNameValues();
        }
    }

    private void updateDefaultNameValues() {
        this.symbolicNameValue.setValue(this.getDefaultSymbolicName());
        this.nameValue.setValue(this.getDefaultName());
    }

    private void updateDefaultValues() {
        this.symbolicNameValue.setValue(this.getDefaultSymbolicName());
        this.versionValue.setValue((Object)this.getDefaultVersion());
        this.nameValue.setValue(this.getDefaultName());
        this.vendorValue.setValue(this.getDefaultVendor());
    }

    private Object getDefaultSymbolicName() {
        String symbolicName = null;
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        if (fpjwc != null) {
            IBundleProjectDescription bundleProjectDescription = this.getBundleProjectDescription();
            if (bundleProjectDescription != null) {
                symbolicName = bundleProjectDescription.getSymbolicName();
            }
            if (symbolicName == null) {
                symbolicName = fpjwc.getProjectName();
            }
        }
        return symbolicName;
    }

    private String getDefaultVersion() {
        Version v;
        Version version = new Version(1, 0, 0, QUALIFIER);
        IBundleProjectDescription bundleProjectDescription = this.getBundleProjectDescription();
        if (bundleProjectDescription != null && (v = bundleProjectDescription.getBundleVersion()) != null) {
            version = v;
        }
        return version.toString();
    }

    private Object getDefaultName() {
        String bundleName = null;
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        if (fpjwc != null) {
            IBundleProjectDescription bundleProjectDescription = this.getBundleProjectDescription();
            if (bundleProjectDescription != null) {
                bundleName = bundleProjectDescription.getBundleName();
            }
            if (bundleName == null && (bundleName = fpjwc.getProjectName()) != null && bundleName.length() > 0 && !Character.isTitleCase(bundleName.charAt(0))) {
                StringBuilder builder = new StringBuilder(bundleName);
                builder.replace(0, 1, String.valueOf(Character.toTitleCase(bundleName.charAt(0))));
                bundleName = builder.toString();
            }
        }
        return bundleName;
    }

    private Object getDefaultVendor() {
        String vendor = null;
        IBundleProjectDescription bundleProjectDescription = this.getBundleProjectDescription();
        if (bundleProjectDescription != null) {
            vendor = bundleProjectDescription.getBundleVendor();
        }
        return vendor;
    }

    private IBundleProjectDescription getBundleProjectDescription() {
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        if (fpjwc == null) {
            return null;
        }
        IFacetedProject fproj = fpjwc.getFacetedProject();
        if (fproj == null) {
            return null;
        }
        IProject project = fproj.getProject();
        try {
            return OSGiBundleFacetUtils.getBundleProjectDescription(project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static class SymbolicNameValidator
    implements IValidator {
        public IStatus validate(Object value) {
            String symbolicName = (String)value;
            if (symbolicName == null || symbolicName.trim().length() == 0) {
                return ValidationStatus.error((String)Messages.OSGiBundleFacetInstallConfig_EmptySymbolicName);
            }
            return ValidationStatus.ok();
        }
    }

    public static class VersionValidator
    implements IValidator {
        public IStatus validate(Object value) {
            String version = (String)value;
            if (version == null || version.trim().length() == 0) {
                return ValidationStatus.error((String)Messages.OSGiBundleFacetInstallConfig_EmptyVersion);
            }
            return ValidationStatus.ok();
        }
    }
}

