/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.knopflerfish.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.ProgressUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.knopflerfish.IKnopflerfishVersionHandler;
import org.eclipse.libra.framework.knopflerfish.Knopflerfish31Handler;
import org.eclipse.libra.framework.knopflerfish.KnopflerfishFrameworkInstance;
import org.eclipse.libra.framework.knopflerfish.Messages;
import org.eclipse.libra.framework.knopflerfish.internal.KnopflerfishConfigurationPublishHelper;
import org.eclipse.wst.server.core.IModule;

public class KnopflerfishFrameworkInstanceBehavior
extends OSGIFrameworkInstanceBehaviorDelegate {
    protected transient KnopflerfishConfigurationPublishHelper publishHelper = new KnopflerfishConfigurationPublishHelper(this);

    public IKnopflerfishVersionHandler getKnopflerfishVersionHandler() {
        return this.getKnopflerfishRuntimeInstance().getKnopflerfishVersionHandler();
    }

    public KnopflerfishFrameworkInstance getKnopflerfishRuntimeInstance() {
        return (KnopflerfishFrameworkInstance)this.getServer().loadAdapter(KnopflerfishFrameworkInstance.class, null);
    }

    public String getFrameworkClass() {
        return this.getKnopflerfishVersionHandler().getFrameworkClass();
    }

    public String[] getFrameworkProgramArguments(boolean starting) {
        return this.getKnopflerfishVersionHandler().getFrameworkProgramArguments(this.getBaseDirectory(), this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getExcludedFrameworkProgramArguments(boolean starting) {
        return this.getKnopflerfishVersionHandler().getExcludedFrameworkProgramArguments(this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getFrameworkVMArguments() {
        IPath deployPath;
        IPath installPath = this.getServer().getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        if (!(deployPath = this.getBaseDirectory()).isAbsolute()) {
            try {
                String deployLoc = new File(deployPath.toOSString()).getCanonicalPath();
                deployPath = new Path(deployLoc);
            }
            catch (IOException iOException) {}
        }
        return this.getKnopflerfishVersionHandler().getFrameworkVMArguments(installPath, null, deployPath, false);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getRuntime() == null) {
            return;
        }
        IPath confDir = this.getBaseDirectory();
        IStatus status = this.getKnopflerfishVersionHandler().prepareDeployDirectory(confDir);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.publishServerTask, 600);
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        IPath confDir = this.getBaseDirectory();
        IPath installPath = this.getServer().getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        try {
            FrameworkInstanceConfiguration felixConfiguration = this.getKnopflerfishRuntimeInstance().getKnopflerfishConfiguration();
            this.publishHelper.exportBundles(modules, felixConfiguration, confDir);
            ((Knopflerfish31Handler)this.getKnopflerfishVersionHandler()).prepareFrameworkConfigurationFile(installPath, confDir, this.publishHelper, felixConfiguration);
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Publishing failed", (Throwable)e);
        }
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
            this.setServerRestartState(true);
        }
        Properties p = this.loadModulePublishLocations();
        this.setModulePublishState(moduleTree, 1);
        this.saveModulePublishLocations(p);
    }
}

