/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.core;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InfrastructureCreator {
    private static final String WEB_INF_PATH = "WEB-INF";
    private static final String WEB_XML_TEMPLATE_PATH = "/web.xml";
    private static final String LAUNCH_INI_TEMPLATE_PATH = "/launch.ini";
    private static final String WEB_XML_NAME = "web.xml";
    private static final String LAUNCH_INI_NAME = "launch.ini";
    private IContainer rootFolder;
    private IFolder webInfDir;

    public InfrastructureCreator(IContainer tempDir) {
        this.rootFolder = tempDir;
    }

    public IContainer getContainer() {
        return this.rootFolder;
    }

    public void createWebInf() throws CoreException {
        if (this.webInfDir == null) {
            Path webInfPath = new Path(WEB_INF_PATH);
            this.webInfDir = this.rootFolder.getFolder((IPath)webInfPath);
            if (!this.webInfDir.exists()) {
                this.webInfDir.create(true, false, null);
                this.refreshWebInf();
            }
        }
    }

    public void createWebXml() throws CoreException {
        if (this.webInfDir == null) {
            this.createWebInf();
        }
        this.internalCopyFile(WEB_XML_TEMPLATE_PATH, (IContainer)this.webInfDir, WEB_XML_NAME);
        this.refreshWebInf();
    }

    public void createLaunchIni() throws CoreException {
        if (this.webInfDir == null) {
            this.createWebInf();
        }
        this.internalCopyFile(LAUNCH_INI_TEMPLATE_PATH, (IContainer)this.webInfDir, LAUNCH_INI_NAME);
        this.refreshWebInf();
    }

    private void internalCopyFile(String from, IContainer container, String fileName) throws CoreException {
        this.copyFile(from, container, fileName);
    }

    private void copyFile(String from, IContainer container, String fileName) throws CoreException {
        Path path = new Path(fileName);
        IFile file = container.getFile((IPath)path);
        if (!file.exists()) {
            file.create(this.getFileStream(from), true, null);
        }
    }

    private InputStream getFileStream(String from) {
        InputStream fileInStream = this.getClass().getResourceAsStream(from);
        return fileInStream;
    }

    public IPath getWebXmlPath() {
        IPath webInfPath = this.webInfDir.getFullPath();
        return webInfPath.append(WEB_XML_NAME);
    }

    public IPath getLaunchIniPath() {
        IPath webInfPath = this.webInfDir.getFullPath();
        return webInfPath.append(LAUNCH_INI_NAME);
    }

    private void refreshWebInf() throws CoreException {
        this.webInfDir.refreshLocal(1, null);
    }
}

