/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.lsat.common.mpt.ColumnVector;
import org.eclipse.lsat.common.mpt.Event;
import org.eclipse.lsat.common.mpt.FSM;
import org.eclipse.lsat.common.mpt.FSMState;
import org.eclipse.lsat.common.mpt.FSMTransition;
import org.eclipse.lsat.common.mpt.FSMType;
import org.eclipse.lsat.common.mpt.MPA;
import org.eclipse.lsat.common.mpt.MPAState;
import org.eclipse.lsat.common.mpt.MPATransition;
import org.eclipse.lsat.common.mpt.MPS;
import org.eclipse.lsat.common.mpt.MPSConfiguration;
import org.eclipse.lsat.common.mpt.MPSTransition;
import org.eclipse.lsat.common.mpt.MPTFactory;
import org.eclipse.lsat.common.mpt.MPTPackage;
import org.eclipse.lsat.common.mpt.Matrix;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;
import org.eclipse.lsat.common.mpt.RowVector;
import org.eclipse.lsat.common.mpt.impl.ColumnVectorImpl;
import org.eclipse.lsat.common.mpt.impl.EventImpl;
import org.eclipse.lsat.common.mpt.impl.FSMImpl;
import org.eclipse.lsat.common.mpt.impl.FSMStateImpl;
import org.eclipse.lsat.common.mpt.impl.FSMTransitionImpl;
import org.eclipse.lsat.common.mpt.impl.MPAImpl;
import org.eclipse.lsat.common.mpt.impl.MPAStateImpl;
import org.eclipse.lsat.common.mpt.impl.MPATransitionImpl;
import org.eclipse.lsat.common.mpt.impl.MPSConfigurationImpl;
import org.eclipse.lsat.common.mpt.impl.MPSImpl;
import org.eclipse.lsat.common.mpt.impl.MPSTransitionImpl;
import org.eclipse.lsat.common.mpt.impl.MatrixImpl;
import org.eclipse.lsat.common.mpt.impl.MaxPlusSpecificationImpl;
import org.eclipse.lsat.common.mpt.impl.RowVectorImpl;

public class MPTFactoryImpl
extends EFactoryImpl
implements MPTFactory {
    public static MPTFactory init() {
        try {
            MPTFactory theMPTFactory = (MPTFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/lsat/mpt");
            if (theMPTFactory != null) {
                return theMPTFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MPTFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createMatrix();
            }
            case 2: {
                return this.createMaxPlusSpecification();
            }
            case 4: {
                return this.createFSM();
            }
            case 5: {
                return this.createFSMState();
            }
            case 6: {
                return this.createFSMTransition();
            }
            case 9: {
                return this.createMPS();
            }
            case 10: {
                return this.createMPSConfiguration();
            }
            case 11: {
                return this.createMPSTransition();
            }
            case 12: {
                return this.createMPA();
            }
            case 13: {
                return this.createMPAState();
            }
            case 14: {
                return this.createMPATransition();
            }
            case 16: {
                return this.createRowVector();
            }
            case 17: {
                return this.createColumnVector();
            }
            case 18: {
                return this.createEvent();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 19: {
                return this.createFSMTypeFromString(eDataType, initialValue);
            }
            case 20: {
                return this.createValueFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 19: {
                return this.convertFSMTypeToString(eDataType, instanceValue);
            }
            case 20: {
                return this.convertValueToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Matrix createMatrix() {
        MatrixImpl matrix = new MatrixImpl();
        return matrix;
    }

    @Override
    public MaxPlusSpecification createMaxPlusSpecification() {
        MaxPlusSpecificationImpl maxPlusSpecification = new MaxPlusSpecificationImpl();
        return maxPlusSpecification;
    }

    @Override
    public FSM createFSM() {
        FSMImpl fsm = new FSMImpl();
        return fsm;
    }

    @Override
    public FSMState createFSMState() {
        FSMStateImpl fsmState = new FSMStateImpl();
        return fsmState;
    }

    @Override
    public FSMTransition createFSMTransition() {
        FSMTransitionImpl fsmTransition = new FSMTransitionImpl();
        return fsmTransition;
    }

    @Override
    public MPS createMPS() {
        MPSImpl mps = new MPSImpl();
        return mps;
    }

    @Override
    public MPSConfiguration createMPSConfiguration() {
        MPSConfigurationImpl mpsConfiguration = new MPSConfigurationImpl();
        return mpsConfiguration;
    }

    @Override
    public MPSTransition createMPSTransition() {
        MPSTransitionImpl mpsTransition = new MPSTransitionImpl();
        return mpsTransition;
    }

    @Override
    public MPA createMPA() {
        MPAImpl mpa = new MPAImpl();
        return mpa;
    }

    @Override
    public MPAState createMPAState() {
        MPAStateImpl mpaState = new MPAStateImpl();
        return mpaState;
    }

    @Override
    public MPATransition createMPATransition() {
        MPATransitionImpl mpaTransition = new MPATransitionImpl();
        return mpaTransition;
    }

    @Override
    public RowVector createRowVector() {
        RowVectorImpl rowVector = new RowVectorImpl();
        return rowVector;
    }

    @Override
    public ColumnVector createColumnVector() {
        ColumnVectorImpl columnVector = new ColumnVectorImpl();
        return columnVector;
    }

    @Override
    public Event createEvent() {
        EventImpl event = new EventImpl();
        return event;
    }

    public FSMType createFSMTypeFromString(EDataType eDataType, String initialValue) {
        FSMType result = FSMType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFSMTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Double createValueFromString(EDataType eDataType, String initialValue) {
        return (Double)super.createFromString(eDataType, initialValue);
    }

    public String convertValueToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public MPTPackage getMPTPackage() {
        return (MPTPackage)this.getEPackage();
    }

    @Deprecated
    public static MPTPackage getPackage() {
        return MPTPackage.eINSTANCE;
    }
}

