/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.MessageUtil;

public class FieldSizedCapacityCollectionExtractor
extends FieldSizeArrayCollectionExtractor {
    public FieldSizedCapacityCollectionExtractor(String sizeField, String arrayField) {
        super(sizeField, arrayField);
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    public IArray getArray(IObject coll) throws SnapshotException {
        Object obj = coll.resolveValue(this.arrayField);
        if (obj == null) {
            IObject next = ExtractionUtils.followOnlyOutgoingReferencesExceptLast(this.arrayField, coll);
            if (next == null) {
                return null;
            }
            IArray ret = null;
            ISnapshot snapshot = next.getSnapshot();
            int[] nArray = snapshot.getOutboundReferentIds(next.getObjectId());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                IObject o;
                int i = nArray[n2];
                if (snapshot.isArray(i) && (o = snapshot.getObject(i)) instanceof IArray) {
                    if (ret != null) {
                        return null;
                    }
                    ret = (IArray)o;
                }
                ++n2;
            }
            obj = ret;
        }
        if (obj instanceof IArray) {
            return (IArray)obj;
        }
        if (obj != null) {
            String desc = obj instanceof IObject ? ((IObject)obj).getTechnicalName() : obj.toString();
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), desc});
            throw new SnapshotException(msg);
        }
        return null;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        IArray obj = this.getArray(coll);
        if (obj != null) {
            return obj.getLength();
        }
        return null;
    }

    @Override
    public boolean hasExtractableContents() {
        return false;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        throw new IllegalArgumentException();
    }
}

