/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class CheckBoxEditor
extends ArgumentEditor {
    private Button checkBox;
    private Boolean value = false;
    private Type type;
    private ImageHyperlink button;

    public CheckBoxEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item, Type type) {
        super(parent, context, descriptor, item);
        this.type = type;
        this.setFont(item.getFont());
        this.setBackground(item.getBackground());
        this.setLayout((Layout)new FillLayout());
        if (type.getHelpText() != null) {
            this.setToolTipText(type.getHelpText());
        }
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.checkBox = new Button((Composite)this, 32);
        this.checkBox.setFont(this.item.getFont());
        this.checkBox.setBackground(this.item.getBackground());
        this.checkBox.setText(this.type.getLabel());
        this.checkBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CheckBoxEditor.this.fireFocusEvent(CheckBoxEditor.this.type == Type.GENERAL ? CheckBoxEditor.this.descriptor.getHelp() : CheckBoxEditor.this.type.getHelpText());
            }

            public void focusLost(FocusEvent e) {
                CheckBoxEditor.this.fireFocusEvent(null);
            }
        });
        this.checkBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CheckBoxEditor.this.editingDone();
            }
        });
        this.checkBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    CheckBoxEditor.this.editingDone();
                }
            }
        });
        if (this.getType() != null && this.getType().getFlag() != null) {
            this.createHelpControl(this);
            this.setLayout(new ButtonEditorLayout());
        }
    }

    protected void editingDone() {
        this.value = this.checkBox.getSelection();
        this.fireValueChangedEvent(this.value, this);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws SnapshotException {
        this.value = (Boolean)value;
        this.checkBox.setSelection(this.value.booleanValue());
    }

    public boolean setFocus() {
        return this.checkBox.setFocus();
    }

    public Type getType() {
        return this.type;
    }

    private void createHelpControl(Composite parent) {
        this.button = new ImageHyperlink(parent, 0x1000000){
            {
                this.marginHeight = 0;
            }
        };
        this.button.setImage(MemoryAnalyserPlugin.getImage("$nl$/icons/help.png"));
        this.button.setFont(this.item.getFont());
        this.button.setBackground(this.item.getBackground());
        this.button.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        this.button.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.mat.ui.help/reference/selectingqueries.html#ref_queryarguments__" + CheckBoxEditor.this.getType().getFlag().substring(1));
            }
        });
    }

    private class ButtonEditorLayout
    extends Layout {
        private static final int IMAGE_MARGIN = 0;

        private ButtonEditorLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = CheckBoxEditor.this.button.computeSize(-1, -1, force);
            CheckBoxEditor.this.checkBox.setBounds(0, 0, bounds.width - size.x - 0, bounds.height);
            CheckBoxEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = CheckBoxEditor.this.checkBox.computeSize(-1, -1, force);
            Point buttonSize = CheckBoxEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }

    public static enum Type {
        INCLUDE_CLASS_INSTANCE(Messages.CheckBoxEditor_includeClassInstance, Messages.CheckBoxEditor_includeClassInstanceAdditional, "-include_class_instance"),
        INCLUDE_SUBCLASSES(Messages.CheckBoxEditor_includeSubclasses, Messages.CheckBoxEditor_includeSubclassesAdditional, "-include_subclasses"),
        INTEPRET_AS_CLASSLOADER(Messages.CheckBoxEditor_includeLoadedObjects, Messages.CheckBoxEditor_includeLoadedObjectsAdditional, "-include_loaded_instances"),
        RETAINED(Messages.CheckBoxEditor_asRetainedSet, Messages.CheckBoxEditor_asRetainedSetAdditional, "-retained"),
        VERBOSE(Messages.CheckBoxEditor_verbose, Messages.CheckBoxEditor_verboseAdditional, "-verbose"),
        GENERAL("", null, null);

        private String label;
        private String helpText;
        private String flag;

        private Type(String label, String helpText, String flag) {
            this.label = label;
            this.helpText = helpText;
            this.flag = flag;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String getFlag() {
            return this.flag;
        }
    }
}

