/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.vm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.core.EvaluationContext;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.launching.DebuggableRunner;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.core.QVTiEvaluationContext;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;

public class QVTiVMVirtualMachine
extends VMVirtualMachine {
    private static boolean appendElementSignature(@NonNull StringBuilder s, @Nullable EObject eObject) {
        if (eObject instanceof Root) {
            return false;
        }
        if (eObject instanceof Package) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Package)eObject).getName());
            return true;
        }
        if (eObject instanceof Type) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Type)eObject).getName());
            return true;
        }
        if (eObject instanceof Mapping) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Mapping)eObject).getName());
            return true;
        }
        if (eObject instanceof Domain) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Domain)eObject).getName());
            return true;
        }
        if (eObject instanceof MappingCall) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((MappingCall)eObject).getReferredMapping().getName());
            return true;
        }
        if (eObject instanceof Operation) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            Operation operation = (Operation)eObject;
            s.append(operation.getName());
            s.append("(");
            boolean isFirst = true;
            for (Parameter param : operation.getOwnedParameter()) {
                if (!isFirst) {
                    s.append(", ");
                }
                Type type = param.getType();
                s.append(type.getName());
                isFirst = false;
            }
            s.append(")");
            return true;
        }
        if (eObject instanceof Feature) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Feature)eObject).getName());
            return true;
        }
        if (eObject instanceof Constraint) {
            if (QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Constraint)eObject).getName());
            return true;
        }
        if (eObject != null) {
            return QVTiVMVirtualMachine.appendElementSignature(s, eObject.eContainer());
        }
        return false;
    }

    @NonNull
    public static VMStackFrameData[] createStackFrame(List<UnitLocation> stack) {
        ArrayList<VMStackFrameData> result = new ArrayList<VMStackFrameData>();
        int i = 0;
        for (UnitLocation location : stack) {
            if (location == null) continue;
            result.add(QVTiVMVirtualMachine.createStackFrame(location, i++ == 0));
        }
        return result.toArray(new VMStackFrameData[result.size()]);
    }

    public VMStackFrameData createStackFrame(@NonNull UnitLocation location) {
        return QVTiVMVirtualMachine.createStackFrame(location, true);
    }

    @NonNull
    private static VMStackFrameData createStackFrame(@NonNull UnitLocation location, boolean includeVars) {
        IVMEvaluationEnvironment evalEnv = location.getEvalEnv();
        NamedElement module = location.getModule();
        String moduleName = module != null ? module.getName() : "<null>";
        Element element = location.getElement();
        StringBuilder s = new StringBuilder();
        QVTiVMVirtualMachine.appendElementSignature(s, (EObject)element);
        String operSignature = s.toString();
        List vars = VariableFinder.getVariables((IVMEvaluationEnvironment)evalEnv);
        VMStackFrameData vmStackFrame = new VMStackFrameData(evalEnv.getID(), location.getURI().toString(), moduleName, operSignature, location.getLineNum(), location.getStartPosition(), location.getEndPosition(), vars.toArray(new VMVariableData[vars.size()]));
        return vmStackFrame;
    }

    public QVTiVMVirtualMachine(@NonNull DebuggableRunner runner, @NonNull QVTiEvaluationContext evaluationContext) {
        super(runner, runner.createDebuggableAdapter((EvaluationContext)evaluationContext));
    }

    @NonNull
    public QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }
}

