/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class SpeculationPartition
extends AbstractPartition {
    private final @NonNull Set<@NonNull Node> headNodes;

    public SpeculationPartition(@NonNull MappingPartitioner partitioner) {
        super(partitioner);
        this.headNodes = Sets.newHashSet((Iterable)QVTscheduleUtil.getHeadNodes((Region)this.region));
        for (Node traceNode : partitioner.getTraceNodes()) {
            this.addNode(traceNode, Role.SPECULATION);
        }
        for (Node node : this.headNodes) {
            if (node.isTrue()) continue;
            this.addReachableOldAcyclicNodes(node);
        }
        this.resolveTrueNodes();
        this.resolvePrecedingNodes();
        this.resolveDisambiguations();
        this.resolveEdges();
    }

    protected void addReachableOldAcyclicNodes(@NonNull Node node) {
        if (!this.hasNode(node) && (node.isHead() || node.isOld() && !this.partitioner.isCyclic(node))) {
            this.addNode(node, QVTscheduleUtil.getNodeRole((Node)node));
            for (NavigableEdge edge : node.getNavigationEdges()) {
                if (!edge.isOld()) continue;
                this.addReachableOldAcyclicNodes(edge.getEdgeTarget());
            }
        }
    }

    @Override
    protected @Nullable Iterable<@NonNull Node> getPreferredHeadNodes() {
        return null;
    }

    @Override
    protected @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        ArrayList<@NonNull Node> rootNodes = new ArrayList<Node>();
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)this.region)) {
            if (headNode.isTrue()) continue;
            rootNodes.add(headNode);
        }
        for (Node leafConstant : this.partitioner.getLeafConstantNodes()) {
            rootNodes.add(leafConstant);
        }
        return rootNodes;
    }

    @Override
    protected boolean isAvailable(@NonNull Edge edge) {
        return edge.isConstant() || edge.isLoaded();
    }

    @Override
    protected boolean isAvailable(@NonNull Node node) {
        return node.isConstant() || node.isLoaded();
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) assert (!this.partitioner.hasRealizedEdge(edge));
        return edgeRole;
    }
}

