/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;

public class QvtEngine {
    private static Map<IProject, QvtEngine> ourEnginesMap = new HashMap<IProject, QvtEngine>();
    private QVTOCompiler myCompiler;

    public static QvtEngine getInstance(IResource resource) {
        IProject project = resource.getProject();
        QvtEngine engine = ourEnginesMap.get(project);
        if (engine == null) {
            engine = new QvtEngine();
        }
        return engine;
    }

    private QvtEngine() {
        this.reset(null);
    }

    public CompiledUnit compileUnit(UnitProxy source, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        return this.myCompiler.compile(source, options, monitor);
    }

    public CompiledUnit compileUnit(UnitProxy source, IProgressMonitor monitor) throws MdaException {
        return this.myCompiler.compile(source, null, monitor);
    }

    public QVTOCompiler getQVTOCompiler() {
        return this.myCompiler;
    }

    private void reset(QvtCompilerOptions options) {
        this.myCompiler = new QVTOCompiler();
    }
}

