/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compre.uml2.edit.papyrus.internal.decorator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.PropertiesHandler;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class PapyrusElementFilteredLabelProvider
extends UMLLabelProvider
implements IFilteredLabelProvider {
    private static final String PAPYRUS_PROFILE_URI = "http://www.eclipse.org/papyrus.*";
    private PropertiesHandler propertiesHandler = new PropertiesHandler(this.getCustomizationManager());

    public boolean accept(Object object) {
        EObject eObject = EMFHelper.getEObject((Object)object);
        if (!(eObject instanceof Element)) {
            return false;
        }
        Element element = (Element)eObject;
        Package nearestPackage = element.getNearestPackage();
        if (nearestPackage == null) {
            return false;
        }
        for (Profile profile : nearestPackage.getAllAppliedProfiles()) {
            if (profile.getURI() == null || !profile.getURI().matches(PAPYRUS_PROFILE_URI)) continue;
            return true;
        }
        return false;
    }

    public String getText(Object object) {
        EObject element = (EObject)object;
        ICustomizationManager customizationManager = this.getCustomizationManager();
        if (customizationManager == null) {
            return super.getText(element);
        }
        try {
            return (String)customizationManager.getCustomValueOf(element, this.propertiesHandler.getLabelProperty(), String.class);
        }
        catch (CustomizationException customizationException) {
            return super.getText(element);
        }
    }

    public Image getImage(Object object) {
        EObject element = (EObject)object;
        ICustomizationManager customizationManager = this.getCustomizationManager();
        if (customizationManager == null) {
            return super.getImage(element);
        }
        try {
            return (Image)customizationManager.getCustomValueOf(element, this.propertiesHandler.getImageProperty(), Image.class);
        }
        catch (CustomizationException customizationException) {
            return super.getImage(element);
        }
    }
}

