/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor.extension;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.uml2.internal.MultiplicityElementChange;
import org.eclipse.emf.compare.uml2.internal.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.internal.postprocessor.AbstractUMLChangeFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityElementChangeFactory
extends AbstractUMLChangeFactory {
    @Override
    public boolean handles(Diff input) {
        return this.isChangeOfMultiplicityElement(input) && !this.refinesMultiplicityChange(input);
    }

    private boolean isChangeOfMultiplicityElement(Diff input) {
        EObject container;
        if (input instanceof ReferenceChange) {
            EReference reference = ((ReferenceChange)input).getReference();
            return reference == UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue() || reference == UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
        }
        if (input instanceof AttributeChange && ((container = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input)) instanceof LiteralInteger || container instanceof LiteralUnlimitedNatural)) {
            EStructuralFeature eContainingFeature = container.eContainingFeature();
            return eContainingFeature == UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue() || eContainingFeature == UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
        }
        return false;
    }

    private boolean refinesMultiplicityChange(Diff input) {
        return Iterables.any((Iterable)input.getRefines(), (Predicate)Predicates.instanceOf(MultiplicityElementChange.class));
    }

    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
    }

    @Override
    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        if (refiningDiff.getSource() == extension.getSource()) {
            this.addRefiningDiffAndDependencies(extension, refiningDiff);
        }
    }

    private void addRefiningDiffAndDependencies(Diff extension, Diff refiningDiff) {
        extension.getRefinedBy().add((Object)refiningDiff);
        extension.setKind(refiningDiff.getKind());
    }

    @Override
    protected Switch<Set<EObject>> getDiscriminantsGetter() {
        return new AbstractUMLChangeFactory.DiscriminantsGetter(this){

            public Set<EObject> caseValueSpecification(ValueSpecification object) {
                LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
                result.add((EObject)object);
                return result;
            }
        };
    }

    public Class<? extends Diff> getExtensionKind() {
        return MultiplicityElementChange.class;
    }

    @Override
    protected EObject getDiscriminant(Diff input) {
        return (EObject)Iterables.find(this.getDiscriminants(input), (Predicate)Predicates.instanceOf(ValueSpecification.class), null);
    }

    @Override
    public Match getParentMatch(Diff input) {
        EObject multiplicityElement = this.getDiscriminant(input).eContainer();
        return ComparisonUtil.getComparison((Diff)input).getMatch(multiplicityElement);
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getKind() == DifferenceKind.ADD;
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getKind() == DifferenceKind.DELETE;
    }

    public Diff createExtension() {
        return UMLCompareFactory.eINSTANCE.createMultiplicityElementChange();
    }
}

