/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptorRegistryImpl;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.graph.IGraphConsumer;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;
import org.eclipse.emf.compare.rcp.internal.adapterfactory.AdapterFactoryDescriptorRegistryListener;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.DescriptorRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemRegistry;
import org.eclipse.emf.compare.rcp.internal.match.MatchEngineFactoryRegistryListener;
import org.eclipse.emf.compare.rcp.internal.match.MatchEngineFactoryRegistryWrapper;
import org.eclipse.emf.compare.rcp.internal.match.WeightProviderDescriptorRegistryListener;
import org.eclipse.emf.compare.rcp.internal.merger.MergerExtensionRegistryListener;
import org.eclipse.emf.compare.rcp.internal.policy.LoadOnDemandPolicyRegistryImpl;
import org.eclipse.emf.compare.rcp.internal.policy.LoadOnDemandPolicyRegistryListener;
import org.eclipse.emf.compare.rcp.internal.postprocessor.PostProcessorFactoryRegistryListener;
import org.eclipse.emf.compare.rcp.internal.postprocessor.PostProcessorRegistryImpl;
import org.eclipse.emf.compare.rcp.internal.preferences.EMFComparePreferences;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.osgi.framework.BundleContext;

public class EMFCompareRCPPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.compare.rcp";
    public static final String POST_PROCESSOR_PPID = "postProcessor";
    public static final String DIFF_ENGINE_PPID = "diffEngine";
    public static final String EQUI_ENGINE_PPID = "equiEngine";
    public static final String REQ_ENGINE_PPID = "reqEngine";
    public static final String CONFLICT_DETECTOR_PPID = "conflictsDetector";
    public static final String WEIGHT_PROVIDER_PPID = "weightProvider";
    public static final String LOAD_ON_DEMAND_POLICY_PPID = "loadOnDemandPolicy";
    public static final String MERGER_PPID = "merger";
    public static final String MATCH_ENGINE_PPID = "matchEngine";
    public static final String FACTORY_PPID = "adapterFactory";
    private static final Logger LOGGER = Logger.getLogger((String)"org.eclipse.emf.compare");
    private static final int MEGABYTE = 0x100000;
    private static EMFCompareRCPPlugin plugin;
    private IMerger.Registry mergerRegistry;
    private ItemRegistry<IDiffEngine> diffEngineRegistry;
    private ItemRegistry<IEquiEngine> equiEngineRegistry;
    private ItemRegistry<IReqEngine> reqEngineRegistry;
    private ItemRegistry<IConflictDetector> conflictDetectorRegistry;
    private WeightProvider.Descriptor.Registry weightProviderRegistry;
    private AbstractRegistryEventListener mergerRegistryListener;
    private ILoadOnDemandPolicy.Registry loadOnDemandRegistry;
    private AbstractRegistryEventListener loadOnDemandRegistryListener;
    private IPostProcessor.Descriptor.Registry<String> postProcessorDescriptorsRegistry;
    private IItemRegistry<IPostProcessor.Descriptor> postProcessorItemDescriptorsRegistry;
    private AbstractRegistryEventListener postProcessorFactoryRegistryListener;
    private IItemRegistry<IMatchEngine.Factory> matchEngineFactoryRegistry;
    private MatchEngineFactoryRegistryWrapper matchEngineFactoryRegistryWrapped;
    private MatchEngineFactoryRegistryListener matchEngineFactoryRegistryListener;
    private Multimap<Collection<?>, RankedAdapterFactoryDescriptor> adapterFactoryRegistryBackingMultimap;
    private RankedAdapterFactoryDescriptorRegistryImpl rankedAdapterFactoryRegistry;
    private AbstractRegistryEventListener adapterFactoryRegistryListener;
    private DescriptorRegistryEventListener<IDiffEngine> diffEngineListener;
    private DescriptorRegistryEventListener<IEquiEngine> equiEngineListener;
    private DescriptorRegistryEventListener<IReqEngine> reqEngineListener;
    private DescriptorRegistryEventListener<IConflictDetector> conflictDetectorListener;
    private WeightProviderDescriptorRegistryListener weightProviderListener;
    private LoggingPreferenceChangeListener preferenceChangeListener;
    private Map<String, IGraphView<URI>> graphsById = new HashMap<String, IGraphView<URI>>();

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.setUpAdapterFactoryRegistry(registry);
        this.setUpWeightProviderRegistry(registry);
        this.setUpMatchEngineFactoryRegistry(registry);
        this.setUpMergerRegistry(registry);
        this.setUpPostProcessorRegisty(registry);
        this.setUpLoadOnDemandRegistry(registry);
        this.setUpDiffEngineRegistry(registry);
        this.setUpEquiEngineRegistry(registry);
        this.setUpReqEngineRegistry(registry);
        this.setUpConflictDetectorRegistry(registry);
        this.initLogging();
    }

    private void setUpAdapterFactoryRegistry(IExtensionRegistry registry) {
        this.adapterFactoryRegistryBackingMultimap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
        this.adapterFactoryRegistryListener = new AdapterFactoryDescriptorRegistryListener("org.eclipse.emf.compare.edit", FACTORY_PPID, this.getLog(), this.adapterFactoryRegistryBackingMultimap);
        registry.addListener((IRegistryEventListener)this.adapterFactoryRegistryListener, "org.eclipse.emf.compare.edit.adapterFactory");
        this.adapterFactoryRegistryListener.readRegistry(registry);
        this.rankedAdapterFactoryRegistry = new RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry.INSTANCE, Multimaps.unmodifiableMultimap(this.adapterFactoryRegistryBackingMultimap));
    }

    private void setUpMatchEngineFactoryRegistry(IExtensionRegistry registry) {
        this.matchEngineFactoryRegistry = new ItemRegistry<IMatchEngine.Factory>();
        this.matchEngineFactoryRegistryListener = new MatchEngineFactoryRegistryListener(PLUGIN_ID, MATCH_ENGINE_PPID, this.getLog(), this.matchEngineFactoryRegistry);
        this.matchEngineFactoryRegistryListener.readRegistry(registry);
        this.matchEngineFactoryRegistryWrapped = new MatchEngineFactoryRegistryWrapper(this.matchEngineFactoryRegistry);
    }

    private void setUpMergerRegistry(IExtensionRegistry registry) {
        this.mergerRegistry = new IMerger.RegistryImpl();
        this.mergerRegistryListener = new MergerExtensionRegistryListener(PLUGIN_ID, MERGER_PPID, this.getLog(), this.mergerRegistry);
        registry.addListener((IRegistryEventListener)this.mergerRegistryListener, "org.eclipse.emf.compare.rcp.merger");
        this.mergerRegistryListener.readRegistry(registry);
    }

    private void setUpPostProcessorRegisty(IExtensionRegistry registry) {
        this.postProcessorItemDescriptorsRegistry = new ItemRegistry<IPostProcessor.Descriptor>();
        this.postProcessorFactoryRegistryListener = new PostProcessorFactoryRegistryListener(PLUGIN_ID, POST_PROCESSOR_PPID, this.getLog(), this.postProcessorItemDescriptorsRegistry);
        registry.addListener((IRegistryEventListener)this.postProcessorFactoryRegistryListener, "org.eclipse.emf.compare.rcp.postProcessor");
        this.postProcessorFactoryRegistryListener.readRegistry(registry);
        this.postProcessorDescriptorsRegistry = new PostProcessorRegistryImpl(this.postProcessorItemDescriptorsRegistry);
    }

    private void setUpLoadOnDemandRegistry(IExtensionRegistry registry) {
        this.loadOnDemandRegistry = new LoadOnDemandPolicyRegistryImpl();
        this.loadOnDemandRegistryListener = new LoadOnDemandPolicyRegistryListener(this.loadOnDemandRegistry, PLUGIN_ID, LOAD_ON_DEMAND_POLICY_PPID, this.getLog());
        registry.addListener((IRegistryEventListener)this.loadOnDemandRegistryListener, "org.eclipse.emf.compare.rcp.loadOnDemandPolicy");
        this.loadOnDemandRegistryListener.readRegistry(registry);
    }

    private void setUpDiffEngineRegistry(IExtensionRegistry registry) {
        this.diffEngineRegistry = new ItemRegistry();
        this.diffEngineListener = new DescriptorRegistryEventListener<IDiffEngine>(PLUGIN_ID, DIFF_ENGINE_PPID, this.getLog(), this.diffEngineRegistry);
        registry.addListener(this.diffEngineListener);
        this.diffEngineListener.readRegistry(registry);
    }

    private void setUpEquiEngineRegistry(IExtensionRegistry registry) {
        this.equiEngineRegistry = new ItemRegistry();
        this.equiEngineListener = new DescriptorRegistryEventListener<IEquiEngine>(PLUGIN_ID, EQUI_ENGINE_PPID, this.getLog(), this.equiEngineRegistry);
        registry.addListener(this.equiEngineListener);
        this.equiEngineListener.readRegistry(registry);
    }

    private void setUpReqEngineRegistry(IExtensionRegistry registry) {
        this.reqEngineRegistry = new ItemRegistry();
        this.reqEngineListener = new DescriptorRegistryEventListener<IReqEngine>(PLUGIN_ID, REQ_ENGINE_PPID, this.getLog(), this.reqEngineRegistry);
        registry.addListener(this.reqEngineListener);
        this.reqEngineListener.readRegistry(registry);
    }

    private void setUpConflictDetectorRegistry(IExtensionRegistry registry) {
        this.conflictDetectorRegistry = new ItemRegistry();
        this.conflictDetectorListener = new DescriptorRegistryEventListener<IConflictDetector>(PLUGIN_ID, CONFLICT_DETECTOR_PPID, this.getLog(), this.conflictDetectorRegistry);
        registry.addListener(this.conflictDetectorListener);
        this.conflictDetectorListener.readRegistry(registry);
    }

    private void setUpWeightProviderRegistry(IExtensionRegistry registry) {
        this.weightProviderRegistry = new WeightProviderDescriptorRegistryImpl();
        this.weightProviderListener = new WeightProviderDescriptorRegistryListener(PLUGIN_ID, WEIGHT_PROVIDER_PPID, this.getLog(), this.weightProviderRegistry);
        registry.addListener((IRegistryEventListener)this.weightProviderListener);
        this.weightProviderListener.readRegistry(registry);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.preferenceChangeListener != null) {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceChangeListener);
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.discardConflictDetectorRegistry(registry);
        this.discardReqEngineRegistry(registry);
        this.discardEquiEngineRegistry(registry);
        this.discardDiffEngineRegistry(registry);
        this.discardLoadOnDemandeRegistry(registry);
        this.discardPostProcessorfactoryRegistry(registry);
        this.discardMergerRegistry(registry);
        this.discardMatchEngineRegistry(registry);
        this.discardWeightProviderRegistry(registry);
        this.discardAdapterFactoryRegistry(registry);
        super.stop(bundleContext);
    }

    private void discardReqEngineRegistry(IExtensionRegistry registry) {
        registry.removeListener(this.reqEngineListener);
        this.reqEngineListener = null;
        this.reqEngineRegistry = null;
    }

    private void discardConflictDetectorRegistry(IExtensionRegistry registry) {
        registry.removeListener(this.conflictDetectorListener);
        this.conflictDetectorListener = null;
        this.conflictDetectorRegistry = null;
    }

    private void discardWeightProviderRegistry(IExtensionRegistry registry) {
        registry.removeListener((IRegistryEventListener)this.weightProviderListener);
        this.weightProviderListener = null;
        this.weightProviderRegistry = null;
    }

    private void discardEquiEngineRegistry(IExtensionRegistry registry) {
        registry.removeListener(this.equiEngineListener);
        this.equiEngineListener = null;
        this.equiEngineRegistry = null;
    }

    private void discardDiffEngineRegistry(IExtensionRegistry registry) {
        registry.removeListener(this.diffEngineListener);
        this.diffEngineListener = null;
        this.diffEngineRegistry = null;
    }

    private void discardAdapterFactoryRegistry(IExtensionRegistry registry) {
        this.rankedAdapterFactoryRegistry = null;
        registry.removeListener((IRegistryEventListener)this.adapterFactoryRegistryListener);
        this.adapterFactoryRegistryListener = null;
        this.adapterFactoryRegistryBackingMultimap = null;
    }

    private void discardMatchEngineRegistry(IExtensionRegistry registry) {
        registry.removeListener((IRegistryEventListener)this.matchEngineFactoryRegistryListener);
        this.matchEngineFactoryRegistryListener = null;
        this.matchEngineFactoryRegistry = null;
        this.matchEngineFactoryRegistryWrapped = null;
    }

    private void discardMergerRegistry(IExtensionRegistry registry) {
        registry.removeListener((IRegistryEventListener)this.mergerRegistryListener);
        this.mergerRegistryListener = null;
        this.mergerRegistry = null;
    }

    private void discardPostProcessorfactoryRegistry(IExtensionRegistry registry) {
        registry.removeListener((IRegistryEventListener)this.postProcessorFactoryRegistryListener);
        this.postProcessorFactoryRegistryListener = null;
        this.postProcessorDescriptorsRegistry = null;
        this.postProcessorItemDescriptorsRegistry = null;
    }

    private void discardLoadOnDemandeRegistry(IExtensionRegistry registry) {
        registry.removeListener((IRegistryEventListener)this.loadOnDemandRegistryListener);
        this.loadOnDemandRegistryListener = null;
        this.loadOnDemandRegistry = null;
    }

    public RankedAdapterFactoryDescriptor.Registry getAdapterFactoryRegistry() {
        return this.rankedAdapterFactoryRegistry;
    }

    @Deprecated
    public RankedAdapterFactoryDescriptor.Registry createFilteredAdapterFactoryRegistry() {
        return this.createFilteredAdapterFactoryRegistry(Maps.newLinkedHashMap());
    }

    public RankedAdapterFactoryDescriptor.Registry createFilteredAdapterFactoryRegistry(Map<Object, Object> context) {
        final List<String> disabledAdapterFactories = EMFComparePreferences.getDisabledAdapterFactoryDescriptorIds();
        ImmutableMultimap filteredBackingMultimap = ImmutableMultimap.copyOf((Multimap)Multimaps.filterValues(this.adapterFactoryRegistryBackingMultimap, (Predicate)new Predicate<RankedAdapterFactoryDescriptor>(){

            public boolean apply(RankedAdapterFactoryDescriptor input) {
                return !disabledAdapterFactories.contains(input.getId());
            }
        }));
        return new RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry.INSTANCE, (Multimap)filteredBackingMultimap, context);
    }

    public IMerger.Registry getMergerRegistry() {
        return this.mergerRegistry;
    }

    public IPostProcessor.Descriptor.Registry<String> getPostProcessorRegistry() {
        return this.postProcessorDescriptorsRegistry;
    }

    public IItemRegistry<IPostProcessor.Descriptor> getPostProcessorDescriptorRegistry() {
        return this.postProcessorItemDescriptorsRegistry;
    }

    public ILoadOnDemandPolicy.Registry getLoadOnDemandPolicyRegistry() {
        return this.loadOnDemandRegistry;
    }

    public IItemRegistry<IDiffEngine> getDiffEngineDescriptorRegistry() {
        return this.diffEngineRegistry;
    }

    public IItemRegistry<IEquiEngine> getEquiEngineDescriptorRegistry() {
        return this.equiEngineRegistry;
    }

    public IItemRegistry<IReqEngine> getReqEngineDescriptorRegistry() {
        return this.reqEngineRegistry;
    }

    public IItemRegistry<IConflictDetector> getConflictDetectorDescriptorRegistry() {
        return this.conflictDetectorRegistry;
    }

    public WeightProvider.Descriptor.Registry getWeightProviderRegistry() {
        return this.weightProviderRegistry;
    }

    public IMatchEngine.Factory.Registry getMatchEngineFactoryRegistry() {
        return this.matchEngineFactoryRegistryWrapped;
    }

    public IItemRegistry<IMatchEngine.Factory> getMatchEngineFactoryDescriptorRegistry() {
        return this.matchEngineFactoryRegistry;
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public static EMFCompareRCPPlugin getDefault() {
        return plugin;
    }

    private void initLogging() {
        LOGGER.setLevel(Level.toLevel((String)Platform.getPreferencesService().getString(PLUGIN_ID, "org.eclipse.emf.compare.log.level", "OFF", null)));
        if (!Level.OFF.equals((Object)LOGGER.getLevel())) {
            RollingFileAppender appender = (RollingFileAppender)LOGGER.getAppender("EMFCFile");
            String logFileName = Platform.getPreferencesService().getString(PLUGIN_ID, "org.eclipse.emf.compare.log.file.name", "", null);
            if (logFileName.length() > 0) {
                if (appender == null) {
                    try {
                        this.createLogAppender(logFileName);
                    }
                    catch (IOException iOException) {
                        Platform.getPreferencesService().getString(PLUGIN_ID, "org.eclipse.emf.compare.log.file.name", "", null);
                    }
                } else {
                    appender.setMaxBackupIndex(Platform.getPreferencesService().getInt(PLUGIN_ID, "org.eclipse.emf.compare.log.backup.count", 10, null));
                    appender.setMaximumFileSize((long)(Platform.getPreferencesService().getInt(PLUGIN_ID, "org.eclipse.emf.compare.log.file.max.size", 100, null) * 0x100000));
                }
            }
        }
        this.preferenceChangeListener = new LoggingPreferenceChangeListener();
        InstanceScope.INSTANCE.getNode(PLUGIN_ID).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceChangeListener);
    }

    private void createLogAppender(String newFileName) throws IOException {
        RollingFileAppender appender = new RollingFileAppender((Layout)new PatternLayout("%d{ISO8601} [%t] %-5p %c{3} %x - %m%n"), newFileName, true);
        LOGGER.removeAllAppenders();
        LOGGER.addAppender((Appender)appender);
        appender.setMaxBackupIndex(Platform.getPreferencesService().getInt(PLUGIN_ID, "org.eclipse.emf.compare.log.backup.count", 10, null));
        appender.setMaximumFileSize((long)(Platform.getPreferencesService().getInt(PLUGIN_ID, "org.eclipse.emf.compare.log.file.max.size", 100, null) * 0x100000));
    }

    public void register(IGraphConsumer consumer) {
        consumer.setGraph((IGraph<URI>)new Graph());
        String id = consumer.getId();
        if (this.graphsById.containsKey(id)) {
            throw new IllegalArgumentException(EMFCompareRCPMessages.getString("duplicate.graph.id.msg", id));
        }
        this.graphsById.put(id, consumer.getGraphView());
    }

    public IGraphView<URI> getGraphView(String id) {
        return this.graphsById.get(id);
    }

    private static class LoggingPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private String path;
        private Level loggingLevel;

        private LoggingPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            RollingFileAppender appender;
            IPreferencesService prefs = Platform.getPreferencesService();
            this.path = prefs.getString(EMFCompareRCPPlugin.PLUGIN_ID, "org.eclipse.emf.compare.log.file.name", "", null);
            if ("org.eclipse.emf.compare.log.level".equals(event.getKey())) {
                this.loggingLevel = Level.toLevel((String)((String)event.getNewValue()));
                LOGGER.setLevel(this.loggingLevel);
            } else if ("org.eclipse.emf.compare.log.file.name".equals(event.getKey())) {
                this.path = (String)event.getNewValue();
            } else if ("org.eclipse.emf.compare.log.backup.count".equals(event.getKey())) {
                RollingFileAppender appender2 = (RollingFileAppender)LOGGER.getAppender("EMFCFile");
                if (appender2 != null) {
                    appender2.setMaxBackupIndex(Integer.parseInt((String)event.getNewValue()));
                }
            } else if ("org.eclipse.emf.compare.log.file.max.size".equals(event.getKey()) && (appender = (RollingFileAppender)LOGGER.getAppender("EMFCFile")) != null) {
                appender.setMaximumFileSize((long)(Integer.parseInt((String)event.getNewValue()) * 0x100000));
            }
            if (this.loggingLevel != null && !Level.OFF.equals((Object)this.loggingLevel) && this.path != null && this.path.length() > 0) {
                this.initFile();
            }
        }

        private void initFile() {
            RollingFileAppender appender = (RollingFileAppender)LOGGER.getAppender("EMFCFile");
            if (appender == null) {
                try {
                    EMFCompareRCPPlugin.getDefault().createLogAppender(this.path);
                }
                catch (IOException e) {
                    InstanceScope.INSTANCE.getNode(EMFCompareRCPPlugin.PLUGIN_ID).put("org.eclipse.emf.compare.log.file.name", "");
                    EMFCompareRCPPlugin.getDefault().log(4, EMFCompareRCPMessages.getString("logging.appender.error", this.path, e.getMessage()));
                }
            } else {
                appender.setFile(this.path);
            }
        }
    }
}

