/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.IMerger;

public abstract class AbstractMergeRunnable {
    private final boolean isLeftEditable;
    private final boolean isRightEditable;
    private final MergeMode mergeMode;

    public AbstractMergeRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode) {
        this.isLeftEditable = isLeftEditable;
        this.isRightEditable = isRightEditable;
        this.mergeMode = mergeMode;
    }

    protected boolean isLeftEditable() {
        return this.isLeftEditable;
    }

    protected boolean isRightEditable() {
        return this.isRightEditable;
    }

    protected MergeMode getMergeMode() {
        return this.mergeMode;
    }

    protected void markAllAsMerged(Collection<? extends Diff> diffToMarkAsMerged, MergeMode mode, IMerger.Registry mergerRegistry) {
        Iterator<? extends Diff> iterator = diffToMarkAsMerged.iterator();
        while (iterator.hasNext()) {
            Diff diff;
            boolean isLeftToRight = mode.isLeftToRight(diff = iterator.next(), this.isLeftEditable, this.isRightEditable);
            this.markAsMerged(diff, mode, !isLeftToRight, mergerRegistry);
        }
    }

    protected void markAsMerged(Diff diff, MergeMode mode, boolean mergeRightToLeft, IMerger.Registry mergerRegistry) {
        if (AbstractMerger.isInTerminalState((Diff)diff)) {
            return;
        }
        if (AbstractMerger.isAccepting((Diff)diff, (boolean)mergeRightToLeft)) {
            Set implied = MergeDependenciesUtil.getAllResultingMerges((Diff)diff, (IMerger.Registry)mergerRegistry, (boolean)mergeRightToLeft);
            Set rejections = MergeDependenciesUtil.getAllResultingRejections((Diff)diff, (IMerger.Registry)mergerRegistry, (boolean)mergeRightToLeft);
            for (Diff impliedDiff : Sets.difference((Set)implied, (Set)rejections)) {
                impliedDiff.setState(DifferenceState.MERGED);
            }
            for (Diff impliedRejection : rejections) {
                impliedRejection.setState(DifferenceState.DISCARDED);
            }
        } else {
            Set implied = MergeDependenciesUtil.getAllResultingMerges((Diff)diff, (IMerger.Registry)mergerRegistry, (boolean)mergeRightToLeft);
            for (Diff impliedDiff : implied) {
                impliedDiff.setState(DifferenceState.DISCARDED);
            }
        }
    }
}

