/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public final class MergeDependenciesUtil {
    private MergeDependenciesUtil() {
    }

    public static Set<Diff> getAllResultingMerges(Diff diff, IMerger.Registry mergerRegistry, boolean rightToLeft) {
        LinkedHashSet<Diff> resultingMerges = new LinkedHashSet<Diff>();
        resultingMerges.add(diff);
        Set<Diff> relations = MergeDependenciesUtil.internalGetResultingMerges(diff, mergerRegistry, rightToLeft);
        Set difference = Sets.filter((Set)Sets.difference(relations, resultingMerges), (Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)));
        while (!difference.isEmpty()) {
            LinkedHashSet newRelations = new LinkedHashSet(difference);
            resultingMerges.addAll(newRelations);
            relations = new LinkedHashSet<Diff>();
            for (Diff newRelation : newRelations) {
                Set<Diff> internalResultingMerges = MergeDependenciesUtil.internalGetResultingMerges(newRelation, mergerRegistry, rightToLeft);
                relations.addAll(Sets.filter(internalResultingMerges, (Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO))));
            }
            difference = Sets.difference(relations, resultingMerges);
        }
        if (diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.PSEUDO) {
            resultingMerges.addAll((Collection<Diff>)diff.getConflict().getDifferences());
        }
        return resultingMerges;
    }

    private static Set<Diff> internalGetResultingMerges(Diff diff, IMerger.Registry mergerRegistry, boolean rightToLeft) {
        Set<Object> directImplications;
        Set<Object> directParents;
        IMerger merger = mergerRegistry.getHighestRankingMerger(diff);
        if (merger instanceof IMerger2) {
            directParents = ((IMerger2)merger).getDirectMergeDependencies(diff, rightToLeft);
            directImplications = ((IMerger2)merger).getDirectResultingMerges(diff, rightToLeft);
        } else {
            directParents = Collections.emptySet();
            directImplications = Collections.emptySet();
        }
        Sets.SetView directRelated = Sets.union(directParents, directImplications);
        return directRelated;
    }

    public static Set<Diff> getAllResultingRejections(Diff diff, IMerger.Registry mergerRegistry, boolean mergeRightToLeft) {
        LinkedHashSet<Diff> resultingRejections = new LinkedHashSet<Diff>();
        Set<Diff> allResultingMerges = MergeDependenciesUtil.getAllResultingMerges(diff, mergerRegistry, mergeRightToLeft);
        resultingRejections.addAll(Sets.filter(allResultingMerges, (Predicate)Predicates.and((Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)), (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(diff)))));
        for (Diff resulting : Sets.filter(allResultingMerges, EMFComparePredicates.sameSideAs(diff))) {
            Set<Diff> rejections = MergeDependenciesUtil.internalGetResultingRejections(resulting, mergerRegistry, mergeRightToLeft);
            Set difference = Sets.filter(rejections, (Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)));
            while (!difference.isEmpty()) {
                LinkedHashSet newRejections = new LinkedHashSet(difference);
                resultingRejections.addAll(newRejections);
                rejections = new LinkedHashSet<Diff>();
                for (Diff rejected : newRejections) {
                    IMerger merger = mergerRegistry.getHighestRankingMerger(rejected);
                    if (!(merger instanceof IMerger2)) continue;
                    Set<Diff> directMergeDependencies = ((IMerger2)merger).getDirectMergeDependencies(rejected, mergeRightToLeft);
                    rejections.addAll(Sets.filter(directMergeDependencies, (Predicate)Predicates.and((Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)), (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(diff)))));
                    Set<Diff> directResultingMerges = ((IMerger2)merger).getDirectResultingMerges(rejected, mergeRightToLeft);
                    rejections.addAll(Sets.filter(directResultingMerges, (Predicate)Predicates.and((Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.PSEUDO)), (Predicate)Predicates.not(EMFComparePredicates.sameSideAs(diff)))));
                }
                difference = Sets.difference(rejections, resultingRejections);
            }
        }
        return resultingRejections;
    }

    private static Set<Diff> internalGetResultingRejections(Diff diff, IMerger.Registry mergerRegistry, boolean rightToLeft) {
        IMerger merger = mergerRegistry.getHighestRankingMerger(diff);
        if (merger instanceof IMerger2) {
            return ((IMerger2)merger).getDirectResultingRejections(diff, rightToLeft);
        }
        return Collections.emptySet();
    }
}

