/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.adapterfactory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.compare.internal.adapterfactory.context.ContextUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class RankedAdapterFactoryDescriptorRegistryImpl
implements RankedAdapterFactoryDescriptor.Registry {
    private final ComposedAdapterFactory.Descriptor.Registry delegateRegistry;
    private final Multimap<Collection<?>, RankedAdapterFactoryDescriptor> emfCompareAdapterFactoryRegistry;
    private final Map<Object, Object> context;

    public RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry delegateRegistry, Multimap<Collection<?>, RankedAdapterFactoryDescriptor> adapterFactoryRegistryBackingMultimap) {
        this(delegateRegistry, adapterFactoryRegistryBackingMultimap, Maps.newLinkedHashMap());
    }

    public RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry delegateRegistry, Multimap<Collection<?>, RankedAdapterFactoryDescriptor> adapterFactoryRegistryBackingMultimap, Map<Object, Object> context) {
        this.delegateRegistry = delegateRegistry;
        this.emfCompareAdapterFactoryRegistry = adapterFactoryRegistryBackingMultimap;
        this.context = Collections.unmodifiableMap(context);
    }

    public ComposedAdapterFactory.Descriptor getDescriptor(Collection<?> types) {
        RankedAdapterFactoryDescriptor ret = this.getRankedDescriptor(types);
        if (ret == null) {
            ret = this.delegatedGetDescriptor(types);
        }
        return ret;
    }

    private RankedAdapterFactoryDescriptor getRankedDescriptor(Collection<?> types) {
        ArrayList<String> stringTypes = new ArrayList<String>(types.size());
        for (Object key : types) {
            if (key instanceof EPackage) {
                stringTypes.add(((EPackage)key).getNsURI());
                continue;
            }
            if (key instanceof Package) {
                stringTypes.add(((Package)key).getName());
                continue;
            }
            if (!(key instanceof Class)) continue;
            stringTypes.add(((Class)key).getName());
        }
        return this.getHighestRankedDescriptor(stringTypes);
    }

    private RankedAdapterFactoryDescriptor getHighestRankedDescriptor(List<String> stringTypes) {
        RankedAdapterFactoryDescriptor result = null;
        for (RankedAdapterFactoryDescriptor descriptor : this.emfCompareAdapterFactoryRegistry.get(stringTypes)) {
            boolean equalRankButContextTester;
            if (!ContextUtil.apply(descriptor, this.context)) continue;
            boolean firstMatch = result == null;
            boolean higherRank = result != null && descriptor.getRanking() > result.getRanking();
            boolean bl = equalRankButContextTester = result != null && descriptor.getRanking() == result.getRanking() && result.getContextTester() == null && descriptor.getContextTester() != null;
            if (!firstMatch && !higherRank && !equalRankButContextTester) continue;
            result = descriptor;
        }
        return result;
    }

    protected ComposedAdapterFactory.Descriptor delegatedGetDescriptor(Collection<?> types) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getDescriptor(types);
        }
        return null;
    }

    @Override
    public Set<RankedAdapterFactoryDescriptor> getDescriptors() {
        return ImmutableSet.copyOf((Collection)this.emfCompareAdapterFactoryRegistry.values());
    }
}

