/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.AbstractConfigurationUI;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.IConfigurationUIFactory;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.DataHolder;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.impl.InteractiveUIContent;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class EnginesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final IItemRegistry<IMatchEngine.Factory> MATCH_ENGINE_REGISTRY = EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry();
    private static final IItemRegistry<IReqEngine> REQ_ENGINE_REGISTRY = EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry();
    private static final IItemRegistry<IDiffEngine> DIFF_ENGINE_REGISTRY = EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry();
    private static final IItemRegistry<IEquiEngine> EQUI_ENGINE_REGISTRY = EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry();
    private static final IItemRegistry<IConflictDetector> CONFLICT_DETECTOR_REGISTRY = EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry();
    private final Map<String, InteractiveUIContent> interactiveUis = new HashMap<String, InteractiveUIContent>();
    private final DataHolder<IDiffEngine> diffEngineData = new DataHolder();
    private final DataHolder<IEquiEngine> equiEngineData = new DataHolder();
    private final DataHolder<IReqEngine> reqEngineData = new DataHolder();
    private final DataHolder<IConflictDetector> conflictsDetectorData = new DataHolder();
    private final DataHolder<IMatchEngine.Factory> matchEnginesData = new DataHolder();

    public EnginesPreferencePage() {
    }

    public EnginesPreferencePage(String title) {
        super(title);
    }

    public EnginesPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
        store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        TabFolder tabFolder = new TabFolder(container, 0);
        this.createMatchEngineTab(tabFolder);
        this.createDiffEngineTab(tabFolder);
        this.createEquiEngineTab(tabFolder);
        this.createReqEngineTab(tabFolder);
        this.createConflictDetectorTab(tabFolder);
        return container;
    }

    private <T> InteractiveUIContent createEngineUIBuilder(IItemRegistry<T> registry, Composite tabComposite, DataHolder<T> dataHolder) {
        String preferenceKey = this.preferenceKey(registry);
        IItemDescriptor defaultEngine = ItemUtil.getDefaultItemDescriptor(registry, (String)preferenceKey);
        InteractiveUIContent.InteractiveUIBuilder<T> uiBuilder = new InteractiveUIContent.InteractiveUIBuilder<T>(tabComposite, registry);
        uiBuilder.setSimple(true).setDefaultCheck(Collections.singleton(defaultEngine)).setDefaultSelection(defaultEngine).setHoldingData(dataHolder);
        return uiBuilder.build();
    }

    private String preferenceKey(IItemRegistry<?> registry) {
        if (registry == MATCH_ENGINE_REGISTRY) {
            return "org.eclipse.emf.compare.preference.match.engine";
        }
        if (registry == DIFF_ENGINE_REGISTRY) {
            return "org.eclipse.emf.compare.preference.diff.engine";
        }
        if (registry == REQ_ENGINE_REGISTRY) {
            return "org.eclipse.emf.compare.preference.req.engine";
        }
        if (registry == EQUI_ENGINE_REGISTRY) {
            return "org.eclipse.emf.compare.preference.equi.engine";
        }
        if (registry == CONFLICT_DETECTOR_REGISTRY) {
            return "org.eclipse.emf.compare.preference.conflict.detector";
        }
        throw new IllegalArgumentException("Unknown registry.");
    }

    private void createConflictDetectorTab(TabFolder tabFolder) {
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.conflictDetector.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.conflictDetectorIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(CONFLICT_DETECTOR_REGISTRY, tabComposite, this.conflictsDetectorData);
        this.interactiveUis.put(this.preferenceKey(CONFLICT_DETECTOR_REGISTRY), interactiveContent);
    }

    private void createReqEngineTab(TabFolder tabFolder) {
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.requirementEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.reqEngineIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(REQ_ENGINE_REGISTRY, tabComposite, this.reqEngineData);
        this.interactiveUis.put(this.preferenceKey(REQ_ENGINE_REGISTRY), interactiveContent);
    }

    private void createEquiEngineTab(TabFolder tabFolder) {
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.equivalenceEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.equiEngineIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(EQUI_ENGINE_REGISTRY, tabComposite, this.equiEngineData);
        this.interactiveUis.put(this.preferenceKey(EQUI_ENGINE_REGISTRY), interactiveContent);
    }

    private void createDiffEngineTab(TabFolder tabFolder) {
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.differenceEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.diffEngineIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(DIFF_ENGINE_REGISTRY, tabComposite, this.diffEngineData);
        this.interactiveUis.put(this.preferenceKey(DIFF_ENGINE_REGISTRY), interactiveContent);
    }

    private void createMatchEngineTab(TabFolder tabFolder) {
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.matchEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.matchEngineIntro.text"));
        Map<String, IConfigurationUIFactory> configuratorUIRegistry = EMFCompareRCPUIPlugin.getDefault().getMatchEngineConfiguratorRegistry();
        Set activeItems = ItemUtil.getActiveItems(MATCH_ENGINE_REGISTRY, (String)"org.eclipse.emf.compare.rcp", (String)"org.eclipse.emf.compare.preference.match.engine");
        InteractiveUIContent.InteractiveUIBuilder<IMatchEngine.Factory> builder = new InteractiveUIContent.InteractiveUIBuilder<IMatchEngine.Factory>(tabComposite, MATCH_ENGINE_REGISTRY);
        builder.setConfiguratorUIRegistry(configuratorUIRegistry).setDefaultCheck(activeItems).setConfigurationNodeKey("org.eclipse.emf.compare.preference.match.engine").setHoldingData(this.matchEnginesData);
        InteractiveUIContent uiContent = builder.build();
        uiContent.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (!event.getChecked() && ((CheckboxTableViewer)event.getSource()).getCheckedElements().length == 0) {
                    ((CheckboxTableViewer)event.getSource()).setCheckedElements(new Object[]{element});
                    MessageDialog.openWarning((Shell)EnginesPreferencePage.this.getShell(), (String)EMFCompareRCPUIMessages.getString("InteractiveUIContent.incorrectSelection.title"), (String)EMFCompareRCPUIMessages.getString("InteractiveUIContent.incorrectSelection.message"));
                }
            }
        });
        this.interactiveUis.put("org.eclipse.emf.compare.preference.match.engine", uiContent);
    }

    private Composite createTabSkeleton(TabFolder tabFolder, String tabLabel, String introText) {
        TabItem tbtmMain = new TabItem(tabFolder, 0);
        tbtmMain.setText(tabLabel);
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tbtmMain.setControl((Control)tabComposite);
        tabComposite.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(4, 4, false, false, 1, 1);
        tabComposite.setLayoutData((Object)layoutData);
        Label descriptionText = new Label(tabComposite, 64);
        descriptionText.setText(introText);
        return tabComposite;
    }

    public boolean performOk() {
        this.setEnginesPreferences();
        this.storeConfigurations();
        return super.performOk();
    }

    private void setEnginesPreferences() {
        this.setEnginePreferences(DIFF_ENGINE_REGISTRY, this.diffEngineData);
        this.setEnginePreferences(EQUI_ENGINE_REGISTRY, this.equiEngineData);
        this.setEnginePreferences(REQ_ENGINE_REGISTRY, this.reqEngineData);
        this.setEnginePreferences(CONFLICT_DETECTOR_REGISTRY, this.conflictsDetectorData);
        this.setEnginePreferences(MATCH_ENGINE_REGISTRY, this.matchEnginesData, DefaultOption.ALL, StoreOption.DISABLED_ITEMS);
    }

    private void storeConfigurations() {
        for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
            for (Map.Entry<String, AbstractConfigurationUI> configuratorEntry : interactiveContentEntry.getValue().getConfigurators().entrySet()) {
                AbstractConfigurationUI configurator = configuratorEntry.getValue();
                configurator.storeConfiguration();
            }
        }
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder traceMessage = new StringBuilder("Engines preference serialization:\n");
            String prefDelimiter = " :\n";
            String newLine = "\n";
            traceMessage.append("org.eclipse.emf.compare.preference.diff.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.diff.engine")).append(newLine);
            traceMessage.append("org.eclipse.emf.compare.preference.equi.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.equi.engine")).append(newLine);
            traceMessage.append("org.eclipse.emf.compare.preference.req.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.req.engine")).append(newLine);
            traceMessage.append("org.eclipse.emf.compare.preference.conflict.detector").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.conflict.detector")).append(newLine);
            traceMessage.append("org.eclipse.emf.compare.preference.match.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.match.engine")).append(newLine);
            EMFCompareRCPPlugin.getDefault().log(1, traceMessage.toString());
        }
    }

    protected void performDefaults() {
        this.resetDefaultPreferences(DIFF_ENGINE_REGISTRY, this.diffEngineData);
        this.resetDefaultPreferences(REQ_ENGINE_REGISTRY, this.reqEngineData);
        this.resetDefaultPreferences(EQUI_ENGINE_REGISTRY, this.equiEngineData);
        this.resetDefaultPreferences(CONFLICT_DETECTOR_REGISTRY, this.conflictsDetectorData);
        this.resetDefaultPreferences(MATCH_ENGINE_REGISTRY, this.matchEnginesData, DefaultOption.ALL, StoreOption.DISABLED_ITEMS);
        this.resetConfigurations();
        super.performDefaults();
    }

    private void resetConfigurations() {
        for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
            for (AbstractConfigurationUI configurator : interactiveContentEntry.getValue().getConfigurators().values()) {
                configurator.resetDefault();
            }
        }
    }

    private <T> void resetDefaultPreferences(IItemRegistry<T> registry, DataHolder<T> dataObject) {
        this.resetDefaultPreferences(registry, dataObject, DefaultOption.HIGHEST_RANKED, StoreOption.ENABLED_ITEMS);
    }

    private <T> void resetDefaultPreferences(IItemRegistry<T> registry, DataHolder<T> dataObject, DefaultOption defaultOption, StoreOption storeOption) {
        InteractiveUIContent interactiveContent = this.interactiveUis.get(this.preferenceKey(registry));
        if (interactiveContent != null) {
            Set<IItemDescriptor<T>> defaultEngines = this.getDefaultDescriptors(registry, defaultOption);
            Set<IItemDescriptor<T>> defaultEnginesToSelect = this.getItemsToSelect(defaultEngines, registry, storeOption);
            interactiveContent.selectAll(defaultEnginesToSelect);
            interactiveContent.checkElements(defaultEnginesToSelect);
            dataObject.setData(defaultEnginesToSelect);
        }
    }

    private <T> Set<IItemDescriptor<T>> getItemsToSelect(Set<IItemDescriptor<T>> engines, IItemRegistry<T> registry, StoreOption storeOption) {
        Set<IItemDescriptor<T>> itemsToStore = this.getItemsToStore(engines, registry, storeOption);
        if (StoreOption.DISABLED_ITEMS.equals((Object)storeOption) && itemsToStore.isEmpty()) {
            return Sets.newHashSet((Iterable)registry.getItemDescriptors());
        }
        return itemsToStore;
    }

    private <T> Set<IItemDescriptor<T>> getDefaultDescriptors(IItemRegistry<T> registry, DefaultOption defaultOption) {
        String defaultValue = this.getPreferenceStore().getDefaultString(this.preferenceKey(registry));
        LinkedHashSet<IItemDescriptor<T>> defaultDescriptors = new LinkedHashSet<IItemDescriptor<T>>();
        if (!Strings.isNullOrEmpty((String)defaultValue)) {
            String[] stringArray = defaultValue.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String engineId = stringArray[n2];
                IItemDescriptor itemDescriptor = registry.getItemDescriptor(engineId);
                if (itemDescriptor != null) {
                    defaultDescriptors.add(itemDescriptor);
                }
                ++n2;
            }
        }
        if (defaultDescriptors.isEmpty()) {
            switch (defaultOption) {
                case ALL: {
                    defaultDescriptors.addAll(registry.getItemDescriptors());
                    break;
                }
                default: {
                    defaultDescriptors.add(registry.getHighestRankingDescriptor());
                }
            }
        }
        return defaultDescriptors;
    }

    private <T> void setEnginePreferences(IItemRegistry<T> registry, DataHolder<T> data) {
        this.setEnginePreferences(registry, data, DefaultOption.HIGHEST_RANKED, StoreOption.ENABLED_ITEMS);
    }

    private <T> void setEnginePreferences(IItemRegistry<T> registry, DataHolder<T> data, DefaultOption defaultOption, StoreOption storeOption) {
        Set<IItemDescriptor<T>> selectedEngines = data.getData();
        Set<IItemDescriptor<T>> toStore = this.getItemsToStore(selectedEngines, registry, storeOption);
        if (this.deviatesFromDefaults(toStore, registry, defaultOption, storeOption)) {
            StringBuilder descriptorsKey = new StringBuilder();
            Iterator<IItemDescriptor<T>> iterator = toStore.iterator();
            while (iterator.hasNext()) {
                IItemDescriptor<T> iItemDescriptor = iterator.next();
                descriptorsKey.append(iItemDescriptor.getID());
                if (!iterator.hasNext()) continue;
                descriptorsKey.append(";");
            }
            this.getPreferenceStore().setValue(this.preferenceKey(registry), descriptorsKey.toString());
        } else {
            this.getPreferenceStore().setToDefault(this.preferenceKey(registry));
        }
    }

    private <T> Set<IItemDescriptor<T>> getItemsToStore(Set<IItemDescriptor<T>> selectedEngines, IItemRegistry<T> registry, StoreOption storeOption) {
        switch (storeOption) {
            case DISABLED_ITEMS: {
                return Sets.difference((Set)Sets.newHashSet((Iterable)registry.getItemDescriptors()), selectedEngines);
            }
        }
        return selectedEngines;
    }

    private <T> boolean deviatesFromDefaults(Set<IItemDescriptor<T>> itemsToStore, IItemRegistry<T> registry, DefaultOption defaultOption, StoreOption storeOption) {
        Set<IItemDescriptor<T>> defaults = this.getDefaultDescriptors(registry, defaultOption);
        return itemsToStore != null && !Sets.symmetricDifference(defaults, itemsToStore).isEmpty();
    }

    private static enum DefaultOption {
        HIGHEST_RANKED,
        ALL;

    }

    private static enum StoreOption {
        ENABLED_ITEMS,
        DISABLED_ITEMS;

    }
}

