/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.match;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.match.MatchEngineFactoryDescriptor;

public class MatchEngineFactoryRegistryListener
extends AbstractRegistryEventListener {
    public static final String ATT_CLASS = "class";
    private static final String TAG_ENGINE_FACTORY = "engineFactory";
    private static final String ATT_RANKING = "ranking";
    private static final String ATT_LABEL = "label";
    private static final String ATT_DESCRIPTION = "description";
    private final IItemRegistry<IMatchEngine.Factory> matchEngineFactoryRegistry;

    public MatchEngineFactoryRegistryListener(String pluginID, String extensionPointID, ILog log, IItemRegistry<IMatchEngine.Factory> registry) {
        super(pluginID, extensionPointID, log);
        this.matchEngineFactoryRegistry = registry;
    }

    @Override
    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean ret;
        if (TAG_ENGINE_FACTORY.equals(element.getName())) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                ret = false;
            } else if (element.getAttribute(ATT_RANKING) == null) {
                this.logMissingAttribute(element, ATT_RANKING);
                ret = false;
            } else if (element.getAttribute(ATT_RANKING) != null) {
                String rankingStr = element.getAttribute(ATT_RANKING);
                try {
                    Integer.parseInt(rankingStr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", ATT_RANKING));
                    return false;
                }
                ret = true;
            } else {
                ret = true;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    @Override
    protected boolean addedValid(IConfigurationElement element) {
        int rank;
        String description;
        String label = element.getAttribute(ATT_LABEL);
        MatchEngineFactoryDescriptor descriptor = new MatchEngineFactoryDescriptor(label, description = element.getAttribute(ATT_DESCRIPTION), rank = Integer.parseInt(element.getAttribute(ATT_RANKING)), element, element.getAttribute(ATT_CLASS));
        IItemDescriptor<IMatchEngine.Factory> previous = this.matchEngineFactoryRegistry.add(descriptor);
        if (previous != null) {
            this.log(2, element, EMFCompareRCPMessages.getString("duplicate.extension", this.matchEngineFactoryRegistry.getClass().getName()));
        }
        return true;
    }

    @Override
    protected boolean removedValid(IConfigurationElement element) {
        this.matchEngineFactoryRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

