/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractTableOrTreeItemWrapper {
    public static AbstractTableOrTreeItemWrapper create(Item item) {
        AbstractTableOrTreeItemWrapper wrapper;
        if (item instanceof TreeItem) {
            wrapper = new TreeItemWrapper((TreeItem)item);
        } else if (item instanceof TableItem) {
            wrapper = new TableItemWrapper((TableItem)item);
        } else if (item == null) {
            wrapper = null;
        } else {
            throw new IllegalArgumentException("Item must be instance of TreeItem or TableItem");
        }
        return wrapper;
    }

    protected abstract Item getItem();

    public abstract Rectangle getBounds();

    public abstract Scrollable getParent();

    public abstract int getParentColumnCount();

    public abstract Rectangle getImageBounds(int var1);

    public abstract Rectangle getTextBounds(int var1);

    public abstract String getText(int var1);

    public abstract Image getImage(int var1);

    public abstract AbstractTableOrTreeItemWrapper getParentItem();

    public abstract int getParentItemHeight();

    public Object getData() {
        return this.getItem().getData();
    }

    private static class TableItemWrapper
    extends AbstractTableOrTreeItemWrapper {
        private final TableItem fItem;

        public TableItemWrapper(TableItem item) {
            this.fItem = item;
        }

        @Override
        protected Item getItem() {
            return this.fItem;
        }

        @Override
        public Rectangle getBounds() {
            return this.fItem.getBounds();
        }

        @Override
        public Scrollable getParent() {
            return this.fItem.getParent();
        }

        @Override
        public int getParentColumnCount() {
            return this.fItem.getParent().getColumnCount();
        }

        @Override
        public Rectangle getImageBounds(int index) {
            return this.fItem.getImageBounds(index);
        }

        @Override
        public AbstractTableOrTreeItemWrapper getParentItem() {
            return null;
        }

        @Override
        public int getParentItemHeight() {
            return this.fItem.getParent().getItemHeight();
        }

        @Override
        public Rectangle getTextBounds(int index) {
            return this.fItem.getTextBounds(index);
        }

        @Override
        public String getText(int index) {
            return this.fItem.getText(index);
        }

        @Override
        public Image getImage(int index) {
            return this.fItem.getImage(index);
        }
    }

    private static class TreeItemWrapper
    extends AbstractTableOrTreeItemWrapper {
        private final TreeItem fItem;

        public TreeItemWrapper(TreeItem item) {
            this.fItem = item;
        }

        @Override
        protected Item getItem() {
            return this.fItem;
        }

        @Override
        public Rectangle getBounds() {
            return this.fItem.getBounds();
        }

        @Override
        public Scrollable getParent() {
            return this.fItem.getParent();
        }

        @Override
        public int getParentColumnCount() {
            return this.fItem.getParent().getColumnCount();
        }

        @Override
        public Rectangle getImageBounds(int index) {
            return this.fItem.getImageBounds(index);
        }

        @Override
        public AbstractTableOrTreeItemWrapper getParentItem() {
            return AbstractTableOrTreeItemWrapper.create((Item)this.fItem.getParentItem());
        }

        @Override
        public int getParentItemHeight() {
            return this.fItem.getParent().getItemHeight();
        }

        @Override
        public Rectangle getTextBounds(int index) {
            return this.fItem.getTextBounds(index);
        }

        @Override
        public String getText(int index) {
            return this.fItem.getText(index);
        }

        @Override
        public Image getImage(int index) {
            return this.fItem.getImage(index);
        }
    }
}

