/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.ide.tests.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.internal.utils.URIStorage;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.junit.Assert;

public class ProfileTestUtil {
    public static final String BASE_URI = "platform:/plugin/org.eclipse.emf.compare.uml2.ide.tests/src/org/eclipse/emf/compare/uml2/ide/tests/profile/data/loading/";
    private static final Function<Resource, String> TO_STRING = new Function<Resource, String>(){

        public String apply(Resource input) {
            return input.getURI().toString();
        }
    };

    private ProfileTestUtil() {
    }

    public static void assertLoadedResources(ResourceSet resourceSet, Set<String> expectedLoadedResource) {
        Assert.assertEquals((long)expectedLoadedResource.size(), (long)resourceSet.getResources().size());
        HashSet actualURIs = Sets.newHashSet((Iterable)Collections2.transform((Collection)resourceSet.getResources(), TO_STRING));
        Assert.assertEquals(expectedLoadedResource, (Object)actualURIs);
    }

    public static NotLoadingResourceSet createNotLoadingResourceSet(String ... stringURIs) {
        StorageTraversal storageTraversal = ProfileTestUtil.createStorageTraversal(stringURIs);
        NotLoadingResourceSet newResourceSet = NotLoadingResourceSet.create((StorageTraversal)storageTraversal, (IProgressMonitor)new NullProgressMonitor(), null);
        return newResourceSet;
    }

    public static StorageTraversal createStorageTraversal(String ... stringURIs) {
        Collection storages = Collections2.transform((Collection)Lists.newArrayList((Object[])stringURIs), ProfileTestUtil.toStorage((URIConverter)new ExtensibleURIConverterImpl()));
        StorageTraversal storageTraversal = new StorageTraversal((Set)Sets.newHashSet((Iterable)storages));
        return storageTraversal;
    }

    public static EObject getStereotype(ResourceSet resourceSet, String eObjectURI, String stereotypeName) {
        EObject eObject = resourceSet.getEObject(URI.createURI((String)eObjectURI), false);
        Assert.assertTrue((boolean)(eObject instanceof NamedElement));
        NamedElement elem = (NamedElement)eObject;
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("The stereotype ").append(stereotypeName).append(" is not applied on ").append(elem.getName());
        Stereotype stereotype = elem.getAppliedStereotype(stereotypeName);
        Assert.assertNotNull((String)errorMessage.toString(), (Object)stereotype);
        EObject stereotypeApplication = elem.getStereotypeApplication(stereotype);
        Assert.assertNotNull((Object)stereotypeApplication);
        return stereotypeApplication;
    }

    public static Function<String, IStorage> toStorage(final URIConverter uriConverter) {
        return new Function<String, IStorage>(){

            public IStorage apply(String input) {
                URI uri = URI.createURI((String)input, (boolean)false);
                return new URIStorage(uri, uriConverter.getURIHandler(uri), uriConverter);
            }
        };
    }
}

