/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.merge;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AttributeChangeMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.ReferenceChangeMerger;
import org.eclipse.emf.compare.merge.ResourceAttachmentChangeMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.merge.UMLMerger;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.association.data.AssociationInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExtensionMergeTest
extends AbstractUMLTest {
    private AssociationInputData input = new AssociationInputData();

    @BeforeClass
    public static void setupClass() {
        ExtensionMergeTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        ExtensionMergeTest.resetRegistries();
    }

    @Test
    public void testInstantiationMerger() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Override
    protected void testMergeRightToLeft(Notifier left, Notifier right, Notifier origin) {
        DefaultComparisonScope scope = new DefaultComparisonScope(left, right, origin);
        Comparison comparisonBefore = this.getCompare().compare((IComparisonScope)scope);
        EList differences = comparisonBefore.getDifferences();
        IMerger.Registry registry = IMerger.RegistryImpl.createStandaloneInstance();
        UMLMerger umlMerger = new UMLMerger();
        umlMerger.setRanking(11);
        registry.add((IMerger)umlMerger);
        for (Diff diff : differences) {
            Class expectedMerger = diff instanceof UMLDiff ? UMLMerger.class : (diff instanceof AttributeChange ? AttributeChangeMerger.class : (diff instanceof ReferenceChange ? ReferenceChangeMerger.class : ResourceAttachmentChangeMerger.class));
            IMerger merger = org.eclipse.emf.compare.tests.merge.ExtensionMergeTest.getMerger((IMerger.Registry)registry, (Diff)diff, expectedMerger);
            merger.copyRightToLeft(diff, null);
        }
        Comparison comparisonAfter = this.getCompare().compare((IComparisonScope)scope);
        Assert.assertTrue((String)"Comparison#getDifferences() must be empty after copyAllRightToLeft", (boolean)comparisonAfter.getDifferences().isEmpty());
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

