/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.ui.logical.CompoundModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;

public class ModelMinimizerRegistry
implements IModelMinimizer.Registry {
    private final Map<String, IModelMinimizer> modelMinimizers = new ConcurrentHashMap<String, IModelMinimizer>();

    @Override
    public List<IModelMinimizer> getModelMinimizers() {
        return Lists.newArrayList(this.modelMinimizers.values());
    }

    @Override
    public IModelMinimizer addMinimizer(IModelMinimizer minimizer) {
        return this.modelMinimizers.put(minimizer.getClass().getName(), minimizer);
    }

    @Override
    public IModelMinimizer removeMinimizer(String className) {
        return this.modelMinimizers.remove(className);
    }

    public void minimize(SynchronizationModel syncModel, IProgressMonitor monitor) {
        for (IModelMinimizer modelMinimizer : this.modelMinimizers.values()) {
            modelMinimizer.minimize(syncModel, monitor);
        }
    }

    @Override
    public CompoundModelMinimizer getCompoundMinimizer() {
        return new CompoundModelMinimizer(this.getModelMinimizers());
    }
}

