/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import java.util.function.Predicate;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.AbstractMergeContainedAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeContainedRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MergeContainedAction
extends AbstractMergeContainedAction {
    public MergeContainedAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable, IStructuredSelection selection, Predicate<TreeNode> isFiltered) {
        super(compareConfiguration, mergerRegistry, mode, navigatable);
        this.isFiltered = isFiltered;
        this.setEnabled(this.updateSelection(selection));
    }

    @Override
    protected IMergeRunnable createMergeRunnable(MergeMode mode, boolean isLeftEditable, boolean isRightEditable, IDiffRelationshipComputer relationshipComputer) {
        return new MergeContainedRunnable(isLeftEditable, isRightEditable, mode, relationshipComputer);
    }

    @Override
    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: 
            case ACCEPT: {
                this.setText(EMFCompareIDEUIMessages.getString("merge.all.contained.to.right.text"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merge.all.contained.to.right.text"));
                break;
            }
            case RIGHT_TO_LEFT: 
            case REJECT: {
                this.setText(EMFCompareIDEUIMessages.getString("merge.all.contained.to.left.text"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merge.all.contained.to.left.text"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected Predicate<Diff> getDiffPredicate() {
        return new Predicate<Diff>(){

            @Override
            public boolean test(Diff input) {
                DifferenceSource sourceSide = MergeMode.LEFT_TO_RIGHT.equals((Object)MergeContainedAction.this.getSelectedMode()) || MergeMode.ACCEPT.equals((Object)MergeContainedAction.this.getSelectedMode()) ? DifferenceSource.LEFT : DifferenceSource.RIGHT;
                return EMFComparePredicates.fromSide((DifferenceSource)sourceSide).apply((Object)input);
            }
        };
    }
}

