/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.command;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.impl.TransactionalDualCompareCommandStack;
import org.eclipse.emf.compare.tests.command.AbstractTestCompareCommandStack;
import org.eclipse.emf.compare.tests.command.MockCompareCommand;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.impl.AbstractTransactionalCommandStack;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.TransactionalCommandStackImpl;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestTransactionalDualCompareCommandStack
extends AbstractTestCompareCommandStack {
    @Override
    protected ICompareCommandStack createCommandStack(ResourceSet leftResourceSet, ResourceSet rightResourceSet) {
        ComposedAdapterFactory leftAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        TransactionalCommandStackNoValidation leftCommandStack = new TransactionalCommandStackNoValidation();
        TransactionalEditingDomainImpl leftEditingDomain = new TransactionalEditingDomainImpl((AdapterFactory)leftAdapterFactory, (TransactionalCommandStack)leftCommandStack, leftResourceSet);
        leftResourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)leftEditingDomain));
        ComposedAdapterFactory rightAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        TransactionalCommandStackNoValidation rightCommandStack = new TransactionalCommandStackNoValidation();
        TransactionalEditingDomainImpl rightEditingDomain = new TransactionalEditingDomainImpl((AdapterFactory)rightAdapterFactory, (TransactionalCommandStack)rightCommandStack, rightResourceSet);
        rightResourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)rightEditingDomain));
        return new TransactionalDualCompareCommandStack((AbstractTransactionalCommandStack)leftEditingDomain.getCommandStack(), (AbstractTransactionalCommandStack)rightEditingDomain.getCommandStack());
    }

    @Test
    public void testExecuteSetNameWithException() {
        MockCompareCommand command = new MockCompareCommand(true){

            @Override
            public void execute() {
                TestTransactionalDualCompareCommandStack.this.getRightNode().setName("newValue");
                throw new IllegalStateException();
            }
        };
        this.getCommandStack().execute((Command)command);
        Assert.assertNotEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertNull((Object)this.getRightNode().getName());
        Assert.assertEquals(null, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertFalse((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertFalse((boolean)this.getCommandStack().isRightSaveNeeded());
    }

    @Test
    public void testExecuteSetNameWithException2() {
        MockCompareCommand command = new MockCompareCommand(true){

            @Override
            public void execute() {
                TestTransactionalDualCompareCommandStack.this.getRightNode().setName("newValue");
            }
        };
        MockCompareCommand command2 = new MockCompareCommand(true){

            @Override
            public void execute() {
                TestTransactionalDualCompareCommandStack.this.getRightNode().setName("newValue2");
                throw new IllegalStateException();
            }
        };
        this.getCommandStack().execute((Command)command);
        Assert.assertEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getMostRecentCommand());
        this.getCommandStack().execute((Command)command2);
        Assert.assertEquals((Object)"newValue", (Object)this.getRightNode().getName());
        Assert.assertEquals(null, (Object)this.getCommandStack().getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.getCommandStack().getRedoCommand());
        Assert.assertEquals((Object)command, (Object)this.getCommandStack().getUndoCommand());
        Assert.assertFalse((boolean)this.getCommandStack().canRedo());
        Assert.assertTrue((boolean)this.getCommandStack().canUndo());
        Assert.assertFalse((boolean)this.getCommandStack().isLeftSaveNeeded());
        Assert.assertTrue((boolean)this.getCommandStack().isRightSaveNeeded());
    }

    private final class TransactionalCommandStackNoValidation
    extends TransactionalCommandStackImpl {
        private TransactionalCommandStackNoValidation() {
        }

        public EMFCommandTransaction createTransaction(Command command, Map<?, ?> options) throws InterruptedException {
            HashMap newOptions = options == null ? Maps.newHashMap() : Maps.newHashMap(options);
            newOptions.put("no_validation", Boolean.TRUE);
            return super.createTransaction(command, (Map)newOptions);
        }
    }
}

