/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.merge.AdditiveMergeCriterion;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.ResourceAttachmentChangeMerger;

public class AdditiveResourceAttachmentChangeMerger
extends ResourceAttachmentChangeMerger {
    public AdditiveResourceAttachmentChangeMerger() {
        this.mergeOptions.put("merge.criterion", AdditiveMergeCriterion.INSTANCE);
    }

    @Override
    public boolean apply(IMergeCriterion criterion) {
        return criterion == AdditiveMergeCriterion.INSTANCE;
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (AdditiveResourceAttachmentChangeMerger.isInTerminalState(target)) {
            return;
        }
        if (target.getKind() == DifferenceKind.DELETE) {
            if (target.getSource() == DifferenceSource.LEFT) {
                super.copyRightToLeft(target, monitor);
            } else {
                target.setState(DifferenceState.MERGED);
                for (Diff refiningDiff : target.getRefinedBy()) {
                    refiningDiff.setState(DifferenceState.MERGED);
                }
            }
        } else {
            super.copyRightToLeft(target, monitor);
        }
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        if (diff.getKind() == DifferenceKind.DELETE) {
            if (diff.getSource() == DifferenceSource.LEFT) {
                return super.getDirectMergeDependencies(diff, mergeRightToLeft);
            }
            return super.getDirectMergeDependencies(diff, !mergeRightToLeft);
        }
        return super.getDirectMergeDependencies(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        if (diff.getKind() == DifferenceKind.DELETE) {
            if (diff.getSource() == DifferenceSource.LEFT) {
                return super.getDirectResultingMerges(diff, mergeRightToLeft);
            }
            return super.getDirectResultingMerges(diff, !mergeRightToLeft);
        }
        return super.getDirectResultingMerges(diff, mergeRightToLeft);
    }
}

