/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.customization;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.adapterfactory.context.IContextTester;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;

public class ContentMergeViewerCustomizationDescriptor<T> {
    private final IConfigurationElement configurationElement;
    private final int ranking;
    private final String providerClassName;
    private final String providerAttributeName;
    private final String contextClassName;
    private final String contextAttributeName;
    private boolean logOnce;
    private boolean logOnceContext;
    private T provider;
    private IContextTester contextTester;

    ContentMergeViewerCustomizationDescriptor(IConfigurationElement configurationElement, String providerClass, String providerAttributeName, String contextClass, String contextAttributeName, int ranking) {
        this.configurationElement = (IConfigurationElement)Preconditions.checkNotNull((Object)configurationElement);
        this.providerClassName = (String)Preconditions.checkNotNull((Object)providerClass);
        this.contextClassName = contextClass;
        this.ranking = ranking;
        this.providerAttributeName = providerAttributeName;
        this.contextAttributeName = contextAttributeName;
    }

    public int getRanking() {
        return this.ranking;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    T getProvider() {
        block3: {
            if (this.provider == null) {
                try {
                    this.provider = this.configurationElement.createExecutableExtension(this.providerAttributeName);
                }
                catch (CoreException e) {
                    if (this.logOnce) break block3;
                    this.logOnce = true;
                    String message = EMFCompareRCPUIMessages.getString("ContentCustomizationRegistry.invalidProvider", this.providerClassName);
                    Status status = new Status(4, this.configurationElement.getDeclaringExtension().getContributor().getName(), message, (Throwable)e);
                    EMFCompareRCPUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return this.provider;
    }

    IContextTester getContextTester() {
        block3: {
            if (this.contextClassName != null && this.contextTester == null) {
                try {
                    this.contextTester = (IContextTester)this.configurationElement.createExecutableExtension(this.contextAttributeName);
                }
                catch (CoreException e) {
                    if (this.logOnceContext) break block3;
                    this.logOnceContext = true;
                    String message = EMFCompareRCPUIMessages.getString("ContentCustomizationRegistry.invalidContextTester", this.contextClassName);
                    Status status = new Status(4, this.configurationElement.getDeclaringExtension().getContributor().getName(), message, (Throwable)e);
                    EMFCompareRCPUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return this.contextTester;
    }
}

