/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import java.util.EnumSet;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class AbstractStructuredMergeViewer
extends AbstractMergeViewer {
    private final Control fControl;
    private final ISelectionChangedListener fForwardingSelectionListener;

    public AbstractStructuredMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side, IEMFCompareConfiguration compareConfiguration) {
        super(side, compareConfiguration);
        this.fControl = this.createControl(parent);
        this.hookControl(this.fControl);
        this.fForwardingSelectionListener = new ForwardingViewerSelectionListener();
        this.getStructuredViewer().addSelectionChangedListener(this.fForwardingSelectionListener);
        this.createContextMenu();
    }

    protected abstract Control createControl(Composite var1);

    protected abstract StructuredViewer getStructuredViewer();

    @Override
    public Control getControl() {
        return this.fControl;
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractStructuredMergeViewer.this.fillContextMenu(manager);
            }
        });
        Control control = this.getStructuredViewer().getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Diff diff;
        IEMFCompareConfiguration configuration = this.getCompareConfiguration();
        boolean leftEditable = configuration.isLeftEditable();
        boolean rightEditable = configuration.isRightEditable();
        if ((rightEditable || leftEditable) && (diff = this.getDiff()) != null) {
            EnumSet<MergeMode> modes = rightEditable && leftEditable ? EnumSet.of(MergeMode.RIGHT_TO_LEFT, MergeMode.LEFT_TO_RIGHT) : EnumSet.of(MergeMode.ACCEPT, MergeMode.REJECT);
            for (MergeMode mode : modes) {
                IAction action = this.createAction(mode, diff);
                if (action == null) continue;
                manager.add(action);
            }
        }
    }

    protected Diff getDiff() {
        Object firstElement;
        IStructuredSelection structuredSelection;
        ISelection selection = this.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (firstElement = structuredSelection.getFirstElement()) instanceof IMergeViewerItem) {
            IMergeViewerItem mergeViewerItem = (IMergeViewerItem)firstElement;
            return mergeViewerItem.getDiff();
        }
        return null;
    }

    protected IAction createAction(MergeMode mode, Diff diff) {
        return null;
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        this.getStructuredViewer().removeSelectionChangedListener(this.fForwardingSelectionListener);
        this.hookDispose();
        super.handleDispose(event);
    }

    protected abstract void hookDispose();

    public ISelection getSelection() {
        return this.getStructuredViewer().getSelection();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
        this.getStructuredViewer().setSelection(selection, reveal);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        super.setContentProvider(contentProvider);
        this.getStructuredViewer().setContentProvider(contentProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        this.getStructuredViewer().setLabelProvider(labelProvider);
    }

    private class ForwardingViewerSelectionListener
    implements ISelectionChangedListener {
        private ForwardingViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractStructuredMergeViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AbstractStructuredMergeViewer.this, event.getSelection()));
        }
    }
}

