/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.TechnicalitiesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ThreeWayComparisonGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.ConflictNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.ConflictsGroupWithRefinedDiffTestScenario;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.Test;

public class ConflictsGroupTest
extends AbstractTestTreeNodeItemProviderAdapter {
    private static final CompareFactory FACTORY = CompareFactory.eINSTANCE;
    private ECrossReferenceAdapter crossReferenceAdapter;

    @Override
    public void before() throws IOException {
        super.before();
        this.crossReferenceAdapter = new TestECrossReferenceAdapter();
    }

    @Test
    public void testMergingMultipleConflictsWithOverlappingDiffs() {
        Diff diff1 = FACTORY.createDiff();
        Diff diff1a = FACTORY.createDiff();
        Diff diff1b = FACTORY.createDiff();
        diff1.getRefinedBy().add((Object)diff1a);
        diff1.getRefinedBy().add((Object)diff1b);
        Diff diff2 = FACTORY.createDiff();
        Diff diff3 = FACTORY.createDiff();
        Diff diff3a = FACTORY.createDiff();
        Diff diff3b = FACTORY.createDiff();
        diff3.getRefinedBy().add((Object)diff3a);
        diff3.getRefinedBy().add((Object)diff3b);
        Diff diff4 = FACTORY.createDiff();
        Conflict conflict1 = FACTORY.createConflict();
        conflict1.getDifferences().add((Object)diff1a);
        conflict1.getDifferences().add((Object)diff2);
        Conflict conflict2 = FACTORY.createConflict();
        conflict2.getDifferences().add((Object)diff3a);
        conflict2.getDifferences().add((Object)diff4);
        Conflict conflict3 = FACTORY.createConflict();
        conflict3.getDifferences().add((Object)diff1b);
        conflict3.getDifferences().add((Object)diff3b);
        Comparison comparison = FACTORY.createComparison();
        comparison.getConflicts().add((Object)conflict1);
        comparison.getConflicts().add((Object)conflict2);
        comparison.getConflicts().add((Object)conflict3);
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = this.buildConflictGroup(comparison);
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        ThreeWayComparisonGroupProvider.CompositeConflict compositeConflict = (ThreeWayComparisonGroupProvider.CompositeConflict)conflictNode.basicGetData();
        Assert.assertEquals((long)3L, (long)compositeConflict.getConflicts().size());
        EList differences = compositeConflict.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Assert.assertTrue((boolean)differences.contains((Object)diff1));
        Assert.assertTrue((boolean)differences.contains((Object)diff2));
        Assert.assertTrue((boolean)differences.contains((Object)diff3));
        Assert.assertTrue((boolean)differences.contains((Object)diff4));
    }

    @Test
    public void testDerivationOfConflictGroupKindReal() {
        Conflict realConflict = FACTORY.createConflict();
        realConflict.setKind(ConflictKind.REAL);
        Conflict pseudoConflict = FACTORY.createConflict();
        pseudoConflict.setKind(ConflictKind.PSEUDO);
        ThreeWayComparisonGroupProvider.CompositeConflict realCompositeConflict = new ThreeWayComparisonGroupProvider.CompositeConflict(realConflict);
        Assert.assertEquals((Object)ConflictKind.REAL, (Object)realCompositeConflict.getKind());
        ThreeWayComparisonGroupProvider.CompositeConflict pseudoCompositeConflict = new ThreeWayComparisonGroupProvider.CompositeConflict(pseudoConflict);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)pseudoCompositeConflict.getKind());
        pseudoCompositeConflict.join(realCompositeConflict);
        ThreeWayComparisonGroupProvider.CompositeConflict mergedConflictGroup = pseudoCompositeConflict;
        Assert.assertEquals((long)2L, (long)mergedConflictGroup.getConflicts().size());
        Assert.assertTrue((boolean)mergedConflictGroup.getConflicts().contains(realConflict));
        Assert.assertTrue((boolean)mergedConflictGroup.getConflicts().contains(pseudoConflict));
        Assert.assertEquals((Object)ConflictKind.REAL, (Object)mergedConflictGroup.getKind());
    }

    @Test
    public void testDerivationOfConflictGroupKindPseudo() {
        Conflict pseudoConflict1 = FACTORY.createConflict();
        pseudoConflict1.setKind(ConflictKind.PSEUDO);
        Conflict pseudoConflict2 = FACTORY.createConflict();
        pseudoConflict2.setKind(ConflictKind.PSEUDO);
        ThreeWayComparisonGroupProvider.CompositeConflict pseudoCompositeConflict1 = new ThreeWayComparisonGroupProvider.CompositeConflict(pseudoConflict1);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)pseudoCompositeConflict1.getKind());
        ThreeWayComparisonGroupProvider.CompositeConflict pseudoCompositeConflict2 = new ThreeWayComparisonGroupProvider.CompositeConflict(pseudoConflict2);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)pseudoCompositeConflict2.getKind());
        pseudoCompositeConflict2.join(pseudoCompositeConflict1);
        ThreeWayComparisonGroupProvider.CompositeConflict mergedConflictGroup = pseudoCompositeConflict2;
        Assert.assertEquals((long)2L, (long)mergedConflictGroup.getConflicts().size());
        Assert.assertTrue((boolean)mergedConflictGroup.getConflicts().contains(pseudoConflict1));
        Assert.assertTrue((boolean)mergedConflictGroup.getConflicts().contains(pseudoConflict2));
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)mergedConflictGroup.getKind());
    }

    @Test
    public void testRefinedDiffsWithRealConflictsAreOnlyInConflictGroup() {
        ConflictsGroupWithRefinedDiffTestScenario scenario = new ConflictsGroupWithRefinedDiffTestScenario();
        Conflict conflict = scenario.addConflict(scenario.diff1b, scenario.diff2b, ConflictKind.REAL);
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = this.buildConflictGroup(scenario.comparison);
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        ThreeWayComparisonGroupProvider.CompositeConflict conflictNodeConflict = (ThreeWayComparisonGroupProvider.CompositeConflict)conflictNode.basicGetData();
        Assert.assertEquals((long)1L, (long)conflictNodeConflict.getConflicts().size());
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflict));
        Assert.assertEquals((long)1L, (long)conflictNode.getChildren().size());
        MatchNode matchNode = (MatchNode)conflictNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNode, scenario.diff1, scenario.diff2));
        List<? extends TreeNode> conflictDiffNodesFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNode.getChildren());
        Assert.assertEquals((long)2L, (long)conflictDiffNodesFiltered.size());
        BasicDifferenceGroupImpl leftSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.LEFT);
        Assert.assertEquals((long)0L, (long)leftSide.getChildren().size());
        BasicDifferenceGroupImpl rightSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.RIGHT);
        Assert.assertEquals((long)0L, (long)rightSide.getChildren().size());
    }

    @Test
    public void testRefinedDiffsWithRealAndPseudoConflictsAreOnlyInConflictGroup() {
        ConflictsGroupWithRefinedDiffTestScenario scenario = new ConflictsGroupWithRefinedDiffTestScenario();
        Conflict conflictReal = scenario.addConflict(scenario.diff1b, scenario.diff2b, ConflictKind.REAL);
        Conflict conflictPseudo = scenario.addConflict(scenario.diff1a, scenario.diff2a, ConflictKind.PSEUDO);
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = this.buildConflictGroup(scenario.comparison);
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        ThreeWayComparisonGroupProvider.CompositeConflict conflictNodeConflict = (ThreeWayComparisonGroupProvider.CompositeConflict)conflictNode.basicGetData();
        Assert.assertEquals((long)2L, (long)conflictNodeConflict.getConflicts().size());
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflictReal));
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflictPseudo));
        Assert.assertEquals((long)1L, (long)conflictNode.getChildren().size());
        MatchNode matchNode = (MatchNode)conflictNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNode, scenario.diff1, scenario.diff2));
        List<? extends TreeNode> conflictDiffNodesFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNode.getChildren());
        Assert.assertEquals((long)2L, (long)conflictDiffNodesFiltered.size());
        BasicDifferenceGroupImpl leftSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.LEFT);
        Assert.assertEquals((long)0L, (long)leftSide.getChildren().size());
        BasicDifferenceGroupImpl rightSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.RIGHT);
        Assert.assertEquals((long)0L, (long)rightSide.getChildren().size());
    }

    @Test
    public void testRefinedDiffsWithOnlyPseudoConflictsAreOnlyInConflictGroup() {
        ConflictsGroupWithRefinedDiffTestScenario scenario = new ConflictsGroupWithRefinedDiffTestScenario();
        Conflict conflictPseudo1 = scenario.addConflict(scenario.diff1b, scenario.diff2b, ConflictKind.PSEUDO);
        Conflict conflictPseudo2 = scenario.addConflict(scenario.diff1a, scenario.diff2a, ConflictKind.PSEUDO);
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = this.buildConflictGroup(scenario.comparison);
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        ThreeWayComparisonGroupProvider.CompositeConflict conflictNodeConflict = (ThreeWayComparisonGroupProvider.CompositeConflict)conflictNode.basicGetData();
        Assert.assertEquals((long)2L, (long)conflictNodeConflict.getConflicts().size());
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflictPseudo1));
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflictPseudo2));
        Assert.assertEquals((long)1L, (long)conflictNode.getChildren().size());
        MatchNode matchNode = (MatchNode)conflictNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNode, scenario.diff1, scenario.diff2));
        List<? extends TreeNode> conflictDiffNodesFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNode.getChildren());
        Assert.assertEquals((long)0L, (long)conflictDiffNodesFiltered.size());
        BasicDifferenceGroupImpl leftSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.LEFT);
        Assert.assertEquals((long)0L, (long)leftSide.getChildren().size());
        BasicDifferenceGroupImpl rightSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.RIGHT);
        Assert.assertEquals((long)0L, (long)rightSide.getChildren().size());
    }

    @Test
    public void testRefinedDiffsWithOnlyOnePseudoConflictAreInDiffGroupOnly() {
        ConflictsGroupWithRefinedDiffTestScenario scenario = new ConflictsGroupWithRefinedDiffTestScenario();
        Conflict conflictPseudo = scenario.addConflict(scenario.diff1b, scenario.diff2b, ConflictKind.PSEUDO);
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = this.buildConflictGroup(scenario.comparison);
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        ThreeWayComparisonGroupProvider.CompositeConflict conflictNodeConflict = (ThreeWayComparisonGroupProvider.CompositeConflict)conflictNode.basicGetData();
        Assert.assertEquals((long)1L, (long)conflictNodeConflict.getConflicts().size());
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflictPseudo));
        Assert.assertEquals((long)1L, (long)conflictNode.getChildren().size());
        MatchNode matchNode = (MatchNode)conflictNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNode, scenario.diff1, scenario.diff2));
        List<? extends TreeNode> conflictDiffNodesFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNode.getChildren());
        Assert.assertEquals((long)2L, (long)conflictDiffNodesFiltered.size());
        BasicDifferenceGroupImpl leftSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.LEFT);
        Assert.assertEquals((long)1L, (long)leftSide.getChildren().size());
        MatchNode matchNodeLeft = (MatchNode)leftSide.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNodeLeft, scenario.diff1));
        List<? extends TreeNode> diffNodesLeftFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNodeLeft.getChildren());
        Assert.assertEquals((long)1L, (long)diffNodesLeftFiltered.size());
        List<? extends TreeNode> subDiffNodesLeftFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)diffNodesLeftFiltered.get(0).getChildren());
        Assert.assertEquals((long)1L, (long)subDiffNodesLeftFiltered.size());
        BasicDifferenceGroupImpl rightSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.RIGHT);
        Assert.assertEquals((long)1L, (long)rightSide.getChildren().size());
        MatchNode matchNodeRight = (MatchNode)rightSide.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNodeRight, scenario.diff2));
        List<? extends TreeNode> diffNodesRightFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNodeRight.getChildren());
        Assert.assertEquals((long)1L, (long)diffNodesRightFiltered.size());
        List<? extends TreeNode> subDiffNodesRightFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)diffNodesRightFiltered.get(0).getChildren());
        Assert.assertEquals((long)1L, (long)subDiffNodesRightFiltered.size());
    }

    @Test
    public void testRefinedDiffsInPseudoConflictAndWithRefiningDiffsInRealConflictAreInConflictGroup() {
        ConflictsGroupWithRefinedDiffTestScenario scenario = new ConflictsGroupWithRefinedDiffTestScenario();
        Conflict conflictPseudo = scenario.addConflict(scenario.diff1, scenario.diff2, ConflictKind.PSEUDO);
        Conflict conflictReal = scenario.addConflict(scenario.diff1b, scenario.diff2b, ConflictKind.REAL);
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = this.buildConflictGroup(scenario.comparison);
        List conflictNodes = conflictsGroup.getChildren();
        Assert.assertEquals((long)1L, (long)conflictNodes.size());
        ConflictNode conflictNode = (ConflictNode)conflictNodes.get(0);
        ThreeWayComparisonGroupProvider.CompositeConflict conflictNodeConflict = (ThreeWayComparisonGroupProvider.CompositeConflict)conflictNode.basicGetData();
        Assert.assertEquals((long)2L, (long)conflictNodeConflict.getConflicts().size());
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflictPseudo));
        Assert.assertTrue((boolean)conflictNodeConflict.getConflicts().contains(conflictReal));
        Assert.assertEquals((long)1L, (long)conflictNode.getChildren().size());
        MatchNode matchNode = (MatchNode)conflictNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNode, scenario.diff1, scenario.diff2));
        List<? extends TreeNode> conflictDiffNodesFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNode.getChildren());
        Assert.assertEquals((long)2L, (long)conflictDiffNodesFiltered.size());
        BasicDifferenceGroupImpl leftSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.LEFT);
        Assert.assertEquals((long)0L, (long)leftSide.getChildren().size());
        BasicDifferenceGroupImpl rightSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.RIGHT);
        Assert.assertEquals((long)0L, (long)rightSide.getChildren().size());
    }

    @Test
    public void testRefinedDiffsWithoutConfictsAreInDiffGroup() {
        ConflictsGroupWithRefinedDiffTestScenario scenario = new ConflictsGroupWithRefinedDiffTestScenario();
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = this.buildConflictGroup(scenario.comparison);
        Assert.assertEquals((long)0L, (long)conflictsGroup.getChildren().size());
        BasicDifferenceGroupImpl leftSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.LEFT);
        Assert.assertEquals((long)1L, (long)leftSide.getChildren().size());
        MatchNode matchNodeLeft = (MatchNode)leftSide.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNodeLeft, scenario.diff1));
        List<? extends TreeNode> diffNodesLeftFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNodeLeft.getChildren());
        Assert.assertEquals((long)1L, (long)diffNodesLeftFiltered.size());
        List<? extends TreeNode> subDiffNodesLeftFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)diffNodesLeftFiltered.get(0).getChildren());
        Assert.assertEquals((long)2L, (long)subDiffNodesLeftFiltered.size());
        BasicDifferenceGroupImpl rightSide = this.buildDifferenceGroup(scenario.comparison, DifferenceSource.RIGHT);
        Assert.assertEquals((long)1L, (long)rightSide.getChildren().size());
        MatchNode matchNodeRight = (MatchNode)rightSide.getChildren().get(0);
        Assert.assertTrue((boolean)this.matchNodeContainsDiffNodesForDiffs(matchNodeRight, scenario.diff2));
        List<? extends TreeNode> diffNodesRightFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)matchNodeRight.getChildren());
        Assert.assertEquals((long)1L, (long)diffNodesRightFiltered.size());
        List<? extends TreeNode> subDiffNodesRightFiltered = this.applyTechnicalitiesFilter((List<? extends TreeNode>)diffNodesRightFiltered.get(0).getChildren());
        Assert.assertEquals((long)2L, (long)subDiffNodesRightFiltered.size());
    }

    private ThreeWayComparisonGroupProvider.ConflictsGroupImpl buildConflictGroup(Comparison comparison) {
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl conflictsGroup = new ThreeWayComparisonGroupProvider.ConflictsGroupImpl(comparison, EMFCompareRCPUIMessages.getString((String)"ThreeWayComparisonGroupProvider.conflicts.label"), this.crossReferenceAdapter);
        conflictsGroup.buildSubTree();
        return conflictsGroup;
    }

    private BasicDifferenceGroupImpl buildDifferenceGroup(Comparison comparison, DifferenceSource source) {
        BasicDifferenceGroupImpl differenceGroup = new BasicDifferenceGroupImpl(comparison, Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)source), (Predicate)ThreeWayComparisonGroupProvider.DEFAULT_DIFF_GROUP_FILTER_PREDICATE), "", this.crossReferenceAdapter);
        differenceGroup.buildSubTree();
        return differenceGroup;
    }

    private boolean matchNodeContainsDiffNodesForDiffs(MatchNode matchNode, Diff ... diffs) {
        boolean matchNodeContainsRightAmountOfChildren = matchNode.getChildren().size() == diffs.length;
        boolean matchNodeContainsDiffNodesForDiffs = true;
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            DiffNode diffNode = this.getDiffNode((EList<TreeNode>)matchNode.getChildren(), diff);
            if (!this.isDiffNodeForDiff(diffNode, diff)) {
                matchNodeContainsDiffNodesForDiffs = false;
            }
            ++n2;
        }
        return matchNodeContainsRightAmountOfChildren && matchNodeContainsDiffNodesForDiffs;
    }

    private DiffNode getDiffNode(EList<TreeNode> nodes, Diff diff) {
        for (TreeNode node : nodes) {
            DiffNode diffNode;
            if (!(node instanceof DiffNode) || (diffNode = (DiffNode)node).basicGetData() != diff) continue;
            return diffNode;
        }
        return null;
    }

    private boolean isDiffNodeForDiff(DiffNode diffNode, Diff diff) {
        if (diffNode == null || diff == null) {
            return false;
        }
        boolean diffNodeAssociatedWithDiff = diffNode.basicGetData() == diff;
        boolean diffNodeContainsRightAmountOfChildren = diffNode.getChildren().size() == diff.getRefinedBy().size();
        boolean diffNodeContainsNodesForRefiningDiffs = true;
        for (Diff refiningDiff : diff.getRefinedBy()) {
            DiffNode diffNodeForRefiningDiff = this.getDiffNode((EList<TreeNode>)diffNode.getChildren(), refiningDiff);
            if (diffNodeForRefiningDiff != null) continue;
            diffNodeContainsNodesForRefiningDiffs = false;
        }
        return diffNodeAssociatedWithDiff && diffNodeContainsRightAmountOfChildren && diffNodeContainsNodesForRefiningDiffs;
    }

    private List<? extends TreeNode> applyTechnicalitiesFilter(List<? extends TreeNode> actualTrees) {
        final StructureMergeViewerFilter filter = new StructureMergeViewerFilter(new EventBus());
        TechnicalitiesFilter technicalitiesFilter = new TechnicalitiesFilter();
        filter.addFilter((IDifferenceFilter)technicalitiesFilter);
        Predicate<EObject> viewerFilterPredicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                AdapterImpl adapter = new AdapterImpl();
                adapter.setTarget((Notifier)input);
                return filter.select(null, null, (Object)adapter);
            }
        };
        ArrayList filteredTrees = Lists.newArrayList((Iterable)Collections2.filter(actualTrees, (Predicate)viewerFilterPredicate));
        return filteredTrees;
    }

    private class TestECrossReferenceAdapter
    extends ECrossReferenceAdapter {
        private TestECrossReferenceAdapter() {
        }

        protected boolean isIncluded(EReference eReference) {
            return eReference == TreePackage.Literals.TREE_NODE__DATA;
        }
    }
}

