/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeRunnableImpl;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.internal.merge.MergeDataImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.spec.ReferenceChangeSpec;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.compare.tests.nodes.NodeOppositeRefOneToOne;
import org.eclipse.emf.compare.tests.nodes.NodesPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBug434827 {
    private Comparison comparison;
    private IMerger.Registry mergerRegistry;
    private Diff deletionDiff;
    private Diff subDiff;
    private Diff oppositeDiff;
    private Resource left;

    @Before
    public void setUp() throws IOException {
        Bug434827InputData inputData = new Bug434827InputData();
        this.left = inputData.getResource("left.nodes");
        Resource right = inputData.getResource("right.nodes");
        Resource origin = inputData.getResource("origin.nodes");
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)right, (Notifier)origin);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.comparison.eAdapters().add((Object)new MergeDataImpl(true, false));
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        for (Diff diff : this.comparison.getDifferences()) {
            if (!(diff instanceof ReferenceChangeSpec)) continue;
            EReference eReference = ((ReferenceChangeSpec)diff).getReference();
            if (NodesPackage.Literals.NODE_OPPOSITE_REF_ONE_TO_ONE__SOURCE.equals(eReference)) {
                this.subDiff = diff;
                continue;
            }
            if (NodesPackage.Literals.NODE__CONTAINMENT_REF1.equals(eReference)) {
                this.deletionDiff = diff;
                continue;
            }
            if (!NodesPackage.Literals.NODE_OPPOSITE_REF_ONE_TO_ONE__DESTINATION.equals(eReference)) continue;
            this.oppositeDiff = diff;
        }
    }

    @Test
    public void testMergeDataAfterAcceptingDeletion() {
        Assert.assertNotNull((Object)this.subDiff);
        Assert.assertNotNull((Object)this.deletionDiff);
        Assert.assertNotNull((Object)this.oppositeDiff);
        ArrayList uiDiff = Lists.newArrayList((Object[])new Diff[]{this.deletionDiff});
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.ACCEPT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge((List)uiDiff, false, this.mergerRegistry);
        Node rootNode = (Node)this.left.getContents().get(0);
        Assert.assertEquals((long)0L, (long)((Node)rootNode.getContainmentRef1().get(0)).getContainmentRef1().size());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)this.deletionDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.subDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.oppositeDiff.getState());
        Assert.assertEquals((Object)MergeMode.ACCEPT, (Object)MergeMode.getMergeMode((Diff)this.deletionDiff, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.subDiff, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.oppositeDiff, (boolean)true, (boolean)false));
    }

    @Test
    public void testMergeDataAfterRejectingDeletion() {
        Assert.assertNotNull((Object)this.subDiff);
        Assert.assertNotNull((Object)this.deletionDiff);
        Assert.assertNotNull((Object)this.oppositeDiff);
        ArrayList uiDiff = Lists.newArrayList((Object[])new Diff[]{this.deletionDiff});
        MergeRunnableImpl mergeRunnable = new MergeRunnableImpl(true, false, MergeMode.REJECT, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        mergeRunnable.merge((List)uiDiff, false, this.mergerRegistry);
        Node rootNode = (Node)this.left.getContents().get(0);
        Assert.assertEquals((long)1L, (long)((Node)rootNode.getContainmentRef1().get(0)).getContainmentRef1().size());
        NodeOppositeRefOneToOne holdingRefNode = (NodeOppositeRefOneToOne)rootNode.getContainmentRef1().get(1);
        NodeOppositeRefOneToOne referencedNode = (NodeOppositeRefOneToOne)((Node)rootNode.getContainmentRef1().get(0)).getContainmentRef1().get(0);
        Assert.assertEquals((Object)holdingRefNode, (Object)referencedNode.getSource());
        Assert.assertEquals((Object)referencedNode, (Object)holdingRefNode.getDestination());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)this.deletionDiff.getState());
        Assert.assertEquals((Object)MergeMode.REJECT, (Object)MergeMode.getMergeMode((Diff)this.deletionDiff, (boolean)true, (boolean)false));
        Assert.assertNull((Object)this.getMergeData(this.subDiff));
        Assert.assertNull((Object)this.getMergeData(this.oppositeDiff));
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)this.subDiff.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)this.oppositeDiff.getState());
    }

    private IMergeData getMergeData(Diff diff) {
        return (IMergeData)EcoreUtil.getExistingAdapter((Notifier)diff, IMergeData.class);
    }

    public class Bug434827InputData
    extends AbstractInputData {
        private static final String PATH_PREFIX = "data/_434827/";

        public Resource getResource(String resourceName) throws IOException {
            StringBuilder resourceURL = new StringBuilder(PATH_PREFIX);
            resourceURL.append(resourceName);
            return this.loadFromClassLoader(resourceURL.toString());
        }
    }
}

