/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.opaque;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.opaque.data.OpaqueInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OpaqueElementBodyChangeMergeTest
extends AbstractUMLTest {
    private static final String NL = "\r\n";
    private static final String OPAQUE_ACTION1_ID = "_opaqueAction1";
    private static final String OPAQUE_BEHAVIOR1_ID = "_opaqueBehavior1";
    private static final String OPAQUE_EXPRESSION1_ID = "_opaqueExpression1";
    private static final String OCL = "OCL";
    private static final String JAVA = "JAVA";
    private static final String EXPECTED_MERGE = "This is a\r\ntest with multi-line (changed)\r\nString attribute\r\nand concurrent changes (changed)\r\nof them.";
    private static final String EXPECTED_MERGE_JAVA = "This is a JAVA\r\ntest with multi-line\r\nString attribute\r\nand concurrent changes (changed)\r\nof them.";
    private static final String EXPECTED_MERGE_OCL = "This is an OCL\r\ntest with multi-line (changed)\r\nString attribute\r\nand concurrent changes (changed)\r\nof them.";
    private static final String EXPECTED_JAVA = "This is a JAVA\r\ntest with multi-line\r\nString attribute\r\nand concurrent changes\r\nof them.";
    private static final String EXPECTED_OCL = "This is an OCL\r\ntest with multi-line\r\nString attribute\r\nand concurrent changes\r\nof them.";
    private static final String EXPECTED_C = "This is a C\r\ntest with multi-line\r\nString attribute\r\nand concurrent changes\r\nof them.";
    private static final String A2_ORIGIN = "This is a\r\ntest with multi-line\r\nString attribute\r\nand concurrent changes\r\nof them.";
    private static final String A2_LEFT = "This is a\r\ntest with multi-line (changed)\r\nString attribute\r\nand concurrent changes\r\nof them.";
    private static final String A2_RIGHT = "This is a\r\n(changed)test with multi-line\r\nString attribute\r\nand concurrent changes\r\nof them.";
    private static final Predicate<Diff> IS_OPAQUE_ELEMENT_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return diff instanceof OpaqueElementBodyChange;
        }
    };
    private static final Predicate<Conflict> IS_REAL_CONFLICT = new Predicate<Conflict>(){

        public boolean apply(Conflict conflict) {
            return ConflictKind.REAL.equals((Object)conflict.getKind());
        }
    };
    private static final Predicate<Conflict> CONCERNS_OPAQUE_ELEMENT_BODY_CHANGE = new Predicate<Conflict>(){

        public boolean apply(Conflict conflict) {
            return Iterables.any((Iterable)conflict.getDifferences(), (Predicate)IS_OPAQUE_ELEMENT_CHANGE);
        }
    };
    private OpaqueInputData input = new OpaqueInputData();

    @BeforeClass
    public static void setupClass() {
        OpaqueElementBodyChangeMergeTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        OpaqueElementBodyChangeMergeTest.resetRegistries();
    }

    @Test
    public void testA1UseCaseRtoL() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertA1UseCaseMergeResult(left.getEObject(OPAQUE_ACTION1_ID));
    }

    @Test
    public void testA1UseCaseLtoR() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertA1UseCaseMergeResult(right.getEObject(OPAQUE_ACTION1_ID));
    }

    private void assertA1UseCaseMergeResult(EObject eObject) {
        Assert.assertTrue((boolean)(eObject instanceof OpaqueAction));
        OpaqueAction action = (OpaqueAction)eObject;
        Assert.assertEquals((long)1L, (long)action.getLanguages().size());
        Assert.assertEquals((long)1L, (long)action.getBodies().size());
        Assert.assertEquals((Object)JAVA, (Object)action.getLanguages().get(0));
        Assert.assertEquals((Object)EXPECTED_MERGE, (Object)action.getBodies().get(0));
    }

    @Test
    public void testA1UseCase_RevertChangeLeftTwoWay() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        OpaqueAction originAction = (OpaqueAction)origin.getEObject(OPAQUE_ACTION1_ID);
        String originBody = (String)originAction.getBodies().get(0);
        Comparison comparison = this.compare((Notifier)left, (Notifier)origin, null);
        this.revertLeftOpaqueElementBodyChanges(comparison);
        this.assertOneBodyWithContents(left, originBody);
    }

    @Test
    public void testA1UseCase_RevertChangeRightThreeWay() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        OpaqueAction originAction = (OpaqueAction)origin.getEObject(OPAQUE_ACTION1_ID);
        String originBody = (String)originAction.getBodies().get(0);
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.revertRightOpaqueElementBodyChanges(comparison);
        this.assertOneBodyWithContents(right, originBody);
    }

    @Test
    public void testA1UseCase_ApplyLeftRevertRightChangeThreeWay() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        OpaqueAction leftAction = (OpaqueAction)left.getEObject(OPAQUE_ACTION1_ID);
        String leftBody = (String)leftAction.getBodies().get(0);
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.revertRightOpaqueElementBodyChanges(comparison);
        this.assertOneBodyWithContents(right, leftBody);
    }

    @Test
    public void testA1UseCase_ApplyRightRevertLeftChangeThreeWay() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        OpaqueAction rightAction = (OpaqueAction)right.getEObject(OPAQUE_ACTION1_ID);
        String rightBody = (String)rightAction.getBodies().get(0);
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.revertLeftOpaqueElementBodyChanges(comparison);
        this.assertOneBodyWithContents(left, rightBody);
    }

    @Test
    public void testA2UseCase() throws IOException {
        Resource origin = this.input.getA2Origin();
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
    }

    @Test
    public void testA2UseCaseLtoR() throws IOException {
        Resource origin = this.input.getA2Origin();
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
        this.assertA2UseCaseBody(origin.getEObject(OPAQUE_ACTION1_ID), A2_ORIGIN);
        this.assertA2UseCaseBody(left.getEObject(OPAQUE_ACTION1_ID), A2_LEFT);
        this.assertA2UseCaseBody(right.getEObject(OPAQUE_ACTION1_ID), A2_RIGHT);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertA2UseCaseBody(origin.getEObject(OPAQUE_ACTION1_ID), A2_ORIGIN);
        this.assertA2UseCaseBody(left.getEObject(OPAQUE_ACTION1_ID), A2_LEFT);
        this.assertA2UseCaseBody(right.getEObject(OPAQUE_ACTION1_ID), A2_LEFT);
    }

    @Test
    public void testA2UseCaseRtoL() throws IOException {
        Resource origin = this.input.getA2Origin();
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
        this.assertA2UseCaseBody(origin.getEObject(OPAQUE_ACTION1_ID), A2_ORIGIN);
        this.assertA2UseCaseBody(left.getEObject(OPAQUE_ACTION1_ID), A2_LEFT);
        this.assertA2UseCaseBody(right.getEObject(OPAQUE_ACTION1_ID), A2_RIGHT);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertA2UseCaseBody(origin.getEObject(OPAQUE_ACTION1_ID), A2_ORIGIN);
        this.assertA2UseCaseBody(left.getEObject(OPAQUE_ACTION1_ID), A2_RIGHT);
        this.assertA2UseCaseBody(right.getEObject(OPAQUE_ACTION1_ID), A2_RIGHT);
    }

    private void assertA2UseCaseBody(EObject eObject, String expectedBody) {
        Assert.assertTrue((boolean)(eObject instanceof OpaqueAction));
        OpaqueAction opaqueAction = (OpaqueAction)eObject;
        Assert.assertEquals((long)1L, (long)opaqueAction.getBodies().size());
        Assert.assertEquals((long)1L, (long)opaqueAction.getLanguages().size());
        Assert.assertEquals((Object)JAVA, (Object)opaqueAction.getLanguages().get(0));
        Assert.assertEquals((Object)expectedBody, (Object)opaqueAction.getBodies().get(0));
    }

    @Test
    public void testA3UseCase() throws IOException {
        Resource origin = this.input.getA3Origin();
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
    }

    @Test
    public void testA4UseCaseLtoR() throws IOException {
        Resource origin = this.input.getA4Origin();
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertA4UseCaseMergeResult(right.getEObject(OPAQUE_ACTION1_ID));
    }

    @Test
    public void testA4UseCaseRtoL() throws IOException {
        Resource origin = this.input.getA4Origin();
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertA4UseCaseMergeResult(left.getEObject(OPAQUE_ACTION1_ID));
    }

    private void assertA4UseCaseMergeResult(EObject eObject) {
        Assert.assertTrue((boolean)(eObject instanceof OpaqueAction));
        OpaqueAction action = (OpaqueAction)eObject;
        Assert.assertEquals((long)2L, (long)action.getLanguages().size());
        Assert.assertEquals((long)2L, (long)action.getBodies().size());
        Assert.assertEquals((Object)JAVA, (Object)action.getLanguages().get(0));
        Assert.assertEquals((Object)OCL, (Object)action.getLanguages().get(1));
        Assert.assertEquals((Object)EXPECTED_MERGE_JAVA, (Object)action.getBodies().get(0));
        Assert.assertEquals((Object)EXPECTED_OCL, (Object)action.getBodies().get(1));
    }

    @Test
    public void testA4UseCase_RevertAdditionLeftTwoWay() throws IOException {
        Resource origin = this.input.getA4Origin();
        Resource left = this.input.getA4Left();
        OpaqueAction originAction = (OpaqueAction)origin.getEObject(OPAQUE_ACTION1_ID);
        String originBody = (String)originAction.getBodies().get(0);
        Comparison comparison = this.compare((Notifier)left, (Notifier)origin, null);
        this.revertLeftOpaqueElementBodyChanges(comparison);
        this.assertOneBodyWithContents(left, originBody);
    }

    @Test
    public void testA4UseCase_RevertDeletionLeftTwoWay() throws IOException {
        Resource left = this.input.getA4Left();
        Resource origin = this.input.getA4Origin();
        Comparison comparison = this.compare((Notifier)origin, (Notifier)left, null);
        this.revertLeftOpaqueElementBodyChanges(comparison);
        EObject eObject = origin.getEObject(OPAQUE_ACTION1_ID);
        OpaqueAction action = (OpaqueAction)eObject;
        Assert.assertEquals((long)2L, (long)action.getLanguages().size());
        Assert.assertEquals((long)2L, (long)action.getBodies().size());
    }

    @Test
    public void testA5UseCaseLtoR() throws IOException {
        Resource origin = this.input.getA5Origin();
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertA5UseCaseMergeResult(right.getEObject(OPAQUE_ACTION1_ID));
    }

    @Test
    public void testA5UseCaseRtoL() throws IOException {
        Resource origin = this.input.getA5Origin();
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertA5UseCaseMergeResult(left.getEObject(OPAQUE_ACTION1_ID));
    }

    private void assertA5UseCaseMergeResult(EObject eObject) {
        Assert.assertTrue((boolean)(eObject instanceof OpaqueAction));
        OpaqueAction action = (OpaqueAction)eObject;
        Assert.assertEquals((long)3L, (long)action.getLanguages().size());
        Assert.assertEquals((long)3L, (long)action.getBodies().size());
        Assert.assertTrue((boolean)action.getLanguages().contains((Object)JAVA));
        Assert.assertTrue((boolean)action.getLanguages().contains((Object)OCL));
        Assert.assertTrue((boolean)action.getLanguages().contains((Object)"C"));
        int indexJava = action.getLanguages().indexOf((Object)JAVA);
        int indexOcl = action.getLanguages().indexOf((Object)OCL);
        int indexC = action.getLanguages().indexOf((Object)"C");
        Assert.assertEquals((Object)EXPECTED_JAVA, (Object)action.getBodies().get(indexJava));
        Assert.assertEquals((Object)EXPECTED_OCL, (Object)action.getBodies().get(indexOcl));
        Assert.assertEquals((Object)EXPECTED_C, (Object)action.getBodies().get(indexC));
    }

    @Test
    public void testA6UseCaseLtoR() throws IOException {
        Resource origin = this.input.getA6Origin();
        Resource left = this.input.getA6Left();
        Resource right = this.input.getA6Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertA6UseCaseMergeResult(right.getEObject(OPAQUE_ACTION1_ID));
    }

    @Test
    public void testA6UseCaseRtoL() throws IOException {
        Resource origin = this.input.getA6Origin();
        Resource left = this.input.getA6Left();
        Resource right = this.input.getA6Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertA6UseCaseMergeResult(left.getEObject(OPAQUE_ACTION1_ID));
    }

    private void assertA6UseCaseMergeResult(EObject eObject) {
        Assert.assertTrue((boolean)(eObject instanceof OpaqueAction));
        OpaqueAction action = (OpaqueAction)eObject;
        Assert.assertEquals((long)2L, (long)action.getLanguages().size());
        Assert.assertEquals((long)2L, (long)action.getBodies().size());
        Assert.assertTrue((boolean)action.getLanguages().contains((Object)JAVA));
        Assert.assertTrue((boolean)action.getLanguages().contains((Object)OCL));
        int indexJava = action.getLanguages().indexOf((Object)JAVA);
        int indexOcl = action.getLanguages().indexOf((Object)OCL);
        Assert.assertEquals((Object)EXPECTED_JAVA, (Object)action.getBodies().get(indexJava));
        Assert.assertEquals((Object)EXPECTED_MERGE_OCL, (Object)action.getBodies().get(indexOcl));
        Assert.assertEquals((long)indexOcl, (long)0L);
        Assert.assertEquals((long)indexJava, (long)1L);
    }

    @Test
    public void testA6UseCase_RevertReorderRightTwoWay() throws IOException {
        Resource origin = this.input.getA6Origin();
        Resource left = this.input.getA6Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)origin, null);
        this.revertLeftOpaqueElementBodyChanges(comparison);
        OpaqueAction action = (OpaqueAction)left.getEObject(OPAQUE_ACTION1_ID);
        Assert.assertEquals((long)2L, (long)action.getLanguages().size());
        Assert.assertEquals((long)2L, (long)action.getBodies().size());
        int indexJava = action.getLanguages().indexOf((Object)JAVA);
        int indexOcl = action.getLanguages().indexOf((Object)OCL);
        Assert.assertEquals((long)indexJava, (long)0L);
        Assert.assertEquals((long)indexOcl, (long)1L);
        Assert.assertEquals((Object)EXPECTED_JAVA, (Object)action.getBodies().get(indexJava));
        Assert.assertEquals((Object)EXPECTED_OCL, (Object)action.getBodies().get(indexOcl));
    }

    @Test
    public void testA7UseCase() throws IOException {
        Resource origin = this.input.getA7Origin();
        Resource left = this.input.getA7Left();
        Resource right = this.input.getA7Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
    }

    @Test
    public void testA8UseCase() throws IOException {
        Resource origin = this.input.getA8Origin();
        Resource left = this.input.getA8Left();
        Resource right = this.input.getA8Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
    }

    @Test
    public void testA9UseCaseLtoR() throws IOException {
        Resource origin = this.input.getA9Origin();
        Resource left = this.input.getA9Left();
        Resource right = this.input.getA9Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertA9UseCaseMergeResult(right);
    }

    @Test
    public void testA9UseCaseRtoL() throws IOException {
        Resource origin = this.input.getA9Origin();
        Resource left = this.input.getA9Left();
        Resource right = this.input.getA9Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertA9UseCaseMergeResult(left);
    }

    private void assertA9UseCaseMergeResult(Resource resource) {
        EObject eObject = resource.getEObject(OPAQUE_ACTION1_ID);
        Assert.assertTrue((boolean)(eObject instanceof OpaqueAction));
        OpaqueAction opaqueAction = (OpaqueAction)eObject;
        Assert.assertEquals((long)0L, (long)opaqueAction.getBodies().size());
        Assert.assertEquals((long)0L, (long)opaqueAction.getLanguages().size());
    }

    @Test
    public void testA10UseCaseRtoL() throws IOException {
        Resource origin = this.input.getA10Origin();
        Resource left = this.input.getA10Left();
        Resource right = this.input.getA10Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertOneBodyWithContents(left, EXPECTED_MERGE_OCL);
    }

    @Test
    public void testA10UseCaseLtoR() throws IOException {
        Resource origin = this.input.getA10Origin();
        Resource left = this.input.getA10Left();
        Resource right = this.input.getA10Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertOneBodyWithContents(right, EXPECTED_MERGE_OCL);
    }

    @Test
    public void testA10UseCaseRtoL_RevertLeftDeletion() throws IOException {
        Resource origin = this.input.getA10Origin();
        Resource left = this.input.getA10Left();
        Resource right = this.input.getA10Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.revertLeftOpaqueElementBodyChanges(comparison);
        EObject leftEObject = left.getEObject(OPAQUE_ACTION1_ID);
        OpaqueAction leftOpaqueAction = (OpaqueAction)leftEObject;
        String leftLanguageAt0 = (String)leftOpaqueAction.getLanguages().get(0);
        String leftBodyAt0 = (String)leftOpaqueAction.getBodies().get(0);
        Assert.assertEquals((Object)JAVA, (Object)leftLanguageAt0);
        Assert.assertEquals((Object)EXPECTED_JAVA, (Object)leftBodyAt0);
        String leftLanguageAt1 = (String)leftOpaqueAction.getLanguages().get(1);
        String leftBodyAt1 = (String)leftOpaqueAction.getBodies().get(1);
        Assert.assertEquals((Object)OCL, (Object)leftLanguageAt1);
        Assert.assertEquals((Object)EXPECTED_OCL, (Object)leftBodyAt1);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource origin = this.input.getA11Origin();
        Resource left = this.input.getA11Left();
        Resource right = this.input.getA11Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
    }

    @Test
    public void testA12UseCase() throws IOException {
        Resource origin = this.input.getA12Origin();
        Resource left = this.input.getA12Left();
        Resource right = this.input.getA12Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertOneRealConflictOnOpaqueElementBodyChange(comparison);
    }

    @Test
    public void testA13UseCase() throws IOException {
        Resource origin = this.input.getA13Origin();
        Resource left = this.input.getA13Left();
        Resource right = this.input.getA13Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        EObject leftEObject = left.getEObject(OPAQUE_ACTION1_ID);
        OpaqueAction leftOpaqueAction = (OpaqueAction)leftEObject;
        String bodyLeft = (String)leftOpaqueAction.getBodies().get(0);
        this.assertOneBodyWithContents(right, bodyLeft);
    }

    @Test
    public void testB1UseCaseRtoL() throws IOException {
        Resource origin = this.input.getB1Origin();
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertB1UseCaseMergeResult(left.getEObject(OPAQUE_BEHAVIOR1_ID));
    }

    @Test
    public void testB1UseCaseLtoR() throws IOException {
        Resource origin = this.input.getB1Origin();
        Resource left = this.input.getB1Left();
        Resource right = this.input.getB1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertB1UseCaseMergeResult(right.getEObject(OPAQUE_BEHAVIOR1_ID));
    }

    private void assertB1UseCaseMergeResult(EObject eObject) {
        Assert.assertTrue((boolean)(eObject instanceof OpaqueBehavior));
        OpaqueBehavior action = (OpaqueBehavior)eObject;
        Assert.assertEquals((long)1L, (long)action.getLanguages().size());
        Assert.assertEquals((long)1L, (long)action.getBodies().size());
        Assert.assertEquals((Object)JAVA, (Object)action.getLanguages().get(0));
        Assert.assertEquals((Object)EXPECTED_MERGE, (Object)action.getBodies().get(0));
    }

    @Test
    public void testE1UseCaseRtoL() throws IOException {
        Resource origin = this.input.getE1Origin();
        Resource left = this.input.getE1Left();
        Resource right = this.input.getE1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyRightOpaqueElementBodyChangesToLeft(comparison);
        this.assertE1UseCaseMergeResult(left.getEObject(OPAQUE_EXPRESSION1_ID));
    }

    @Test
    public void testE1UseCaseLtoR() throws IOException {
        Resource origin = this.input.getE1Origin();
        Resource left = this.input.getE1Left();
        Resource right = this.input.getE1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        this.assertNoRealConflict(comparison);
        this.applyLeftOpaqueElementBodyChangesToRight(comparison);
        this.assertE1UseCaseMergeResult(right.getEObject(OPAQUE_EXPRESSION1_ID));
    }

    private void assertE1UseCaseMergeResult(EObject eObject) {
        Assert.assertTrue((boolean)(eObject instanceof OpaqueExpression));
        OpaqueExpression action = (OpaqueExpression)eObject;
        Assert.assertEquals((long)1L, (long)action.getLanguages().size());
        Assert.assertEquals((long)1L, (long)action.getBodies().size());
        Assert.assertEquals((Object)JAVA, (Object)action.getLanguages().get(0));
        Assert.assertEquals((Object)EXPECTED_MERGE, (Object)action.getBodies().get(0));
    }

    private void assertOneBodyWithContents(Resource resource, String contents) {
        EObject eObject = resource.getEObject(OPAQUE_ACTION1_ID);
        Assert.assertTrue((boolean)(eObject instanceof OpaqueAction));
        OpaqueAction opaqueAction = (OpaqueAction)eObject;
        Assert.assertEquals((long)1L, (long)opaqueAction.getBodies().size());
        Assert.assertEquals((long)1L, (long)opaqueAction.getLanguages().size());
        String body = (String)opaqueAction.getBodies().get(0);
        Assert.assertEquals((Object)contents, (Object)body);
    }

    private void applyRightOpaqueElementBodyChangesToLeft(Comparison comparison) {
        EList allDifferences = comparison.getDifferences();
        Iterable rightOpaqueElementBodyChanges = Iterables.filter((Iterable)allDifferences, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        BatchMerger merger = new BatchMerger(this.getMergerRegistry());
        merger.copyAllRightToLeft(rightOpaqueElementBodyChanges, (Monitor)new BasicMonitor());
    }

    private void revertLeftOpaqueElementBodyChanges(Comparison comparison) {
        EList allDifferences = comparison.getDifferences();
        Iterable leftOpaqueElementBodyChanges = Iterables.filter((Iterable)allDifferences, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        BatchMerger merger = new BatchMerger(this.getMergerRegistry());
        merger.copyAllRightToLeft(leftOpaqueElementBodyChanges, (Monitor)new BasicMonitor());
    }

    private void revertRightOpaqueElementBodyChanges(Comparison comparison) {
        EList allDifferences = comparison.getDifferences();
        Iterable rightOpaqueElementBodyChanges = Iterables.filter((Iterable)allDifferences, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        BatchMerger merger = new BatchMerger(this.getMergerRegistry());
        merger.copyAllLeftToRight(rightOpaqueElementBodyChanges, (Monitor)new BasicMonitor());
    }

    private void applyLeftOpaqueElementBodyChangesToRight(Comparison comparison) {
        EList allDifferences = comparison.getDifferences();
        Iterable leftOpaqueElementBodyChanges = Iterables.filter((Iterable)allDifferences, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        BatchMerger merger = new BatchMerger(this.getMergerRegistry());
        merger.copyAllLeftToRight(leftOpaqueElementBodyChanges, (Monitor)new BasicMonitor());
    }

    private void assertNoRealConflict(Comparison comparison) {
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getConflicts(), IS_REAL_CONFLICT)));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getConflicts(), CONCERNS_OPAQUE_ELEMENT_BODY_CHANGE)));
    }

    private void assertOneRealConflictOnOpaqueElementBodyChange(Comparison comparison) {
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getConflicts(), IS_REAL_CONFLICT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getConflicts(), (Predicate)Predicates.and(IS_REAL_CONFLICT, CONCERNS_OPAQUE_ELEMENT_BODY_CHANGE))));
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

