/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.extension.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;

public final class ItemUtil {
    public static final String PREFERENCE_DELIMITER = ";";

    private ItemUtil() {
    }

    public static <T> T getItem(IItemRegistry<T> registry, String preferenceKey) {
        IItemDescriptor<T> desc = ItemUtil.getDefaultItemDescriptor(registry, preferenceKey);
        if (desc != null) {
            return desc.getItem();
        }
        return null;
    }

    public static <T> IItemDescriptor<T> getDefaultItemDescriptor(IItemRegistry<T> registry, String preferenceKey) {
        IItemDescriptor<T> descriptor;
        IItemDescriptor<T> result = ItemUtil.getItemDescriptorFromPref(registry, preferenceKey);
        if (result == null && (descriptor = registry.getHighestRankingDescriptor()) != null) {
            result = descriptor;
        }
        return result;
    }

    private static <T> IItemDescriptor<T> getItemDescriptorFromPref(IItemRegistry<T> registry, String preferenceKey) {
        IItemDescriptor<T> descriptor;
        String itemKey = Platform.getPreferencesService().getString("org.eclipse.emf.compare.rcp", preferenceKey, null, null);
        IItemDescriptor<T> result = null;
        if (itemKey != null && (descriptor = registry.getItemDescriptor(itemKey)) != null) {
            result = descriptor;
        }
        return result;
    }

    public static <T> List<IItemDescriptor<T>> getItemsDescriptor(IItemRegistry<T> registry, String qualifier, String preferenceKey) {
        String diffEngineKey = Platform.getPreferencesService().getString(qualifier, preferenceKey, null, null);
        ArrayList<IItemDescriptor<T>> result = null;
        if (diffEngineKey != null) {
            String[] diffEngineKeys;
            String[] stringArray = diffEngineKeys = diffEngineKey.split(PREFERENCE_DELIMITER);
            int n = diffEngineKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String nonTrimedKey = stringArray[n2];
                String key = nonTrimedKey.trim();
                IItemDescriptor<T> descriptor = registry.getItemDescriptor(key);
                if (descriptor != null) {
                    if (result == null) {
                        result = new ArrayList<IItemDescriptor<T>>();
                    }
                    result.add(descriptor);
                }
                ++n2;
            }
        }
        return result;
    }

    public static <T> Set<IItemDescriptor<T>> getActiveItems(IItemRegistry<T> registry, String qualifier, String disabledItemPreferenceKey) {
        List<IItemDescriptor<T>> itemsDescriptor = ItemUtil.getItemsDescriptor(registry, qualifier, disabledItemPreferenceKey);
        if (itemsDescriptor == null) {
            return Sets.newLinkedHashSet(registry.getItemDescriptors());
        }
        HashSet disableFactories = Sets.newHashSet(itemsDescriptor);
        HashSet allFactories = Sets.newHashSet(registry.getItemDescriptors());
        Sets.SetView activeFactory = Sets.difference((Set)allFactories, (Set)disableFactories);
        return activeFactory;
    }
}

