/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.junit.Assert;
import org.junit.Test;

public class DiffUtilTest {
    @Test
    public void lcsTest1() {
        ImmutableList left = Lists.charactersOf((String)"abcde");
        ImmutableList right = Lists.charactersOf((String)"czdab");
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        List lcs = DiffUtil.longestCommonSubsequence((Comparison)emptyComparison, (List)left, (List)right);
        DiffUtilTest.assertEqualContents(Lists.charactersOf((String)"cd"), lcs);
    }

    @Test
    public void lcsTest2() {
        ImmutableList left = Lists.charactersOf((String)"abcde");
        ImmutableList right = Lists.charactersOf((String)"ycdeb");
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        List lcs = DiffUtil.longestCommonSubsequence((Comparison)emptyComparison, (List)left, (List)right);
        DiffUtilTest.assertEqualContents(Lists.charactersOf((String)"cde"), lcs);
    }

    @Test
    public void lcsTest3() {
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{8, 9, 2, 3, 4, 1, 0});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        List lcs = DiffUtil.longestCommonSubsequence((Comparison)emptyComparison, (List)left, (List)right);
        DiffUtilTest.assertEqualContents(Lists.newArrayList((Object[])new Integer[]{2, 3, 4}), lcs);
    }

    @Test
    public void lcsTest4() {
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{6, 2, 9, 3, 0, 4, 1, 7});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        List lcs = DiffUtil.longestCommonSubsequence((Comparison)emptyComparison, (List)left, (List)right);
        DiffUtilTest.assertEqualContents(Lists.newArrayList((Object[])new Integer[]{2, 3, 4, 7}), lcs);
    }

    @Test
    public void lcsTest5() {
        List left = Collections.EMPTY_LIST;
        List right = Collections.EMPTY_LIST;
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        List lcs = DiffUtil.longestCommonSubsequence((Comparison)emptyComparison, (List)left, (List)right);
        DiffUtilTest.assertEqualContents(Collections.EMPTY_LIST, lcs);
    }

    @Test
    public void lcsTest6() {
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{1, 2, null, 4, 5, null, 7});
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{6, 2, 9, null, null, 4, 1, 7});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        List lcs = DiffUtil.longestCommonSubsequence((Comparison)emptyComparison, (List)left, (List)right);
        DiffUtilTest.assertEqualContents(Lists.newArrayList((Object[])new Integer[]{2, null, null, 7}), lcs);
    }

    @Test
    public void insertionIndexTest1() {
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{8, 9, 2, 3, 4, 1, 0, 6});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{6, 2, 9, 3, 0, 4, 7});
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)1);
        Assert.assertEquals((long)4L, (long)insertionIndex);
        right = Lists.newArrayList((Object[])new Integer[]{6, 2, 3, 1, 0, 4, 7});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)9);
        Assert.assertEquals((long)1L, (long)insertionIndex);
        right = Lists.newArrayList((Object[])new Integer[]{6, 9, 2, 3, 1, 4, 7});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)5L, (long)insertionIndex);
        right = Lists.newArrayList((Object[])new Integer[]{6, 9, 2, 3, 1, 0, 4, 7});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)8);
        Assert.assertEquals((long)1L, (long)insertionIndex);
        right = Lists.newArrayList((Object[])new Integer[]{6, 8, 9, 2, 3, 1, 0});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)4);
        Assert.assertEquals((long)5L, (long)insertionIndex);
        right = Lists.newArrayList((Object[])new Integer[]{8, 9, 2, 3, 4, 1, 0});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)6);
        Assert.assertEquals((long)7L, (long)insertionIndex);
    }

    @Test
    public void insertionIndexTest2() {
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{4, 5, 6});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        int expectedIndex = right.size();
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3});
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 0, 2, 3});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 0});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
    }

    @Test
    public void insertionIndexTest3() {
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        boolean expectedIndex = false;
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3});
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)0L, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{0, 4, 1, 2, 3});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)0L, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{4, 0, 1, 2, 3});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)0L, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{4, 0, 5, 1, 2, 3});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)0L, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{4, 0, 5, 1, 2, 3, 6});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)0L, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{4, 0, 5, 1, 6, 2, 3});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)0L, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{4, 0, 5, 1, 6, 2, 7, 8, 3, 9});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)0L, (long)insertionIndex);
    }

    @Test
    public void insertionIndexTest4() {
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3});
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{4, 1, 2, 3});
        int expectedIndex = right.indexOf(1);
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{0, 6, 1, 5, 2, 4, 3});
        right = Lists.newArrayList((Object[])new Integer[]{7, 4, 1, 2, 3, 8});
        expectedIndex = right.indexOf(1);
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{5, 0, 6, 7, 1, 2, 4, 3});
        right = Lists.newArrayList((Object[])new Integer[]{7, 4, 1, 2, 9, 3, 8});
        expectedIndex = right.indexOf(7);
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
    }

    @Test
    public void insertionIndexTest5() {
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        int expectedIndex = right.size();
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 0});
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 0});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 0, 4});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 5, 0, 4});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{6, 1, 2, 3, 5, 0, 4});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 6, 2, 3, 5, 0, 4});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{9, 1, 6, 2, 7, 8, 3, 5, 0, 4});
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
    }

    @Test
    public void insertionIndexTest6() {
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 0});
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        int expectedIndex = right.indexOf(3) + 1;
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 5, 2, 4, 3, 6, 0});
        right = Lists.newArrayList((Object[])new Integer[]{8, 1, 2, 3, 4, 7});
        expectedIndex = right.indexOf(3) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 2, 4, 3, 7, 6, 0, 5});
        right = Lists.newArrayList((Object[])new Integer[]{8, 1, 2, 9, 3, 4, 7});
        expectedIndex = right.indexOf(7) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
    }

    @Test
    public void insertionIndexTest7() {
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{1, 0, 2, 3});
        int expectedIndex = right.indexOf(1) + 1;
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 2, 0, 3, 4});
        expectedIndex = right.indexOf(2) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 0, 4, 2, 3});
        expectedIndex = right.indexOf(1) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{5, 1, 4, 2, 0, 3});
        expectedIndex = right.indexOf(2) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{6, 1, 7, 8, 0, 9, 2, 10, 3, 5, 4});
        expectedIndex = right.indexOf(1) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
    }

    @Test
    public void insertionIndexTest8() {
        Comparison emptyComparison = DiffUtilTest.createEmptyComparison();
        ArrayList left = Lists.newArrayList((Object[])new Integer[]{1, 2, 0, 3});
        ArrayList right = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        int expectedIndex = right.indexOf(2) + 1;
        int insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 5, 2, 4, 0, 3, 6});
        right = Lists.newArrayList((Object[])new Integer[]{8, 1, 2, 3, 4, 7});
        expectedIndex = right.indexOf(2) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
        left = Lists.newArrayList((Object[])new Integer[]{1, 2, 4, 6, 8, 3, 0, 7, 5});
        right = Lists.newArrayList((Object[])new Integer[]{8, 1, 2, 9, 3, 4, 7});
        expectedIndex = right.indexOf(3) + 1;
        insertionIndex = DiffUtil.findInsertionIndex((Comparison)emptyComparison, (List)left, (List)right, (Object)0);
        Assert.assertEquals((long)expectedIndex, (long)insertionIndex);
    }

    @Test
    public void diceCoefficient() {
        String[] data = new String[]{"ceString", "ceString", "classe", "Classe", "Classe", "UneClasse", "package", "packagedeux", "", "MaClasse", "package", "packageASupprimer", "attribut", "reference", "aa", "aaaa", "aaa", "aaaa", "v1", "v2", "v", "v1", "a", "a", "a", "b", "a", "A", "GGG", "GGGGGG", "night", "nacht"};
        double[] similarities = new double[]{1.0, 0.8, 0.7692307692307693, 0.75, 0.0, 0.5454545454545454, 0.0, 0.5, 0.8, 0.5, 0.3333333333333333, 1.0, 0.0, 0.0, 0.5714285714285714, 0.25};
        int i = 0;
        while (i < data.length) {
            Assert.assertEquals((String)("Unexpected result of the dice coefficient for str1 = " + data[i] + " and str2 = " + data[i + 1]), (double)similarities[i / 2], (double)DiffUtil.diceCoefficient((String)data[i], (String)data[i + 1]), (double)Double.MIN_VALUE);
            Assert.assertEquals((String)("Dice coefficient was not symmetric for str1 = " + data[i] + " and str2 = " + data[i + 1]), (double)similarities[i / 2], (double)DiffUtil.diceCoefficient((String)data[i + 1], (String)data[i]), (double)Double.MIN_VALUE);
            i += 2;
        }
    }

    @Test
    public void diceCoefficientInvariants() {
        double sVV1 = DiffUtil.diceCoefficient((String)"v", (String)"v1");
        double sVV11 = DiffUtil.diceCoefficient((String)"v", (String)"v11");
        double sVV111 = DiffUtil.diceCoefficient((String)"v", (String)"v111");
        Assert.assertTrue((sVV1 > sVV11 && sVV11 > sVV111 ? 1 : 0) != 0);
        double sV1V2 = DiffUtil.diceCoefficient((String)"v1", (String)"v2");
        double sVV2 = DiffUtil.diceCoefficient((String)"v", (String)"v2");
        Assert.assertTrue((sV1V2 > sVV2 ? 1 : 0) != 0);
        double sV1V11 = DiffUtil.diceCoefficient((String)"v1", (String)"v11");
        Assert.assertTrue((sV1V11 > sVV11 && sV1V2 > sVV11 ? 1 : 0) != 0);
    }

    @Test
    public void diceCoefficient_444712() {
        double sT11T111;
        double sT11T11 = DiffUtil.diceCoefficient((String)"thing 11", (String)"thing 11");
        Assert.assertTrue((sT11T11 > (sT11T111 = DiffUtil.diceCoefficient((String)"thing 11", (String)"thing 111")) ? 1 : 0) != 0);
        Assert.assertTrue((sT11T11 <= 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((sT11T111 < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void diceCoefficientSameBigramsDifferentStrings() {
        double distinctButSameBigrams;
        double identical = DiffUtil.diceCoefficient((String)"pierre pascale", (String)"pierre pascale");
        Assert.assertTrue((identical > (distinctButSameBigrams = DiffUtil.diceCoefficient((String)"pierre pascale", (String)"pascale pierre")) ? 1 : 0) != 0);
        Assert.assertTrue((distinctButSameBigrams < 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((distinctButSameBigrams > 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void diceCoefficientFullWidth() {
        String[] data = new String[]{"\uff43\uff45\uff33\uff54\uff52\uff49\uff4e\uff47", "\uff43\uff45\uff33\uff54\uff52\uff49\uff4e\uff47", "\uff43\uff4c\uff41\uff53\uff53\uff45", "\uff23\uff4c\uff41\uff53\uff53\uff45", "\uff23\uff4c\uff41\uff53\uff53\uff45", "\uff35\uff4e\uff45\uff23\uff4c\uff41\uff53\uff53\uff45", "\uff50\uff41\uff43\uff4b\uff41\uff47\uff45", "\uff50\uff41\uff43\uff4b\uff41\uff47\uff45\uff44\uff45\uff55\uff58", "", "\uff2d\uff41\uff23\uff4c\uff41\uff53\uff53\uff45", "\uff50\uff41\uff43\uff4b\uff41\uff47\uff45", "\uff50\uff41\uff43\uff4b\uff41\uff47\uff45\uff21\uff33\uff55\uff50\uff50\uff52\uff49\uff4d\uff45\uff52", "\uff41\uff54\uff54\uff52\uff49\uff42\uff55\uff54", "\uff52\uff45\uff46\uff45\uff52\uff45\uff4e\uff43\uff45", "\uff41\uff41", "\uff41\uff41\uff41\uff41", "\uff41\uff41\uff41", "\uff41\uff41\uff41\uff41", "\uff56\uff11", "\uff56\uff12", "\uff56", "\uff56\uff11", "\uff41", "\uff41", "\uff41", "\uff42", "\uff41", "\uff21", "\uff27\uff27\uff27", "\uff27\uff27\uff27\uff27\uff27\uff27", "\uff4e\uff49\uff47\uff48\uff54", "\uff4e\uff41\uff43\uff48\uff54", "\uff46\uff55\uff4c\uff4c\uff57\uff49\uff44\uff54\uff48  \uff53\uff54\uff52\uff49\uff4e\uff47", "\uff46\uff55\uff4c\uff4c\uff57\uff49\uff44\uff54\uff48  \uff53\uff54\uff52\uff49\uff4e\uff47", "\uff46\uff55\uff4c\uff4c\uff57\uff49\uff44\uff54\uff48  \uff53\uff54\uff52\uff49\uff4e\uff47", "f\uff55\uff4c\uff4c\uff57\uff49\uff44\uff54\uff48  \uff23\uff48\uff41\uff52\uff33\uff45\uff51\uff55\uff45\uff4e\uff43\uff45"};
        double[] similarities = new double[]{1.0, 0.8, 0.7692307692307693, 0.75, 0.0, 0.5454545454545454, 0.0, 0.5, 0.8, 0.5, 0.3333333333333333, 1.0, 0.0, 0.0, 0.5714285714285714, 0.25, 1.0, 0.47368421052631576};
        int i = 0;
        while (i < data.length) {
            Assert.assertEquals((String)("Unexpected result of the dice coefficient for str1 = " + data[i] + " and str2 = " + data[i + 1]), (double)similarities[i / 2], (double)DiffUtil.diceCoefficient((String)data[i], (String)data[i + 1]), (double)Double.MIN_VALUE);
            Assert.assertEquals((String)("Dice coefficient was not symmetric for str1 = " + data[i] + " and str2 = " + data[i + 1]), (double)similarities[i / 2], (double)DiffUtil.diceCoefficient((String)data[i + 1], (String)data[i]), (double)Double.MIN_VALUE);
            i += 2;
        }
    }

    @Test
    public void diceCoefficientFailure() {
        try {
            DiffUtil.diceCoefficient(null, null);
            Assert.fail((String)"Expected exception has not been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            DiffUtil.diceCoefficient(null, (String)"aString");
            Assert.fail((String)"Expected exception has not been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            DiffUtil.diceCoefficient((String)"aString", null);
            Assert.fail((String)"Expected exception has not been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static <T> void assertEqualContents(List<T> list1, List<T> list2) {
        int size = list1.size();
        Assert.assertEquals((long)size, (long)list2.size());
        int i = 0;
        while (i < size) {
            Assert.assertEquals(list1.get(i), list2.get(i));
            ++i;
        }
    }

    private static Comparison createEmptyComparison() {
        Comparison emptyComparison = CompareFactory.eINSTANCE.createComparison();
        return emptyComparison;
    }
}

