/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.conflict.data.ConflictInputData;
import org.eclipse.emf.compare.tests.nodes.NodesPackage;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ComplexMergeTest {
    private ConflictInputData conflictInput = new ConflictInputData();
    private IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
    private List<Predicate<? super Diff>> rightConflictPermutation;
    private List<Predicate<? super Diff>> leftConflictPermutation;
    private List<Predicate<? super Diff>> otherPermutation;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        Collection rightConflictPermutations = Collections2.permutations(Arrays.asList(EMFComparePredicates.added((String)"Root.Node0"), EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1"), EMFComparePredicates.moved((String)"Root.Node6", (String)"containmentRef1"), EMFComparePredicates.added((String)"Root.Node9")));
        Collection leftConflictPermutations = Collections2.permutations(Arrays.asList(EMFComparePredicates.added((String)"Root.Node0"), EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1"), EMFComparePredicates.removed((String)"Root.Node5"), EMFComparePredicates.removed((String)"Root.Node6"), EMFComparePredicates.added((String)"Root.Node9")));
        Collection otherPermutations = Collections2.permutations(Arrays.asList(Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node5")), Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node7")), Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.added((String)"Root.Node8"))));
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (List otherPermutation : otherPermutations) {
            for (List rightConflictPermutation : rightConflictPermutations) {
                for (List leftConflictPermutation : leftConflictPermutations) {
                    data.add(new Object[]{leftConflictPermutation, rightConflictPermutation, otherPermutation});
                }
            }
        }
        return data;
    }

    public ComplexMergeTest(List<Predicate<? super Diff>> leftConflictpermutation, List<Predicate<? super Diff>> rightConflictPermutation, List<Predicate<? super Diff>> otherPermutation) {
        this.rightConflictPermutation = rightConflictPermutation;
        this.leftConflictPermutation = leftConflictpermutation;
        this.otherPermutation = otherPermutation;
    }

    @Test
    public void testLeftToRight() throws IOException {
        Diff diff;
        Resource left = this.conflictInput.getComplexLeft();
        Resource origin = this.conflictInput.getComplexOrigin();
        Resource right = this.conflictInput.getComplexRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        EMFCompare emfc = EMFCompare.builder().build();
        Comparison comp = emfc.compare((IComparisonScope)scope);
        for (Predicate<? super Diff> conflictingNode : this.rightConflictPermutation) {
            diff = this.getDiff(comp, DifferenceSource.RIGHT, conflictingNode);
            this.copyLeftToRight(diff);
        }
        for (Predicate<? super Diff> conflictingNode : this.leftConflictPermutation) {
            diff = this.getDiff(comp, DifferenceSource.LEFT, conflictingNode);
            this.copyLeftToRight(diff);
        }
        for (Predicate<? super Diff> otherNode : this.otherPermutation) {
            diff = this.getDiff(comp, otherNode);
            this.copyLeftToRight(diff);
        }
        ComplexMergeTest.assertEqualContents(comp, this.getNodes(left), this.getNodes(right));
    }

    @Test
    public void testRightToLeft() throws IOException {
        Diff diff;
        Resource left = this.conflictInput.getComplexLeft();
        Resource origin = this.conflictInput.getComplexOrigin();
        Resource right = this.conflictInput.getComplexRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        EMFCompare emfc = EMFCompare.builder().build();
        Comparison comp = emfc.compare((IComparisonScope)scope);
        for (Predicate<? super Diff> conflictingNode : this.leftConflictPermutation) {
            diff = this.getDiff(comp, DifferenceSource.LEFT, conflictingNode);
            this.copyRightToLeft(diff);
        }
        for (Predicate<? super Diff> conflictingNode : this.rightConflictPermutation) {
            diff = this.getDiff(comp, DifferenceSource.RIGHT, conflictingNode);
            this.copyRightToLeft(diff);
        }
        for (Predicate<? super Diff> otherNode : this.otherPermutation) {
            diff = this.getDiff(comp, otherNode);
            this.copyRightToLeft(diff);
        }
        ComplexMergeTest.assertEqualContents(comp, this.getNodes(left), this.getNodes(right));
    }

    private List<EObject> getNodes(Resource r) {
        EObject container = (EObject)r.getContents().get(0);
        return ComplexMergeTest.getAsList(container, NodesPackage.eINSTANCE.getNode_ContainmentRef1());
    }

    private Diff getDiff(Comparison comp, DifferenceSource side, Predicate<? super Diff> predicate) {
        return (Diff)Iterables.find((Iterable)comp.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)side), predicate));
    }

    private Diff getDiff(Comparison comp, Predicate<? super Diff> predicate) {
        return (Diff)Iterables.find((Iterable)comp.getDifferences(), predicate);
    }

    private void copyRightToLeft(Diff diff) {
        new BatchMerger(this.mergerRegistry).copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
    }

    private void copyLeftToRight(Diff diff) {
        new BatchMerger(this.mergerRegistry).copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
    }

    private static <T extends EObject> void assertEqualContents(Comparison comparison, List<T> list1, List<T> list2) {
        int size = list1.size();
        Assert.assertEquals((long)size, (long)list2.size());
        int i = 0;
        while (i < size) {
            EObject eObject1 = (EObject)list1.get(i);
            EObject eObject2 = (EObject)list2.get(i);
            Match match = comparison.getMatch(eObject1);
            if (match.getLeft() == eObject1) {
                Assert.assertEquals((Object)match.getRight(), (Object)eObject2);
            } else {
                Assert.assertEquals((Object)match.getRight(), (Object)eObject1);
                Assert.assertEquals((Object)match.getLeft(), (Object)eObject2);
            }
            ++i;
        }
    }

    private static List<EObject> getAsList(EObject object, EReference feature) {
        if (object != null) {
            Object value = object.eGet((EStructuralFeature)feature, false);
            ImmutableList asList = value instanceof List ? (ImmutableList)value : (value instanceof Iterable ? ImmutableList.copyOf((Iterable)((Iterable)value)) : (value != null ? ImmutableList.of((Object)((EObject)value)) : Collections.emptyList()));
            return asList;
        }
        return Collections.emptyList();
    }
}

