/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class AbstractMergeRunnableTest {
    protected Comparison comparison;
    protected IMerger.Registry2 mergerRegistry;
    protected IMerger2 merger;

    @Before
    public void setupMocks() {
        this.comparison = (Comparison)Mockito.mock(Comparison.class);
        this.mergerRegistry = (IMerger.Registry2)Mockito.mock(IMerger.Registry2.class);
        this.merger = (IMerger2)Mockito.mock(IMerger2.class);
        Mockito.when((Object)this.mergerRegistry.getHighestRankingMerger((Diff)ArgumentMatchers.any(Diff.class))).thenReturn((Object)this.merger);
        Mockito.when((Object)this.mergerRegistry.getMergersByRankDescending((Diff)ArgumentMatchers.any(Diff.class), (IMergeCriterion)ArgumentMatchers.any(IMergeCriterion.class))).thenAnswer((Answer)new Answer<Iterator<IMerger>>(){

            public Iterator<IMerger> answer(InvocationOnMock invocation) throws Throwable {
                return Iterators.singletonIterator((Object)AbstractMergeRunnableTest.this.merger);
            }
        });
    }

    protected void addConflictsToMockComparison(Conflict ... conflicts) {
        Mockito.when((Object)this.comparison.getConflicts()).thenReturn(this.newEList(conflicts));
    }

    protected void addDifferencesToMockComparison(Diff ... diffs) {
        Mockito.when((Object)this.comparison.getDifferences()).thenReturn(this.newEList(diffs));
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            Match match = (Match)Mockito.mock(Match.class);
            Mockito.when((Object)match.getComparison()).thenReturn((Object)this.comparison);
            Mockito.when((Object)diff.getMatch()).thenReturn((Object)match);
            ++n2;
        }
    }

    protected ReferenceChange mockReferenceChange(DifferenceSource side, DifferenceKind kind, String name) {
        ReferenceChange diff = (ReferenceChange)Mockito.mock(ReferenceChange.class, (String)name);
        Mockito.when((Object)diff.getSource()).thenReturn((Object)side);
        Mockito.when((Object)diff.getKind()).thenReturn((Object)kind);
        Mockito.when((Object)diff.getRefinedBy()).thenReturn((Object)new BasicEList());
        Mockito.when((Object)diff.getRefines()).thenReturn((Object)new BasicEList());
        Mockito.when((Object)diff.getState()).thenReturn((Object)DifferenceState.UNRESOLVED);
        Mockito.when((Object)diff.eAdapters()).thenReturn((Object)new BasicEList());
        return diff;
    }

    protected Conflict newConflict(Diff ... diffs) {
        Conflict conflict = (Conflict)Mockito.mock(Conflict.class);
        Mockito.when((Object)conflict.getKind()).thenReturn((Object)ConflictKind.REAL);
        Mockito.when((Object)conflict.getDifferences()).thenReturn(this.newEList(diffs));
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            Mockito.when((Object)diff.getConflict()).thenReturn((Object)conflict);
            ++n2;
        }
        return conflict;
    }

    protected EList<Conflict> newEList(Conflict ... diffs) {
        BasicEList list = new BasicEList();
        Conflict[] conflictArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Conflict diff = conflictArray[n2];
            list.add((Object)diff);
            ++n2;
        }
        return list;
    }

    protected EList<Diff> newEList(Diff ... diffs) {
        BasicEList list = new BasicEList();
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            list.add((Object)diff);
            ++n2;
        }
        return list;
    }

    protected void setNoConflictsInMockComparison() {
        this.addConflictsToMockComparison(new Conflict[0]);
    }

    protected void setThreeWayComparison() {
        Mockito.when((Object)this.comparison.isThreeWay()).thenReturn((Object)Boolean.TRUE);
    }

    protected void setTwoWayComparison() {
        Mockito.when((Object)this.comparison.isThreeWay()).thenReturn((Object)Boolean.FALSE);
    }

    protected void verifyHasBeenMarkedAsMerged(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasBeenMarkedAsMerged(diff);
            ++n2;
        }
    }

    protected void verifyHasBeenMarkedAsDiscarded(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasBeenMarkedAsDiscarded(diff);
            ++n2;
        }
    }

    protected void verifyHasBeenMarkedAsMerged(Diff diff) {
        ((Diff)Mockito.verify((Object)diff)).setState((DifferenceState)ArgumentMatchers.eq((Object)DifferenceState.MERGED));
    }

    protected void verifyHasBeenMarkedAsDiscarded(Diff diff) {
        ((Diff)Mockito.verify((Object)diff)).setState((DifferenceState)ArgumentMatchers.eq((Object)DifferenceState.DISCARDED));
    }

    protected void verifyHasBeenMergedLeftToRightOnly(Diff diff) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.atLeastOnce())).copyLeftToRight((Diff)ArgumentMatchers.same((Object)diff), (Monitor)ArgumentMatchers.any(Monitor.class));
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyRightToLeft((Diff)ArgumentMatchers.same((Object)diff), (Monitor)ArgumentMatchers.any(Monitor.class));
    }

    protected void verifyHasBeenMergedLeftToRightOnly(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasBeenMergedLeftToRightOnly(diff);
            ++n2;
        }
    }

    protected void verifyHasBeenMergedRightToLeftOnly(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasBeenMergedRightToLeftOnly(diff);
            ++n2;
        }
    }

    protected void verifyHasBeenMergedRightToLeftOnly(Diff diff) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.atLeastOnce())).copyRightToLeft((Diff)ArgumentMatchers.same((Object)diff), (Monitor)ArgumentMatchers.any(Monitor.class));
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyLeftToRight((Diff)ArgumentMatchers.same((Object)diff), (Monitor)ArgumentMatchers.any(Monitor.class));
    }

    protected void verifyHasNotBeenMerged(Diff diff) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyLeftToRight((Diff)ArgumentMatchers.same((Object)diff), (Monitor)ArgumentMatchers.any(Monitor.class));
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.never())).copyRightToLeft((Diff)ArgumentMatchers.same((Object)diff), (Monitor)ArgumentMatchers.any(Monitor.class));
    }

    protected void verifyHasNotBeenMerged(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyHasNotBeenMerged(diff);
            ++n2;
        }
    }

    protected void verifyStateIsUnchanged(Diff diff) {
        ((Diff)Mockito.verify((Object)diff, (VerificationMode)Mockito.never())).setState((DifferenceState)ArgumentMatchers.any(DifferenceState.class));
    }

    protected void verifyStateIsUnchanged(Diff ... diffs) {
        Diff[] diffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Diff diff = diffArray[n2];
            this.verifyStateIsUnchanged(diff);
            ++n2;
        }
    }
}

