/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.DecoratorFigure;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.swt.graphics.Color;

public class EdgeFigure
extends DecoratorFigure {
    private AbstractPointListShape fChildMarkerFigure;

    public EdgeFigure(Diff difference, boolean isThreeWay, ICompareColor compareColor, IFigure reference, Rectangle bounds, boolean isPhantom) {
        super(difference, isThreeWay, compareColor, reference, bounds, isPhantom);
    }

    protected AbstractPointListShape createFigureForPhantom() {
        return new PolylineConnection();
    }

    protected AbstractPointListShape createFigureForMarker() {
        return new Polygon();
    }

    @Override
    protected void buildFigureForPhantom() {
        if (this.getReference() instanceof PolylineConnection) {
            ((PolylineConnection)this.getMainFigure()).setPoints(((PolylineConnection)this.getReference()).getPoints().getCopy());
        }
    }

    @Override
    protected void buildFigureForMarker() {
        ((Shape)this.getMainFigure()).setOpaque(false);
        ((Shape)this.getMainFigure()).setFill(false);
        this.buildPolygon((AbstractPointListShape)this.getMainFigure());
        this.fChildMarkerFigure = this.createFigureForMarker();
        this.buildPolygon(this.fChildMarkerFigure);
        this.getMainFigure().add((IFigure)this.fChildMarkerFigure);
    }

    private void buildPolygon(AbstractPointListShape polygon) {
        LineSeg segRef;
        Point end;
        Point start;
        PointList refPoints = ((PolylineConnection)this.getReference()).getPoints();
        int nbPoints = refPoints.size();
        PointList targetPoints = new PointList();
        LineSeg previousTargetSeg = null;
        int i = 0;
        while (i < nbPoints) {
            start = refPoints.getPoint(i);
            if (i + 1 < nbPoints) {
                end = refPoints.getPoint(i + 1);
                segRef = new LineSeg(start, end);
                previousTargetSeg = this.computePoints(targetPoints, previousTargetSeg, segRef);
            } else if (previousTargetSeg != null) {
                targetPoints.addPoint(previousTargetSeg.getTerminus());
            }
            ++i;
        }
        previousTargetSeg = null;
        i = nbPoints - 1;
        while (i >= 0) {
            start = refPoints.getPoint(i);
            if (i - 1 >= 0) {
                end = refPoints.getPoint(i - 1);
                segRef = new LineSeg(start, end);
                previousTargetSeg = this.computePoints(targetPoints, previousTargetSeg, segRef);
            } else if (previousTargetSeg != null) {
                targetPoints.addPoint(previousTargetSeg.getTerminus());
            }
            --i;
        }
        polygon.setPoints(targetPoints);
    }

    @Override
    protected void highlightForMarker(IFigure figure) {
        Color strokeColor = this.getStrokeColor(true);
        ((AbstractPointListShape)figure).setForegroundColor(strokeColor);
        ((AbstractPointListShape)figure).setLineWidth(((Shape)figure).getLineWidth() + 1);
        this.fChildMarkerFigure.setForegroundColor(strokeColor);
        this.fChildMarkerFigure.setBackgroundColor(strokeColor);
        this.fChildMarkerFigure.setAlpha(this.getAlpha());
        this.fChildMarkerFigure.setFill(true);
    }

    @Override
    protected void unhighlightForMarker(IFigure figure) {
        Color strokeColor = this.getStrokeColor(false);
        ((AbstractPointListShape)figure).setForegroundColor(strokeColor);
        ((AbstractPointListShape)figure).setLineWidth(((Shape)figure).getLineWidth() - 1);
        this.fChildMarkerFigure.setForegroundColor(strokeColor);
        this.fChildMarkerFigure.setBackgroundColor(strokeColor);
        this.fChildMarkerFigure.setFill(false);
    }

    private LineSeg computePoints(PointList targetPoints, LineSeg previousTargetSeg, LineSeg segRef) {
        Point target = segRef.locatePoint(0.0, (long)this.getDecoratorThickness(), LineSeg.Sign.POSITIVE);
        LineSeg targetSeg = segRef.getParallelLineSegThroughPoint(target);
        if (previousTargetSeg != null) {
            Point instersection = targetSeg.intersect(previousTargetSeg, 1);
            if (instersection != null) {
                targetPoints.addPoint(instersection);
            } else {
                targetPoints.addPoint(previousTargetSeg.getTerminus());
                targetPoints.addPoint(targetSeg.getOrigin());
            }
        } else {
            targetPoints.addPoint(targetSeg.getOrigin());
        }
        return targetSeg;
    }
}

