/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitCompare;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitInput;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMerge;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=GitTestRunner.class)
public class RenamedControlledResourceTests {
    @GitMerge(local="master", remote="branch")
    @GitInput(value="data/renamedControlledResources/renameNoConflicts.zip")
    public void testMergeNoConflictRemoteRename(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject iProject = projects.get(0);
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.getFile("file1.ecore").exists());
        Assert.assertFalse((boolean)iProject.getFile("file2.ecore").exists());
        Assert.assertTrue((boolean)iProject.getFile("file2_new.ecore").exists());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource testRoot = resourceSet.getResource(URI.createPlatformResourceURI((String)"/renameNoConflicts/file1.ecore", (boolean)true), true);
        Resource testChild = resourceSet.getResource(URI.createPlatformResourceURI((String)"/renameNoConflicts/file2_new.ecore", (boolean)true), true);
        EPackage testRootPack = (EPackage)testRoot.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)testRootPack.getName());
        EPackage testChildPack = (EPackage)testRootPack.getESubpackages().get(0);
        Assert.assertEquals((Object)"child", (Object)testChildPack.getName());
        Assert.assertSame((Object)testChild, (Object)((InternalEObject)testChildPack).eDirectResource());
        EClass nonConflictingClass = (EClass)testRootPack.getEClassifiers().get(0);
        Assert.assertEquals((Object)"NonConflicting", (Object)nonConflictingClass.getName());
        EClass testC1 = (EClass)testChildPack.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
    }

    @GitMerge(local="branch", remote="master")
    @GitInput(value="data/renamedControlledResources/renameNoConflicts.zip")
    public void testMergeNoConflictLocalRename(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject iProject = projects.get(0);
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.getFile("file1.ecore").exists());
        Assert.assertFalse((boolean)iProject.getFile("file2.ecore").exists());
        Assert.assertTrue((boolean)iProject.getFile("file2_new.ecore").exists());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource testRoot = resourceSet.getResource(URI.createPlatformResourceURI((String)"/renameNoConflicts/file1.ecore", (boolean)true), true);
        Resource testChild = resourceSet.getResource(URI.createPlatformResourceURI((String)"/renameNoConflicts/file2_new.ecore", (boolean)true), true);
        EPackage testRootPack = (EPackage)testRoot.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)testRootPack.getName());
        EPackage testChildPack = (EPackage)testRootPack.getESubpackages().get(0);
        Assert.assertEquals((Object)"child", (Object)testChildPack.getName());
        Assert.assertSame((Object)testChild, (Object)((InternalEObject)testChildPack).eDirectResource());
        EClass nonConflictingClass = (EClass)testRootPack.getEClassifiers().get(0);
        Assert.assertEquals((Object)"NonConflicting", (Object)nonConflictingClass.getName());
        EClass testC1 = (EClass)testChildPack.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
    }

    @GitMerge(local="master", remote="branch")
    @GitInput(value="data/renamedControlledResources/renameNoConflictsLocalChanges.zip")
    public void testMergeNoConflictRemoteRenameLocalChanges(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject iProject = projects.get(0);
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.getFile("file1.ecore").exists());
        Assert.assertFalse((boolean)iProject.getFile("file2.ecore").exists());
        Assert.assertTrue((boolean)iProject.getFile("file2_new.ecore").exists());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource testRoot = resourceSet.getResource(URI.createPlatformResourceURI((String)"/renameNoConflictsLocalChanges/file1.ecore", (boolean)true), true);
        Resource testChild = resourceSet.getResource(URI.createPlatformResourceURI((String)"/renameNoConflictsLocalChanges/file2_new.ecore", (boolean)true), true);
        EPackage testRootPack = (EPackage)testRoot.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)testRootPack.getName());
        EPackage testChildPack = (EPackage)testRootPack.getESubpackages().get(0);
        Assert.assertEquals((Object)"child", (Object)testChildPack.getName());
        Assert.assertSame((Object)testChild, (Object)((InternalEObject)testChildPack).eDirectResource());
        EClass nonConflictingClass = (EClass)testRootPack.getEClassifiers().get(0);
        Assert.assertEquals((Object)"NonConflicting", (Object)nonConflictingClass.getName());
        EClass testC1 = (EClass)testChildPack.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        EClass testNewClass = (EClass)testChildPack.getEClassifiers().get(1);
        Assert.assertEquals((Object)"NewClassInRemotelyRenamedPackage", (Object)testNewClass.getName());
    }

    @GitCompare(local="master", remote="branch", file="file1.ecore")
    @GitInput(value="data/renamedControlledResources/renameNoConflicts.zip")
    public void testComparisonNoConflictRemoteRename(Comparison comparison) throws Exception {
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        Assert.assertEquals((long)0L, (long)comparison.getDiagnostic().getCode());
        Assert.assertEquals((long)3L, (long)comparison.getMatchedResources().size());
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.instanceOf(ReferenceChange.class))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)))));
    }

    @GitCompare(local="branch", remote="master", file="file1.ecore")
    @GitInput(value="data/renamedControlledResources/renameNoConflicts.zip")
    public void testComparisonNoConflictLocalRename(Comparison comparison) throws Exception {
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        Assert.assertEquals((long)0L, (long)comparison.getDiagnostic().getCode());
        Assert.assertEquals((long)3L, (long)comparison.getMatchedResources().size());
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.instanceOf(ReferenceChange.class))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)))));
    }

    @GitMerge(local="master", remote="branch")
    @GitInput(value="data/renamedControlledResources/renameConflicts.zip")
    public void testMergeConflict(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject iProject = projects.get(0);
        Set conflicting = status.getConflicting();
        Assert.assertEquals((long)3L, (long)conflicting.size());
        Assert.assertTrue((boolean)conflicting.contains("renameConflicts/file1.ecore"));
        Assert.assertTrue((boolean)conflicting.contains("renameConflicts/file2_new.ecore"));
        Assert.assertTrue((boolean)conflicting.contains("renameConflicts/file2_other.ecore"));
        Assert.assertTrue((boolean)iProject.getFile("file1.ecore").exists());
        Assert.assertFalse((boolean)iProject.getFile("file2.ecore").exists());
        Assert.assertFalse((boolean)iProject.getFile("file2_new.ecore").exists());
        Assert.assertTrue((boolean)iProject.getFile("file2_other.ecore").exists());
    }

    @GitCompare(local="master", remote="branch", file="file1.ecore")
    @GitInput(value="data/renamedControlledResources/renameConflicts.zip")
    public void testComparisonConflict(Comparison comparison) throws Exception {
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Assert.assertEquals((long)0L, (long)comparison.getDiagnostic().getCode());
        Assert.assertEquals((long)4L, (long)comparison.getMatchedResources().size());
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)))));
        Assert.assertEquals((long)2L, (long)((Conflict)comparison.getConflicts().get(0)).getDifferences().size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)((Conflict)comparison.getConflicts().get(0)).getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)))));
    }
}

