/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.match;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ScopeQuery;
import org.eclipse.emf.compare.match.eobject.internal.ProximityIndex;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class ProximityIndexTest {
    @Test
    public void neverMatchWhenDistanceIsMax() throws Exception {
        ProximityEObjectMatcher.DistanceFunction notAChance = new ProximityEObjectMatcher.DistanceFunction(){

            public double distance(Comparison inProgress, EObject a, EObject b) {
                return Double.MAX_VALUE;
            }

            public boolean areIdentic(Comparison inProgress, EObject a, EObject b) {
                return false;
            }
        };
        ScopeQuery alwaysIn = new ScopeQuery(){

            public boolean isInScope(EObject any) {
                return true;
            }
        };
        ProximityIndex index = new ProximityIndex(notAChance, alwaysIn);
        this.fillIndex(index, EObjectIndex.Side.LEFT, EcoreUtil.copy((EObject)EcorePackage.eINSTANCE));
        this.fillIndex(index, EObjectIndex.Side.RIGHT, EcoreUtil.copy((EObject)EcorePackage.eINSTANCE));
        Comparison comp = CompareFactory.eINSTANCE.createComparison();
        for (EObject leftElement : index.getValuesStillThere(EObjectIndex.Side.LEFT)) {
            Assert.assertNull((String)"With a distance which always return Double.MAX_VALUE we should never find a closest.", (Object)index.findClosests(comp, leftElement, EObjectIndex.Side.LEFT));
        }
    }

    private void fillIndex(ProximityIndex index, EObjectIndex.Side side, EObject model) {
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            index.index(eObj, side);
        }
    }
}

