/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.association;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.tests.postprocess.data.TestPostProcessor;
import org.eclipse.emf.compare.uml2.internal.AssociationChange;
import org.eclipse.emf.compare.uml2.internal.MultiplicityElementChange;
import org.eclipse.emf.compare.uml2.internal.postprocessor.MultiplicityElementChangePostProcessor;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.association.data.AssociationInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddAssociationTest
extends AbstractUMLTest {
    private AssociationInputData input = new AssociationInputData();

    @BeforeClass
    public static void setupClass() {
        AddAssociationTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddAssociationTest.resetRegistries();
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCaseFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            Comparison comparison = this.compare((Notifier)left, (Notifier)right);
            this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeRtLA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeRtLA10UseCaseFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeLtRA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRA10UseCaseFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCaseFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Right();
            Resource right = this.input.getA1Left();
            Comparison comparison = this.compare((Notifier)left, (Notifier)right);
            this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeRtLA11UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeRtLA11UseCaseFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Right();
            Resource right = this.input.getA1Left();
            this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeLtRA11UseCase() throws IOException {
        Resource left = this.input.getA1Right();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRA11UseCaseFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Right();
            Resource right = this.input.getA1Left();
            this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase3wayFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
            this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeRtLA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeRtLA10UseCase3wayFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeLtRA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRA10UseCase3wayFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCase3wayFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
            this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeRtLA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testMergeRtLA11UseCase3wayFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Test
    public void testMergeLtRA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
    }

    @Test
    public void testMergeLtRA11UseCase3wayFilter() throws IOException {
        try {
            this.enableCascadingFilter();
            Resource left = this.input.getA1Left();
            Resource right = this.input.getA1Right();
            this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)20L, (long)differences.size());
        Predicate addAssociationDescription = null;
        Predicate addNavigableOwnedEndClass1InAssociationDescription = null;
        Predicate addNavigableOwnedEndClass2InAssociationDescription = null;
        Predicate addRefAssociationInPropertyClass1Description = null;
        Predicate addRefTypeInPropertyClass1Description = null;
        Predicate addRefAssociationInPropertyClass2Description = null;
        Predicate addRefTypeInPropertyClass2Description = null;
        Predicate<? super Diff> addLiteralIntegerInClass1Description = null;
        Predicate<? super Diff> addUnlimitedNaturalInClass1Description = null;
        Predicate<? super Diff> addLiteralIntegerInClass2Description = null;
        Predicate<? super Diff> addUnlimitedNaturalInClass2Description = null;
        Predicate addMemberEndClass1InAssociationDescription = null;
        Predicate addMemberEndClass2InAssociationDescription = null;
        Predicate addOwnedEndClass1Description = null;
        Predicate addOwnedEndClass2Description = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addAssociationDescription = EMFComparePredicates.removed((String)"myModel.class1sToClass2s");
            addNavigableOwnedEndClass1InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class1s");
            addNavigableOwnedEndClass2InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class2s");
            addRefAssociationInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"association", (String)"myModel.class1sToClass2s", null);
            addRefTypeInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"type", (String)"myModel.Class1", null);
            addRefAssociationInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"association", (String)"myModel.class1sToClass2s", null);
            addRefTypeInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"type", (String)"myModel.Class2", null);
            addLiteralIntegerInClass1Description = AddAssociationTest.removedLowerValueIn("myModel.class1sToClass2s.class1s");
            addUnlimitedNaturalInClass1Description = AddAssociationTest.removedUpperValueIn("myModel.class1sToClass2s.class1s");
            addLiteralIntegerInClass2Description = AddAssociationTest.removedLowerValueIn("myModel.class1sToClass2s.class2s");
            addUnlimitedNaturalInClass2Description = AddAssociationTest.removedUpperValueIn("myModel.class1sToClass2s.class2s");
            addMemberEndClass1InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class1s");
            addMemberEndClass2InAssociationDescription = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class2s");
            addOwnedEndClass1Description = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class1s");
            addOwnedEndClass2Description = EMFComparePredicates.removedFromReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class2s");
        } else {
            addAssociationDescription = EMFComparePredicates.added((String)"myModel.class1sToClass2s");
            addNavigableOwnedEndClass1InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class1s");
            addNavigableOwnedEndClass2InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"navigableOwnedEnd", (String)"myModel.class1sToClass2s.class2s");
            addRefAssociationInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"association", null, (String)"myModel.class1sToClass2s");
            addRefTypeInPropertyClass1Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class1s", (String)"type", null, (String)"myModel.Class1");
            addRefAssociationInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"association", null, (String)"myModel.class1sToClass2s");
            addRefTypeInPropertyClass2Description = EMFComparePredicates.changedReference((String)"myModel.class1sToClass2s.class2s", (String)"type", null, (String)"myModel.Class2");
            addLiteralIntegerInClass1Description = AddAssociationTest.addedLowerValueIn("myModel.class1sToClass2s.class1s");
            addUnlimitedNaturalInClass1Description = AddAssociationTest.addedUpperValueIn("myModel.class1sToClass2s.class1s");
            addLiteralIntegerInClass2Description = AddAssociationTest.addedLowerValueIn("myModel.class1sToClass2s.class2s");
            addUnlimitedNaturalInClass2Description = AddAssociationTest.addedUpperValueIn("myModel.class1sToClass2s.class2s");
            addMemberEndClass1InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class1s");
            addMemberEndClass2InAssociationDescription = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"memberEnd", (String)"myModel.class1sToClass2s.class2s");
            addOwnedEndClass1Description = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class1s");
            addOwnedEndClass2Description = EMFComparePredicates.addedToReference((String)"myModel.class1sToClass2s", (String)"ownedEnd", (String)"myModel.class1sToClass2s.class2s");
        }
        Diff addAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addAssociationDescription);
        Diff addNavigableOwnedEndClass1InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addNavigableOwnedEndClass1InAssociationDescription);
        Diff addNavigableOwnedEndClass2InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addNavigableOwnedEndClass2InAssociationDescription);
        Diff addRefAssociationInPropertyClass1 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefAssociationInPropertyClass1Description);
        Diff addRefTypeInPropertyClass1 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefTypeInPropertyClass1Description);
        Diff addRefAssociationInPropertyClass2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefAssociationInPropertyClass2Description);
        Diff addRefTypeInPropertyClass2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefTypeInPropertyClass2Description);
        Diff addLiteralIntegerInClass1 = (Diff)Iterators.find(differences.iterator(), addLiteralIntegerInClass1Description);
        Diff addUnlimitedNaturalInClass1 = (Diff)Iterators.find(differences.iterator(), addUnlimitedNaturalInClass1Description);
        Diff addLiteralIntegerInClass2 = (Diff)Iterators.find(differences.iterator(), addLiteralIntegerInClass2Description);
        Diff addUnlimitedNaturalInClass2 = (Diff)Iterators.find(differences.iterator(), addUnlimitedNaturalInClass2Description);
        Diff addMemberEndClass1InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addMemberEndClass1InAssociationDescription);
        Diff addMemberEndClass2InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addMemberEndClass2InAssociationDescription);
        Diff addOwnedEndClass1InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addOwnedEndClass1Description);
        Diff addOwnedEndClass2InAssociation = (Diff)Iterators.find(differences.iterator(), (Predicate)addOwnedEndClass2Description);
        Assert.assertNotNull((Object)addNavigableOwnedEndClass1InAssociation);
        Assert.assertNotNull((Object)addNavigableOwnedEndClass2InAssociation);
        Assert.assertNotNull((Object)addAssociation);
        Assert.assertNotNull((Object)addRefAssociationInPropertyClass1);
        Assert.assertNotNull((Object)addRefTypeInPropertyClass1);
        Assert.assertNotNull((Object)addRefAssociationInPropertyClass2);
        Assert.assertNotNull((Object)addRefTypeInPropertyClass2);
        Assert.assertNotNull((Object)addLiteralIntegerInClass1);
        Assert.assertNotNull((Object)addUnlimitedNaturalInClass1);
        Assert.assertNotNull((Object)addLiteralIntegerInClass2);
        Assert.assertNotNull((Object)addUnlimitedNaturalInClass2);
        Assert.assertNotNull((Object)addMemberEndClass1InAssociation);
        Assert.assertNotNull((Object)addMemberEndClass2InAssociation);
        Assert.assertNotNull((Object)addOwnedEndClass1InAssociation);
        Assert.assertNotNull((Object)addOwnedEndClass2InAssociation);
        Assert.assertEquals((long)1L, (long)AddAssociationTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(AssociationChange.class)));
        Diff addUMLAssociation = null;
        addUMLAssociation = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(AssociationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(AssociationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLAssociation);
        Assert.assertEquals((long)15L, (long)addUMLAssociation.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addAssociation));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addNavigableOwnedEndClass1InAssociation));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addNavigableOwnedEndClass2InAssociation));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addRefAssociationInPropertyClass1));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addRefTypeInPropertyClass1));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addRefAssociationInPropertyClass2));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addRefTypeInPropertyClass2));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addMemberEndClass1InAssociation));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addMemberEndClass2InAssociation));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addOwnedEndClass1InAssociation));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains((Object)addOwnedEndClass2InAssociation));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains(Iterators.find((Iterator)addLiteralIntegerInClass1.getRefines().iterator(), (Predicate)Predicates.instanceOf(MultiplicityElementChange.class))));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains(Iterators.find((Iterator)addUnlimitedNaturalInClass1.getRefines().iterator(), (Predicate)Predicates.instanceOf(MultiplicityElementChange.class))));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains(Iterators.find((Iterator)addLiteralIntegerInClass2.getRefines().iterator(), (Predicate)Predicates.instanceOf(MultiplicityElementChange.class))));
        Assert.assertTrue((boolean)addUMLAssociation.getRefinedBy().contains(Iterators.find((Iterator)addUnlimitedNaturalInClass2.getRefines().iterator(), (Predicate)Predicates.instanceOf(MultiplicityElementChange.class))));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)2L, (long)addRefAssociationInPropertyClass1.getRequires().size());
            Assert.assertTrue((boolean)addRefAssociationInPropertyClass1.getRequires().contains((Object)addOwnedEndClass1InAssociation));
            Assert.assertTrue((boolean)addRefAssociationInPropertyClass1.getRequires().contains((Object)addAssociation));
            Assert.assertEquals((long)1L, (long)addRefTypeInPropertyClass1.getRequires().size());
            Assert.assertTrue((boolean)addRefTypeInPropertyClass1.getRequires().contains((Object)addOwnedEndClass1InAssociation));
            Assert.assertEquals((long)2L, (long)addRefAssociationInPropertyClass2.getRequires().size());
            Assert.assertTrue((boolean)addRefAssociationInPropertyClass2.getRequires().contains((Object)addOwnedEndClass2InAssociation));
            Assert.assertTrue((boolean)addRefAssociationInPropertyClass2.getRequires().contains((Object)addAssociation));
            Assert.assertEquals((long)1L, (long)addRefTypeInPropertyClass2.getRequires().size());
            Assert.assertTrue((boolean)addRefTypeInPropertyClass2.getRequires().contains((Object)addOwnedEndClass2InAssociation));
            Assert.assertEquals((long)0L, (long)addAssociation.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUMLAssociation.getRequires().size());
            Assert.assertEquals((long)2L, (long)addNavigableOwnedEndClass1InAssociation.getRequires().size());
            Assert.assertTrue((boolean)addNavigableOwnedEndClass1InAssociation.getRequires().contains((Object)addAssociation));
            Assert.assertTrue((boolean)addNavigableOwnedEndClass1InAssociation.getRequires().contains((Object)addOwnedEndClass1InAssociation));
            Assert.assertEquals((long)2L, (long)addNavigableOwnedEndClass2InAssociation.getRequires().size());
            Assert.assertTrue((boolean)addNavigableOwnedEndClass2InAssociation.getRequires().contains((Object)addAssociation));
            Assert.assertTrue((boolean)addNavigableOwnedEndClass2InAssociation.getRequires().contains((Object)addOwnedEndClass2InAssociation));
            Assert.assertEquals((long)1L, (long)addLiteralIntegerInClass1.getRequires().size());
            Assert.assertTrue((boolean)addLiteralIntegerInClass1.getRequires().contains((Object)addOwnedEndClass1InAssociation));
            Assert.assertEquals((long)1L, (long)addUnlimitedNaturalInClass1.getRequires().size());
            Assert.assertTrue((boolean)addUnlimitedNaturalInClass1.getRequires().contains((Object)addOwnedEndClass1InAssociation));
            Assert.assertEquals((long)1L, (long)addLiteralIntegerInClass2.getRequires().size());
            Assert.assertTrue((boolean)addLiteralIntegerInClass2.getRequires().contains((Object)addOwnedEndClass2InAssociation));
            Assert.assertEquals((long)1L, (long)addUnlimitedNaturalInClass2.getRequires().size());
            Assert.assertTrue((boolean)addUnlimitedNaturalInClass2.getRequires().contains((Object)addOwnedEndClass2InAssociation));
        } else {
            Assert.assertEquals((long)0L, (long)addNavigableOwnedEndClass1InAssociation.getRequires().size());
            Assert.assertEquals((long)0L, (long)addNavigableOwnedEndClass2InAssociation.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefAssociationInPropertyClass1.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefTypeInPropertyClass1.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefAssociationInPropertyClass2.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefTypeInPropertyClass2.getRequires().size());
            Assert.assertEquals((long)8L, (long)addAssociation.getRequires().size());
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addNavigableOwnedEndClass1InAssociation));
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addNavigableOwnedEndClass2InAssociation));
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addRefAssociationInPropertyClass1));
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addRefAssociationInPropertyClass2));
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addOwnedEndClass1InAssociation));
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addOwnedEndClass2InAssociation));
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addMemberEndClass1InAssociation));
            Assert.assertTrue((boolean)addAssociation.getRequires().contains((Object)addMemberEndClass2InAssociation));
            Assert.assertEquals((long)0L, (long)addUMLAssociation.getRequires().size());
            Assert.assertEquals((long)0L, (long)addLiteralIntegerInClass1.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUnlimitedNaturalInClass1.getRequires().size());
            Assert.assertEquals((long)0L, (long)addLiteralIntegerInClass2.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUnlimitedNaturalInClass2.getRequires().size());
            this.testIntersections(comparison);
        }
    }

    private static Predicate<? super Diff> addedLowerValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"lowerValue")});
    }

    private static Predicate<? super Diff> addedUpperValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"upperValue")});
    }

    private static Predicate<? super Diff> removedLowerValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"lowerValue")});
    }

    private static Predicate<? super Diff> removedUpperValueIn(String qualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.onFeature((String)"upperValue")});
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }

    @Override
    protected void registerPostProcessors(IPostProcessor.Descriptor.Registry<String> postProcessorRegistry) {
        super.registerPostProcessors(postProcessorRegistry);
        postProcessorRegistry.put((Object)MultiplicityElementChangePostProcessor.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/uml2/\\d\\.0\\.0/UML"), null, (IPostProcessor)new MultiplicityElementChangePostProcessor(), 25));
    }
}

