/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jdo.spi.PersistenceCapable;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.jpox.JpoxDataStore;
import org.eclipse.emf.teneo.jpox.JpoxHelper;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.jpox.StateManager;
import org.jpox.sco.SCOList;

public class JpoxUtil {
    public static void repairContainer(Object value) {
        if (value instanceof StateManager && ((StateManager)value).isDeleted(((StateManager)value).getObject())) {
            return;
        }
        EContainerRepairControl.repair((Object)JpoxUtil.checkGetObject(value));
    }

    public static Object checkGetObject(Object value) {
        if (value instanceof StateManager) {
            return ((StateManager)value).getObject();
        }
        return value;
    }

    public static JpoxDataStore getCreateDataStore(Properties props) {
        String name = props.getProperty("name");
        JpoxDataStore jds = JpoxHelper.INSTANCE.getDataStore(name);
        if (jds != null) {
            return jds;
        }
        Properties properties = new Properties();
        properties.setProperty("javax.jdo.option.ConnectionDriverName", JpoxUtil.doTrim(props.getProperty("dbdriver")));
        properties.setProperty("javax.jdo.option.ConnectionURL", JpoxUtil.doTrim(props.getProperty("dburl")));
        properties.setProperty("javax.jdo.option.ConnectionUserName", JpoxUtil.doTrim(props.getProperty("dbuser")));
        properties.setProperty("javax.jdo.option.ConnectionPassword", JpoxUtil.doTrim(props.getProperty("dbpassword")));
        properties.setProperty("javax.jdo.mapping.Catalog", JpoxUtil.doTrim(props.getProperty("dbname")));
        EPackage[] epacks = StoreUtil.getEPackages((String)JpoxUtil.doTrim(props.getProperty("nsuri")));
        jds = JpoxHelper.INSTANCE.createRegisterDataStore(name);
        jds.setProperties(properties);
        jds.setEPackages(epacks);
        jds.initialize();
        return jds;
    }

    private static String doTrim(String totrim) {
        if (totrim == null) {
            return null;
        }
        return totrim.trim();
    }

    public static boolean updateListWithListElements(List attachedList, List detachedList) {
        boolean updated = false;
        ArrayList newCopy = new ArrayList(detachedList);
        Iterator attachedIter = attachedList.iterator();
        while (attachedIter.hasNext()) {
            Object attachedElement = attachedIter.next();
            if (JpoxUtil.isPresent(newCopy, attachedElement)) continue;
            attachedIter.remove();
            updated = true;
        }
        ArrayList oldCopy = new ArrayList(attachedList);
        for (Object element : detachedList) {
            if (JpoxUtil.isPresent(oldCopy, element)) continue;
            attachedList.add(element);
            updated = true;
        }
        int i = 0;
        while (i < detachedList.size()) {
            int newpos = i;
            Object element = detachedList.get(i);
            int oldpos = JpoxUtil.indexOf(attachedList, element);
            if (newpos != oldpos) {
                ((SCOList)attachedList).set(newpos, element, false);
                updated = true;
            }
            ++i;
        }
        return updated;
    }

    private static boolean isPresent(List list, Object obj) {
        if (!(obj instanceof PersistenceCapable)) {
            return list.contains(obj);
        }
        PersistenceCapable pc1 = (PersistenceCapable)obj;
        int i = 0;
        while (i < list.size()) {
            PersistenceCapable pc2 = (PersistenceCapable)list.get(i);
            if ((pc2.jdoGetObjectId() == null || pc1.jdoGetObjectId() == null) && pc2.equals(pc1)) {
                return true;
            }
            if (pc2.jdoGetObjectId() != null && pc1.jdoGetObjectId() != null && pc2.jdoGetObjectId().equals(pc1.jdoGetObjectId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int indexOf(List list, Object obj) {
        if (!(obj instanceof PersistenceCapable)) {
            return list.indexOf(obj);
        }
        PersistenceCapable pc1 = (PersistenceCapable)obj;
        int i = 0;
        while (i < list.size()) {
            PersistenceCapable pc2 = (PersistenceCapable)list.get(i);
            if ((pc2.jdoGetObjectId() == null || pc1.jdoGetObjectId() == null) && pc2.equals(pc1)) {
                return i;
            }
            if (pc2.jdoGetObjectId() != null && pc1.jdoGetObjectId() != null && pc2.jdoGetObjectId().equals(pc1.jdoGetObjectId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

