/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.ComplexNumber;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.DocumentRoot;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.EvenComplexNumberType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.MultiNumberType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.NumberType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.OddComplexNumberType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution.SubstitutionPackage;

public class SubstitutionValidator
extends EObjectValidator {
    public static final SubstitutionValidator INSTANCE = new SubstitutionValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitution";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final Collection EVEN_TYPE__ENUMERATION__VALUES = SubstitutionValidator.wrapEnumerationValues((Object[])new Object[]{new BigInteger("2"), new BigInteger("4"), new BigInteger("6"), new BigInteger("8")});
    public static final Collection ODD_TYPE__ENUMERATION__VALUES = SubstitutionValidator.wrapEnumerationValues((Object[])new Object[]{new BigInteger("1"), new BigInteger("3"), new BigInteger("5"), new BigInteger("7"), new BigInteger("9")});
    public static final BigInteger SIMPLE_NUMBER__MIN__VALUE = new BigInteger("1");
    public static final BigInteger SIMPLE_NUMBER__MAX__VALUE = new BigInteger("9");

    protected EPackage getEPackage() {
        return SubstitutionPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validateComplexNumber((ComplexNumber)value, diagnostics, context);
            }
            case 1: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 2: {
                return this.validateEvenComplexNumberType((EvenComplexNumberType)value, diagnostics, context);
            }
            case 3: {
                return this.validateMultiNumberType((MultiNumberType)value, diagnostics, context);
            }
            case 4: {
                return this.validateNumberType((NumberType)value, diagnostics, context);
            }
            case 5: {
                return this.validateOddComplexNumberType((OddComplexNumberType)value, diagnostics, context);
            }
            case 6: {
                return this.validateEvenType((BigInteger)value, diagnostics, context);
            }
            case 7: {
                return this.validateOddType((BigInteger)value, diagnostics, context);
            }
            case 8: {
                return this.validateSimpleNumber((BigInteger)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateComplexNumber(ComplexNumber complexNumber, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(complexNumber, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateEvenComplexNumberType(EvenComplexNumberType evenComplexNumberType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(evenComplexNumberType, diagnostics, context);
    }

    public boolean validateMultiNumberType(MultiNumberType multiNumberType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(multiNumberType, diagnostics, context);
    }

    public boolean validateNumberType(NumberType numberType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(numberType, diagnostics, context);
    }

    public boolean validateOddComplexNumberType(OddComplexNumberType oddComplexNumberType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(oddComplexNumberType, diagnostics, context);
    }

    public boolean validateEvenType(BigInteger evenType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateEvenType_Enumeration(evenType, diagnostics, context);
        return result;
    }

    public boolean validateEvenType_Enumeration(BigInteger evenType, DiagnosticChain diagnostics, Map context) {
        boolean result = EVEN_TYPE__ENUMERATION__VALUES.contains(evenType);
        if (!result && diagnostics != null) {
            this.reportEnumerationViolation(SubstitutionPackage.eINSTANCE.getEvenType(), evenType, EVEN_TYPE__ENUMERATION__VALUES, diagnostics, context);
        }
        return result;
    }

    public boolean validateOddType(BigInteger oddType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateOddType_Enumeration(oddType, diagnostics, context);
        return result;
    }

    public boolean validateOddType_Enumeration(BigInteger oddType, DiagnosticChain diagnostics, Map context) {
        boolean result = ODD_TYPE__ENUMERATION__VALUES.contains(oddType);
        if (!result && diagnostics != null) {
            this.reportEnumerationViolation(SubstitutionPackage.eINSTANCE.getOddType(), oddType, ODD_TYPE__ENUMERATION__VALUES, diagnostics, context);
        }
        return result;
    }

    public boolean validateSimpleNumber(BigInteger simpleNumber, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateSimpleNumber_Min(simpleNumber, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateSimpleNumber_Max(simpleNumber, diagnostics, context);
        }
        return result;
    }

    public boolean validateSimpleNumber_Min(BigInteger simpleNumber, DiagnosticChain diagnostics, Map context) {
        boolean result;
        boolean bl = result = simpleNumber.compareTo(SIMPLE_NUMBER__MIN__VALUE) >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(SubstitutionPackage.eINSTANCE.getSimpleNumber(), simpleNumber, SIMPLE_NUMBER__MIN__VALUE, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateSimpleNumber_Max(BigInteger simpleNumber, DiagnosticChain diagnostics, Map context) {
        boolean result;
        boolean bl = result = simpleNumber.compareTo(SIMPLE_NUMBER__MAX__VALUE) <= 0;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(SubstitutionPackage.eINSTANCE.getSimpleNumber(), simpleNumber, SIMPLE_NUMBER__MAX__VALUE, true, diagnostics, context);
        }
        return result;
    }
}

