/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.strategy.impl;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.mapping.strategy.impl.EntityResolvingNameStrategy;
import org.eclipse.emf.teneo.util.StoreUtil;

public class EntityInterfaceNameStrategy
extends EntityResolvingNameStrategy {
    private static Log log = LogFactory.getLog(EntityInterfaceNameStrategy.class);
    public static final EntityInterfaceNameStrategy INSTANCE = new EntityInterfaceNameStrategy();
    private PAnnotatedModel paModel;
    private ConcurrentHashMap<String, EClass> entityNameToEClass = new ConcurrentHashMap();
    private ExtensionManager extensionManager;

    public String toEntityName(EClass eClass) {
        if (eClass == EOBJECT_ECLASS) {
            return EOBJECT_ECLASS_NAME;
        }
        if (eClass == null) {
            throw new IllegalArgumentException("Passed eclass is null.This can occur if epackages which refer to eachother are placed in different ecore/xsd files and they are not read using one resource set. The reference from one epackage to another must be resolvable by EMF.");
        }
        if (eClass.getName() == null) {
            throw new IllegalArgumentException("EClass " + eClass.toString() + " has a null name." + "This can occur if epackages which refer to eachother are placed in different ecore/xsd files " + "and they are not read using one resource set. The reference from one epackage to another must be " + "resolvable by EMF.");
        }
        PAnnotatedEClass aClass = this.getPaModel().getPAnnotated(eClass);
        if (aClass != null && aClass.getEntity() != null && aClass.getEntity().getName() != null) {
            return aClass.getEntity().getName();
        }
        if (eClass.getInstanceClassName() != null) {
            return eClass.getInstanceClassName();
        }
        return eClass.getName();
    }

    public EClass toEClass(String eClassName) {
        if (eClassName == null) {
            throw new IllegalArgumentException("eClassName may not be null");
        }
        if (eClassName.compareTo(EOBJECT_ECLASS_NAME) == 0) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        EClass eClass = null;
        eClass = this.entityNameToEClass.get(eClassName);
        if (eClass != null) {
            return eClass;
        }
        for (PAnnotatedEPackage aPackage : this.getPaModel().getPaEPackages()) {
            for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                if (aClass.getEntity() == null || aClass.getEntity().getName() == null || aClass.getEntity().getName().compareTo(eClassName) != 0 || StoreUtil.isMapEntry(aClass.getModelEClass())) continue;
                if (eClass != null) {
                    throw new IllegalArgumentException("There is more than one EClass with the same name (" + eClassName + " in EPackage " + eClass.getEPackage().getName() + " and " + aPackage.getModelEPackage().getName() + ". A different EClassResolver should be used.");
                }
                eClass = aClass.getModelEClass();
            }
        }
        if (eClass != null) {
            this.entityNameToEClass.put(eClassName, eClass);
            return eClass;
        }
        for (PAnnotatedEPackage aPackage : this.getPaModel().getPaEPackages()) {
            for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                if (aClass.getEntity() == null || aClass.getEntity().getName() == null || aClass.getEntity().getName().compareTo(eClassName) != 0) continue;
                if (eClass != null) {
                    throw new IllegalArgumentException("There is more than one EClass with the same name (" + eClassName + " in EPackage " + eClass.getEPackage().getName() + " and " + aPackage.getModelEPackage().getName() + ". A different EClassResolver should be used.");
                }
                eClass = aClass.getModelEClass();
            }
        }
        if (eClass == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to retreive EClass for name: " + eClassName + ". This is no problem if this is a featuremap."));
            }
            return null;
        }
        this.entityNameToEClass.put(eClassName, eClass);
        return eClass;
    }

    public PAnnotatedModel getPaModel() {
        return this.paModel;
    }

    public void setPaModel(PAnnotatedModel paModel) {
        this.paModel = paModel;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }
}

